/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class FileUtils {
    public static String getRealPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            return FilenameUtils.normalizeNoEndSeparator((String)file.getAbsolutePath(), (boolean)true);
        }
    }

    public static File getRealFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ex) {
            return new File(FilenameUtils.normalizeNoEndSeparator((String)file.getAbsolutePath(), (boolean)true));
        }
    }

    public static File getAbsoluteFile(File file) {
        return new File(FilenameUtils.normalizeNoEndSeparator((String)file.getAbsolutePath(), (boolean)true));
    }

    public static File getAbsoluteFile(String pathname) {
        File file = new File(pathname);
        return new File(FilenameUtils.normalizeNoEndSeparator((String)file.getAbsolutePath(), (boolean)true));
    }

    public static String getBaseName(File f) {
        return FilenameUtils.getBaseName((String)f.getName());
    }

    public static boolean isRootFile(File f) {
        String pathname = FileUtils.getRealPath(f);
        String prefix = FilenameUtils.getPrefix((String)pathname);
        return pathname.equals(prefix);
    }

    public static boolean isSameFile(File f1, File f2) {
        String f1Path = FileUtils.getRealPath(f1);
        String f2Path = FileUtils.getRealPath(f2);
        return f1Path.equals(f2Path);
    }

    public static boolean isSubfolder(File folder, File file) {
        String folderPath = FileUtils.getRealPath(folder) + "/";
        String filePath = FileUtils.getRealPath(file);
        return filePath.startsWith(folderPath);
    }

    public static File removeExtension(File f) {
        String pathname = FilenameUtils.removeExtension((String)f.getPath());
        return FileUtils.getAbsoluteFile(pathname);
    }

    static void forceMkdir(File f) throws IOException {
        org.apache.commons.io.FileUtils.forceMkdir((File)f);
    }

    static File getFile(File folder, String ... names) {
        return org.apache.commons.io.FileUtils.getFile((File)folder, (String[])names);
    }

    static List<String> readLines(File file) throws IOException {
        return org.apache.commons.io.FileUtils.readLines((File)file);
    }

    static void writeStringToFile(File file, String contents) throws IOException {
        org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)contents);
    }

    static void forceDelete(File f) throws IOException {
        org.apache.commons.io.FileUtils.forceDelete((File)f);
    }

    static void moveFileToDirectory(File srcFile, File destDir, boolean createDestDir) throws IOException {
        org.apache.commons.io.FileUtils.moveFileToDirectory((File)srcFile, (File)destDir, (boolean)createDestDir);
    }

    static void moveDirectoryToDirectory(File src, File destDir, boolean createDestDir) throws IOException {
        org.apache.commons.io.FileUtils.moveDirectoryToDirectory((File)src, (File)destDir, (boolean)createDestDir);
    }

    static void moveFile(File srcFile, File destFile) throws IOException {
        org.apache.commons.io.FileUtils.moveFile((File)srcFile, (File)destFile);
    }

    static void moveDirectory(File srcDir, File destDir) throws IOException {
        org.apache.commons.io.FileUtils.moveDirectory((File)srcDir, (File)destDir);
    }

    static void copyDirectory(File srcDir, File destDir) throws IOException {
        org.apache.commons.io.FileUtils.copyDirectory((File)srcDir, (File)destDir);
    }
}

