/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin.mdiManager;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.ToolsWindowManager;
import org.gvsig.andami.ui.mdiFrame.MDIFrame;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.coreplugin.mdiManager.WindowInfoSupport;
import org.gvsig.coreplugin.mdiManager.frames.ExternalFrame;
import org.gvsig.coreplugin.mdiManager.frames.IFrame;
import org.gvsig.coreplugin.mdiManager.frames.InternalFrame;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameWindowSupport {
    private static Logger logger = LoggerFactory.getLogger(FrameWindowSupport.class);
    private Map frameView = new HashMap();
    private Map<IWindow, Object> viewFrame = new HashMap<IWindow, Object>();
    private Image icon;
    private WindowInfoSupport vis;
    private JFrame mainFrame;

    public FrameWindowSupport(MDIFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.icon = mainFrame.getIconImage();
    }

    public Iterator getWindowIterator() {
        return this.viewFrame.keySet().iterator();
    }

    public boolean contains(IWindow v) {
        return this.viewFrame.containsKey(v);
    }

    public boolean contains(JInternalFrame wnd) {
        return this.frameView.containsValue(wnd);
    }

    public JDialog getJDialog(IWindow p) {
        JDialog dlg = (JDialog)this.viewFrame.get(p);
        if (dlg == null) {
            ExternalFrame nuevo = new ExternalFrame(this.mainFrame);
            nuevo.getContentPane().add((JPanel)p);
            WindowInfo vi = this.vis.getWindowInfo(p);
            nuevo.setSize(this.getWidth(p, vi), this.getHeight(p, vi) + 30);
            nuevo.setTitle(vi.getTitle());
            nuevo.setResizable(vi.isResizable());
            nuevo.setMinimumSize(vi.getMinimumSize());
            if (vi.needPack()) {
                nuevo.pack();
            }
            this.viewFrame.put(p, nuevo);
            this.frameView.put(nuevo, p);
            nuevo.setModal(vi.isModal());
            this.closeOnHide(p);
            return nuevo;
        }
        return dlg;
    }

    public JInternalFrame getJInternalFrame(IWindow p) {
        JInternalFrame frame = null;
        try {
            for (Map.Entry<IWindow, Object> entry : this.viewFrame.entrySet()) {
                Component contents;
                if (!(entry.getKey() instanceof ToolsWindowManager.Window) || p != (contents = ((ToolsWindowManager.Window)entry.getKey()).getContents())) continue;
                frame = (JInternalFrame)entry.getValue();
            }
        }
        catch (Exception ex) {
            logger.warn("Can't get JInternalFrame from IWindow (" + p.getWindowInfo().getTitle() + ").", (Throwable)ex);
        }
        if (frame == null) {
            frame = (JInternalFrame)this.viewFrame.get(p);
        }
        if (frame == null) {
            JInternalFrame nuevo = this.createJInternalFrame(p);
            this.viewFrame.put(p, nuevo);
            this.frameView.put(nuevo, p);
            return nuevo;
        }
        return frame;
    }

    public Component getFrame(IWindow panel) {
        Object object = this.viewFrame.get(panel);
        if (object != null && object instanceof Component) {
            return (Component)object;
        }
        throw new RuntimeException(Messages.getText((String)"window_not_found") + ": " + panel.getWindowInfo().getTitle());
    }

    public JInternalFrame createJInternalFrame(IWindow p) {
        WindowInfo wi = this.vis.getWindowInfo(p);
        InternalFrame nuevo = new InternalFrame();
        if (this.icon != null) {
            nuevo.setFrameIcon(new ImageIcon(this.icon));
        }
        nuevo.getContentPane().add((JPanel)p);
        nuevo.setClosable(!wi.isNotClosable());
        nuevo.setSize(this.getWidth(p, wi), this.getHeight(p, wi));
        nuevo.setTitle(wi.getTitle());
        nuevo.setVisible(wi.isVisible());
        nuevo.setResizable(wi.isResizable());
        nuevo.setIconifiable(wi.isIconifiable());
        nuevo.setMaximizable(wi.isMaximizable());
        nuevo.setLocation(wi.getX(), wi.getY());
        nuevo.setMinimumSize(wi.getMinimumSize());
        this.closeOnHide(p);
        nuevo.setDefaultCloseOperation(2);
        return nuevo;
    }

    private void closeOnHide(final IWindow p) {
        ((JPanel)p).addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent ce) {
            }

            @Override
            public void componentMoved(ComponentEvent ce) {
            }

            @Override
            public void componentShown(ComponentEvent ce) {
            }

            @Override
            public void componentHidden(ComponentEvent ce) {
                PluginServices.getMDIManager().closeWindow(p);
            }
        });
    }

    public IWindow getWindow(Component dlg) {
        return (IWindow)this.frameView.get(dlg);
    }

    public void closeWindow(IWindow v) {
        Object c = this.viewFrame.remove(v);
        this.frameView.remove(c);
    }

    public void setX(IWindow win, int x) {
        IFrame frame = (IFrame)this.viewFrame.get(win);
        if (frame != null) {
            frame.setX(x);
        }
    }

    public void setY(IWindow win, int y) {
        IFrame frame = (IFrame)this.viewFrame.get(win);
        if (frame != null) {
            frame.setY(y);
        }
    }

    public void setHeight(IWindow win, int height) {
        IFrame frame = (IFrame)this.viewFrame.get(win);
        frame.setHeight(height);
    }

    public void setWidth(IWindow win, int width) {
        IFrame frame = (IFrame)this.viewFrame.get(win);
        frame.setWidth(width);
    }

    public void setTitle(IWindow win, String title) {
        IFrame frame = (IFrame)this.viewFrame.get(win);
        frame.setTitle(title);
    }

    public void setMinimumSize(IWindow win, Dimension minSize) {
        IFrame frame = (IFrame)this.viewFrame.get(win);
        frame.setMinimumSize(minSize);
    }

    public void setVis(WindowInfoSupport vis) {
        this.vis = vis;
    }

    private int getWidth(IWindow v) {
        WindowInfo vi = this.vis.getWindowInfo(v);
        if (vi.getWidth() == -1) {
            JPanel p = (JPanel)v;
            return p.getSize().width;
        }
        return vi.getWidth();
    }

    private int getWidth(IWindow v, WindowInfo wi) {
        if (wi.getWidth() == -1) {
            JPanel p = (JPanel)v;
            return p.getSize().width;
        }
        return wi.getWidth();
    }

    private int getHeight(IWindow v) {
        WindowInfo vi = this.vis.getWindowInfo(v);
        if (vi.getHeight() == -1) {
            JPanel p = (JPanel)v;
            return p.getSize().height;
        }
        return vi.getHeight();
    }

    private int getHeight(IWindow v, WindowInfo wi) {
        if (wi.getHeight() == -1) {
            JPanel p = (JPanel)v;
            return p.getSize().height;
        }
        return wi.getHeight();
    }

    public void updateWindowInfo(IWindow win, WindowInfo windowInfo) {
        Object o = this.viewFrame.get(win);
        if (windowInfo != null && o != null && o instanceof JComponent) {
            JComponent component = (JComponent)o;
            windowInfo.updateWidth(component.getWidth());
            windowInfo.updateHeight(component.getHeight());
            windowInfo.updateX(component.getX());
            windowInfo.updateY(component.getY());
            windowInfo.updateClosed(!component.isShowing());
            if (component instanceof JInternalFrame) {
                JInternalFrame iframe = (JInternalFrame)component;
                windowInfo.updateNormalBounds(iframe.getNormalBounds());
                windowInfo.updateMaximized(iframe.isMaximum());
            }
        }
    }
}

