/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin.menus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.plugins.config.generate.Menu;
import org.gvsig.andami.ui.mdiFrame.SelectableToolBar;
import org.gvsig.utils.XMLEntity;

public class ToolbarMenus
extends Extension
implements ActionListener {
    private final String ACTIONCOMMANDBASE = "CHANGE_VISIBILITY-";
    private final String MENUBASE = "Ver/Toolbars/";
    private final String ENABLEDIMAGE = "images/enabled.png";

    public void execute(String actionCommand) {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String toolbarName = e.getActionCommand().substring("CHANGE_VISIBILITY-".length());
        JMenuItem menu = PluginServices.getMainFrame().getMenuEntry(("Ver/Toolbars/" + toolbarName).split("/"));
        if (!toolbarName.equals("")) {
            boolean oldVisibility = PluginServices.getMainFrame().getToolbarVisibility(toolbarName);
            if (!oldVisibility) {
                URL icon = PluginServices.getPluginServices((Object)this).getClassLoader().getResource("images/enabled.png");
                menu.setIcon(new ImageIcon(icon));
                this.persistStatus(toolbarName, !oldVisibility);
            } else {
                menu.setIcon(null);
                this.persistStatus(toolbarName, !oldVisibility);
            }
            PluginServices.getMainFrame().setToolbarVisibility(toolbarName, !oldVisibility);
        }
    }

    public void initialize() {
        this.getPersistedStatus();
        SelectableToolBar[] toolBars = PluginServices.getMainFrame().getToolbars();
        for (int i = toolBars.length - 1; i > 0; --i) {
            Menu menu = new Menu();
            menu.setActionCommand("CHANGE_VISIBILITY-" + toolBars[i].getName());
            menu.setText("Ver/Toolbars/" + toolBars[i].getName());
            if (toolBars[i].getAndamiVisibility()) {
                menu.setIcon("images/enabled.png");
            }
            PluginServices.getMainFrame().addMenu(menu, (ActionListener)this, PluginServices.getPluginServices((Object)this).getClassLoader());
        }
    }

    private void persistStatus(String toolbarName, boolean visible) {
        PluginServices ps = PluginServices.getPluginServices((Object)this);
        XMLEntity xml = ps.getPersistentXML();
        XMLEntity child = null;
        for (int i = xml.getChildrenCount() - 1; i >= 0; --i) {
            if (!xml.getChild(i).getName().equals("Toolbars")) continue;
            child = xml.getChild(i).getChild(0);
        }
        if (child == null) {
            XMLEntity toolbars = new XMLEntity();
            toolbars.setName("Toolbars");
            child = new XMLEntity();
            toolbars.addChild(child);
            xml.addChild(toolbars);
        }
        if (visible) {
            child.putProperty(toolbarName, "visible");
        } else {
            child.putProperty(toolbarName, "hidden");
        }
        ps.setPersistentXML(xml);
    }

    private void getPersistedStatus() {
        PluginServices ps = PluginServices.getPluginServices((Object)this);
        XMLEntity xml = ps.getPersistentXML();
        XMLEntity child = null;
        for (int i = xml.getChildrenCount() - 1; i >= 0; --i) {
            if (!xml.getChild(i).getName().equals("Toolbars")) continue;
            child = xml.getChild(i).getChild(0);
        }
        if (child != null) {
            SelectableToolBar[] toolBars = PluginServices.getMainFrame().getToolbars();
            for (int i = toolBars.length - 1; i >= 0; --i) {
                if (!child.contains(toolBars[i].getName())) continue;
                toolBars[i].setAndamiVisibility(child.getStringProperty(toolBars[i].getName()).equals("visible"));
            }
        }
    }
}

