/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin.preferences.general;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.coreplugin.preferences.general.GeneralPage;
import org.gvsig.gui.beans.swing.JButton;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.utils.XMLEntity;

public class FolderingPage
extends AbstractPreferencePage {
    private static Preferences prefs = Preferences.userRoot().node("gvsig.foldering");
    private JTextField txtProjectsFolder;
    private JTextField txtDataFolder;
    private JTextField txtTemplatesFolder;
    private JTextField txtSymbolLibraryFolder;
    private JButton btnSelectProjectsFolder;
    private JButton btnSelectDataFolder;
    private JButton btnSelectTemplatesFolder;
    private JButton btnSelectSymbolLibraryFolder;
    private ImageIcon icon;
    private ActionListener btnFileChooserAction;

    public FolderingPage() {
        this.setParentID(GeneralPage.id);
        this.icon = PluginServices.getIconTheme().get("edit-setup-foldering");
        this.btnFileChooserAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = e.getSource().equals(FolderingPage.this.btnSelectProjectsFolder) ? FolderingPage.this.txtProjectsFolder.getText() : (e.getSource().equals(FolderingPage.this.btnSelectDataFolder) ? FolderingPage.this.txtDataFolder.getText() : (e.getSource().equals(FolderingPage.this.btnSelectSymbolLibraryFolder) ? FolderingPage.this.txtSymbolLibraryFolder.getText() : FolderingPage.this.txtTemplatesFolder.getText()));
                FileFilter def = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return null;
                    }
                };
                File file = new File(path);
                JFileChooser fc = file.exists() ? new JFileChooser(file) : new JFileChooser();
                fc.setFileSelectionMode(1);
                fc.setMultiSelectionEnabled(false);
                fc.setAcceptAllFileFilterUsed(false);
                fc.addChoosableFileFilter(def);
                int result = fc.showOpenDialog((Component)((Object)FolderingPage.this));
                if (result == 0 && (file = fc.getSelectedFile()) != null) {
                    if (e.getSource().equals(FolderingPage.this.btnSelectProjectsFolder)) {
                        FolderingPage.this.txtProjectsFolder.setText(file.getAbsolutePath());
                    } else if (e.getSource().equals(FolderingPage.this.btnSelectDataFolder)) {
                        FolderingPage.this.txtDataFolder.setText(file.getAbsolutePath());
                    } else if (e.getSource().equals(FolderingPage.this.btnSelectSymbolLibraryFolder)) {
                        FolderingPage.this.txtSymbolLibraryFolder.setText(file.getAbsolutePath());
                    } else {
                        FolderingPage.this.txtTemplatesFolder.setText(file.getAbsolutePath());
                    }
                }
            }
        };
        this.btnSelectProjectsFolder = new JButton(PluginServices.getText((Object)((Object)this), (String)"browse"));
        this.btnSelectProjectsFolder.addActionListener(this.btnFileChooserAction);
        this.btnSelectDataFolder = new JButton(PluginServices.getText((Object)((Object)this), (String)"browse"));
        this.btnSelectDataFolder.addActionListener(this.btnFileChooserAction);
        this.btnSelectTemplatesFolder = new JButton(PluginServices.getText((Object)((Object)this), (String)"browse"));
        this.btnSelectTemplatesFolder.addActionListener(this.btnFileChooserAction);
        this.btnSelectSymbolLibraryFolder = new JButton(PluginServices.getText((Object)((Object)this), (String)"browse"));
        this.btnSelectSymbolLibraryFolder.addActionListener(this.btnFileChooserAction);
        JLabel lblProjectsFolder = new JLabel("<html><b>" + PluginServices.getText((Object)((Object)this), (String)"options.foldering.projects_folder") + "</b></html>");
        this.addComponent(lblProjectsFolder);
        this.txtProjectsFolder = new JTextField(30);
        this.addComponent(this.txtProjectsFolder, (Component)this.btnSelectProjectsFolder);
        this.addComponent(new JLabel(" "));
        JLabel lblDataFolder = new JLabel("<html><b>" + PluginServices.getText((Object)((Object)this), (String)"options.foldering.data_folder") + "</b></html>");
        this.addComponent(lblDataFolder);
        this.txtDataFolder = new JTextField(30);
        this.addComponent(this.txtDataFolder, (Component)this.btnSelectDataFolder);
        this.addComponent(new JLabel(" "));
        JLabel lblTemplatesFolder = new JLabel("<html><b>" + PluginServices.getText((Object)((Object)this), (String)"options.foldering.template_folder") + "</b></html>");
        this.addComponent(lblTemplatesFolder);
        this.txtTemplatesFolder = new JTextField(30);
        this.addComponent(this.txtTemplatesFolder, (Component)this.btnSelectTemplatesFolder);
        this.addComponent(new JLabel(" "));
        JLabel lblSymbolLibraryFolder = new JLabel("<html><b>" + PluginServices.getText((Object)((Object)this), (String)"options.foldering.symbol_library_folder") + "</b></html>");
        this.addComponent(lblSymbolLibraryFolder);
        this.txtSymbolLibraryFolder = new JTextField(30);
        this.addComponent(this.txtSymbolLibraryFolder, (Component)this.btnSelectSymbolLibraryFolder);
        this.addComponent(new JLabel(" "));
        PluginServices ps = PluginServices.getPluginServices((Object)((Object)this));
        XMLEntity xml = ps.getPersistentXML();
        if (xml.contains("ProjectsFolder")) {
            prefs.put("ProjectsFolder", xml.getStringProperty("ProjectsFolder"));
        }
        if (xml.contains("DataFolder")) {
            prefs.put("DataFolder", xml.getStringProperty("DataFolder"));
        }
        if (xml.contains("TemplatesFolder")) {
            prefs.put("TemplatesFolder", xml.getStringProperty("TemplatesFolder"));
        }
        if (xml.contains("SymbolLibraryFolder")) {
            prefs.put("SymbolLibraryFolder", xml.getStringProperty("SymbolLibraryFolder"));
        }
    }

    public void storeValues() throws StoreException {
        File f;
        PluginServices ps = PluginServices.getPluginServices((Object)((Object)this));
        XMLEntity xml = ps.getPersistentXML();
        FoldersManager foldersManager = ToolsLocator.getFoldersManager();
        String propertyName = "ProjectsFolder";
        String path = this.txtProjectsFolder.getText();
        if (path.equals("")) {
            if (xml.contains(propertyName)) {
                xml.remove(propertyName);
            }
            prefs.remove(propertyName);
        } else {
            f = new File(path);
            if (f.exists()) {
                if (xml.contains(propertyName)) {
                    xml.remove(propertyName);
                }
                xml.putProperty(propertyName, f.getAbsolutePath());
                prefs.put(propertyName, f.getAbsolutePath());
                foldersManager.set(propertyName, f);
            }
        }
        propertyName = "DataFolder";
        path = this.txtDataFolder.getText();
        if (path.equals("")) {
            if (xml.contains(propertyName)) {
                xml.remove(propertyName);
            }
            prefs.remove(propertyName);
        } else {
            f = new File(path);
            if (f.exists()) {
                if (xml.contains(propertyName)) {
                    xml.remove(propertyName);
                }
                xml.putProperty(propertyName, f.getAbsolutePath());
                prefs.put(propertyName, f.getAbsolutePath());
                foldersManager.set(propertyName, f);
            }
        }
        propertyName = "TemplatesFolder";
        path = this.txtTemplatesFolder.getText();
        if (path.equals("")) {
            if (xml.contains(propertyName)) {
                xml.remove(propertyName);
            }
            prefs.remove(propertyName);
        } else {
            f = new File(path);
            if (f.exists()) {
                if (xml.contains(propertyName)) {
                    xml.remove(propertyName);
                }
                xml.putProperty(propertyName, f.getAbsolutePath());
                prefs.put(propertyName, f.getAbsolutePath());
                foldersManager.set(propertyName, f);
            }
        }
        propertyName = "SymbolLibraryFolder";
        path = this.txtSymbolLibraryFolder.getText();
        if (path.equals("")) {
            if (xml.contains(propertyName)) {
                xml.remove(propertyName);
            }
            prefs.remove(propertyName);
        } else {
            f = new File(path);
            if (f.exists()) {
                if (xml.contains(propertyName)) {
                    xml.remove(propertyName);
                }
                xml.putProperty(propertyName, f.getAbsolutePath());
                prefs.put(propertyName, f.getAbsolutePath());
                foldersManager.set(propertyName, f);
            }
        }
    }

    public void setChangesApplied() {
        this.setChanged(false);
    }

    public String getID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getTitle() {
        return PluginServices.getText((Object)((Object)this), (String)"options.foldering.title");
    }

    public JPanel getPanel() {
        return this;
    }

    public void initializeValues() {
        PluginServices ps = PluginServices.getPluginServices((Object)((Object)this));
        XMLEntity xml = ps.getPersistentXML();
        if (xml.contains("ProjectsFolder")) {
            this.txtProjectsFolder.setText(xml.getStringProperty("ProjectsFolder"));
        }
        if (xml.contains("DataFolder")) {
            this.txtDataFolder.setText(xml.getStringProperty("DataFolder"));
        }
        if (xml.contains("TemplatesFolder")) {
            this.txtTemplatesFolder.setText(xml.getStringProperty("TemplatesFolder"));
        }
        if (xml.contains("SymbolLibraryFolder")) {
            this.txtSymbolLibraryFolder.setText(xml.getStringProperty("SymbolLibraryFolder"));
        }
    }

    public void initializeDefaults() {
        this.txtProjectsFolder.setText("");
        this.txtDataFolder.setText("");
        this.txtTemplatesFolder.setText("");
        this.txtSymbolLibraryFolder.setText("");
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isValueChanged() {
        return super.hasChanged();
    }
}

