/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin.preferences.general;

import java.awt.BorderLayout;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.coreplugin.preferences.general.GeneralPage;
import org.gvsig.coreplugin.preferences.general.IconThemePageLayout;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.documentfilters.DoubleDocumentFilter;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconThemePage
extends AbstractPreferencePage {
    private static final long serialVersionUID = 4369071892027860769L;
    private static final Logger logger = LoggerFactory.getLogger(IconThemePage.class);
    private final String id;
    private boolean changed = false;
    private IconThemePageLayout panel = null;
    private ImageIcon icon = null;

    public IconThemePage() {
        this.initialize();
        this.id = ((Object)((Object)this)).getClass().getName();
        this.setParentID(GeneralPage.class.getName());
    }

    public String getID() {
        return this.id;
    }

    public String getTitle() {
        return Messages.getText((String)"_Icon_theme");
    }

    public JPanel getPanel() {
        return this;
    }

    public void initializeValues() {
        IconThemeManager iconManager = ToolsSwingLocator.getIconThemeManager();
        Preferences prefs = Preferences.userRoot().node("gvsig.icontheme");
        String themeId = prefs.get("default-theme", null);
        try {
            double scaleFactor = prefs.getDouble("scaleFactor", 1.0);
        }
        catch (Throwable th) {
            double scaleFactor = 1.0;
        }
        ListElement.setSelected((JComboBox)this.panel.combo_selection, (Object)iconManager.get(themeId));
        DoubleDocumentFilter.install((JTextField)this.panel.txtScaleFactor);
    }

    public void storeValues() throws StoreException {
        Preferences prefs = Preferences.userRoot().node("gvsig.icontheme");
        IconTheme iconTheme = (IconTheme)ListElement.getSelected((JComboBox)this.panel.combo_selection);
        if (iconTheme != null && iconTheme != iconTheme.getDefault()) {
            prefs.put("default-theme", iconTheme.getID());
        }
        if (DoubleDocumentFilter.isValid((JTextField)this.panel.txtScaleFactor)) {
            double scaleFactor = DoubleDocumentFilter.getValue((JTextField)this.panel.txtScaleFactor);
            prefs.putDouble("scaleFactor", scaleFactor);
        }
    }

    public void initializeDefaults() {
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = IconThemeHelper.getImageIcon((String)"edit-setup-icontheme");
        }
        return this.icon;
    }

    public boolean isValueChanged() {
        if (this.panel.combo_selection.getSelectedIndex() >= 0) {
            return true;
        }
        if (DoubleDocumentFilter.isValid((JTextField)this.panel.txtScaleFactor)) {
            double scaleFactor = DoubleDocumentFilter.getValue((JTextField)this.panel.txtScaleFactor);
            Preferences prefs = Preferences.userRoot().node("gvsig.icontheme");
            try {
                if (scaleFactor != prefs.getDouble("scaleFactor", 1.0)) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.changed;
    }

    public void setChangesApplied() {
        this.changed = false;
    }

    private void initialize() {
        double scaleFactor;
        IconThemeManager iconManager = ToolsSwingLocator.getIconThemeManager();
        this.setLayout(new BorderLayout());
        this.panel = new IconThemePageLayout();
        DefaultComboBoxModel<ListElement> model = new DefaultComboBoxModel<ListElement>();
        for (int i = 0; i < iconManager.getCount(); ++i) {
            IconTheme iconTheme = iconManager.get(i);
            model.addElement(new ListElement(StringUtils.abbreviate((String)iconTheme.toString(), (int)60), (Object)iconTheme));
        }
        this.panel.combo_selection.setModel(model);
        Preferences prefs = Preferences.userRoot().node("gvsig.icontheme");
        try {
            scaleFactor = prefs.getDouble("scaleFactor", 1.0);
        }
        catch (Throwable th) {
            scaleFactor = 1.0;
        }
        this.panel.txtScaleFactor.setText(String.format("%f", scaleFactor));
        this.panel.label_title.setText(this.translate(this.panel.label_title.getText()));
        this.panel.label_selection.setText(this.translate(this.panel.label_selection.getText()));
        this.add(this.panel, "Center");
    }

    private String translate(String s) {
        return Messages.getText((String)s);
    }

    public boolean isResizeable() {
        return true;
    }
}

