/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin.preferences.network;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.coreplugin.preferences.network.NetworkPage;

public class FirewallPage
extends AbstractPreferencePage {
    private static Preferences prefs = Preferences.userRoot().node("gvsig.connection");
    private JCheckBox httpEnabled;
    private JTextField httpHost;
    private JTextField httpPort;
    private JTextField httpUser;
    private JPasswordField httpPass;
    private JTextField httpNonProxy;
    private JCheckBox socksEnabled;
    private JTextField socksHost;
    private JTextField socksPort;
    protected static String id = FirewallPage.class.getName();
    private ImageIcon icon = PluginServices.getIconTheme().get("edit-setup-firewall");

    public FirewallPage() {
        this.setParentID(NetworkPage.id);
        this.httpEnabled = new JCheckBox(PluginServices.getText((Object)((Object)this), (String)"options.firewall.http.enabled"));
        this.addComponent(this.httpEnabled);
        this.httpHost = new JTextField("", 15);
        this.addComponent(PluginServices.getText((Object)((Object)this), (String)"options.firewall.http.host") + ":", this.httpHost);
        this.httpPort = new JTextField("", 15);
        this.addComponent(PluginServices.getText((Object)((Object)this), (String)"options.firewall.http.port") + ":", this.httpPort);
        this.httpUser = new JTextField("", 15);
        this.addComponent(PluginServices.getText((Object)((Object)this), (String)"options.firewall.http.user") + ":", this.httpUser);
        this.httpPass = new JPasswordField("", 15);
        this.addComponent(PluginServices.getText((Object)((Object)this), (String)"options.firewall.http.password") + ":", this.httpPass);
        this.httpNonProxy = new JTextField("", 15);
        this.addComponent(PluginServices.getText((Object)((Object)this), (String)"options.firewall.http.nonProxy") + ":", this.httpNonProxy);
        this.socksEnabled = new JCheckBox(PluginServices.getText((Object)((Object)this), (String)"options.firewall.socks.enabled"));
        this.addComponent(this.socksEnabled);
        this.socksHost = new JTextField("", 15);
        this.addComponent(PluginServices.getText((Object)((Object)this), (String)"options.firewall.socks.host") + ":", this.socksHost);
        this.socksPort = new JTextField("", 15);
        this.addComponent(PluginServices.getText((Object)((Object)this), (String)"options.firewall.socks.port") + ":", this.socksPort);
    }

    public void initializeValues() {
        boolean enabled = prefs.getBoolean("firewall.http.enabled", false);
        this.httpEnabled.setSelected(enabled);
        this.httpHost.setEnabled(enabled);
        this.httpHost.setText(prefs.get("firewall.http.host", ""));
        this.httpPort.setEnabled(enabled);
        this.httpPort.setText(prefs.get("firewall.http.port", ""));
        this.httpUser.setEnabled(enabled);
        this.httpUser.setText(prefs.get("firewall.http.user", ""));
        this.httpPass.setEnabled(enabled);
        this.httpPass.setText(prefs.get("firewall.http.password", ""));
        this.httpNonProxy.setEnabled(enabled);
        this.httpNonProxy.setText(prefs.get("firewall.http.nonProxyHosts", ""));
        this.httpEnabled.addActionListener(new ActionHandler());
        enabled = prefs.getBoolean("firewall.socks.enabled", false);
        this.socksEnabled.setSelected(enabled);
        this.socksHost.setEnabled(enabled);
        this.socksHost.setText(prefs.get("firewall.socks.host", ""));
        this.socksPort.setEnabled(enabled);
        this.socksPort.setText(prefs.get("firewall.socks.port", ""));
        this.socksEnabled.addActionListener(new ActionHandler());
    }

    public String getID() {
        return id;
    }

    public String getTitle() {
        return PluginServices.getText((Object)((Object)this), (String)"pref.network.firewall");
    }

    public JPanel getPanel() {
        return this;
    }

    public void storeValues() throws StoreException {
        block11: {
            Properties systemSettings;
            block10: {
                systemSettings = System.getProperties();
                try {
                    URL httpURL = new URL(this.createURL(this.httpHost.getText(), this.httpPort.getText()));
                    prefs.putBoolean("firewall.http.enabled", this.httpEnabled.isSelected());
                    prefs.put("firewall.http.host", this.httpHost.getText());
                    prefs.put("firewall.http.port", this.httpPort.getText());
                    String proxyUser = this.httpUser.getText();
                    String proxyPassword = new String(this.httpPass.getPassword());
                    prefs.put("firewall.http.user", proxyUser);
                    prefs.put("firewall.http.password", proxyPassword);
                    prefs.put("firewall.http.nonProxyHosts", this.httpNonProxy.getText());
                    if (this.httpEnabled.isSelected()) {
                        systemSettings.put("http.proxySet", "true");
                        systemSettings.put("http.proxyHost", httpURL.getHost());
                        systemSettings.put("http.proxyPort", httpURL.getPort() + "");
                        systemSettings.put("http.proxyUserName", proxyUser);
                        systemSettings.put("http.proxyPassword", proxyPassword);
                    } else {
                        systemSettings.put("http.proxySet", "false");
                        systemSettings.remove("http.proxyHost");
                        systemSettings.remove("http.proxyPort");
                        systemSettings.remove("http.proxyUserName");
                        systemSettings.remove("http.proxyPassword");
                        prefs.remove("firewall.http.host");
                        prefs.remove("firewall.http.port");
                        prefs.remove("firewall.http.user");
                        prefs.remove("firewall.http.password");
                        prefs.remove("firewall.http.nonProxyHosts");
                    }
                    System.setProperties(systemSettings);
                    if (proxyUser != null) {
                        Authenticator.setDefault(new ProxyAuth(proxyUser, proxyPassword));
                    } else {
                        Authenticator.setDefault(new ProxyAuth("", ""));
                    }
                }
                catch (MalformedURLException e) {
                    if (!this.httpEnabled.isSelected()) break block10;
                    throw new StoreException(PluginServices.getText((Object)((Object)this), (String)"options.firewall.http.incorrect_host"), (Throwable)e);
                }
            }
            try {
                URL socksURL = new URL(this.createURL(this.socksHost.getText(), this.socksPort.getText()));
                prefs.putBoolean("firewall.socks.enabled", this.socksEnabled.isSelected());
                prefs.put("firewall.socks.host", this.socksHost.getText());
                prefs.put("firewall.socks.port", this.socksPort.getText());
                if (this.socksEnabled.isSelected()) {
                    systemSettings.put("socksProxyHost", socksURL.getHost());
                    systemSettings.put("socksProxyPort", socksURL.getPort() + "");
                } else {
                    systemSettings.remove("socksProxyHost");
                    systemSettings.remove("socksProxyPort");
                }
                System.setProperties(systemSettings);
            }
            catch (MalformedURLException e) {
                if (!this.socksEnabled.isSelected()) break block11;
                throw new StoreException(PluginServices.getText((Object)((Object)this), (String)"options.firewall.socks.incorrect_host"), (Throwable)e);
            }
        }
    }

    public void initializeDefaults() {
        this.httpEnabled.setSelected(false);
        this.httpHost.setText("");
        this.httpPort.setText("");
        this.httpUser.setText("");
        this.httpPass.setText("");
        this.httpNonProxy.setText("");
        this.socksEnabled.setSelected(false);
        this.socksHost.setText("");
        this.socksPort.setText("");
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isValueChanged() {
        return this.hasChanged();
    }

    public void setChangesApplied() {
        this.setChanged(false);
    }

    private String createURL(String host, String port) {
        StringBuffer strUrl = new StringBuffer();
        strUrl.append(host.toLowerCase().startsWith("http://") ? host.toLowerCase() : "http://" + host.toLowerCase());
        strUrl.append(!port.equals("") ? ":" + port : "");
        return strUrl.toString();
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            FirewallPage.this.httpHost.setEnabled(FirewallPage.this.httpEnabled.isSelected());
            FirewallPage.this.httpPort.setEnabled(FirewallPage.this.httpEnabled.isSelected());
            FirewallPage.this.httpUser.setEnabled(FirewallPage.this.httpEnabled.isSelected());
            FirewallPage.this.httpPass.setEnabled(FirewallPage.this.httpEnabled.isSelected());
            FirewallPage.this.httpNonProxy.setEnabled(FirewallPage.this.httpEnabled.isSelected());
            FirewallPage.this.socksHost.setEnabled(FirewallPage.this.socksEnabled.isSelected());
            FirewallPage.this.socksPort.setEnabled(FirewallPage.this.socksEnabled.isSelected());
        }
    }

    private static final class ProxyAuth
    extends Authenticator {
        private PasswordAuthentication auth;

        private ProxyAuth(String user, String pass) {
            this.auth = new PasswordAuthentication(user, pass.toCharArray());
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this.auth;
        }
    }
}

