/*
 * Decompiled with CFR 0.152.
 */
package com.k_int.codec.runtime;

import com.k_int.codec.runtime.AsnBitString;
import com.k_int.codec.runtime.AsnNull;
import com.k_int.codec.runtime.ChoiceType;
import com.k_int.codec.runtime.CodecStackInfo;
import com.k_int.codec.runtime.SerializationManager;
import com.k_int.codec.runtime.base_codec;
import com.k_int.util.LoggingFacade.LogContextFactory;
import com.k_int.util.LoggingFacade.LoggingContext;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.Stack;
import java.util.Vector;

public class BERInputStream
implements SerializationManager {
    Stack encoding_info = new Stack();
    public int tag_class = -1;
    public int tag_value = -1;
    public int next_tag_class = -1;
    public int next_tag_number = -1;
    public boolean next_is_constructed = false;
    public boolean next_is_indefinite = false;
    public int next_length = -1;
    public boolean is_constructed = false;
    BufferedInputStream in = null;
    private base_codec codec_hint = null;
    public String encoding = "US-ASCII";
    private static LoggingContext cat = LogContextFactory.getContext((String)"A2JRuntime");

    public BERInputStream(InputStream inputStream) {
        this.in = new BufferedInputStream(inputStream);
    }

    public BERInputStream(InputStream inputStream, String string) {
        this.in = new BufferedInputStream(inputStream);
        this.encoding = string;
    }

    public int getDirection() {
        return 1;
    }

    public int tag_codec(boolean bl) throws IOException {
        if (this.next_tag_class < 0) {
            if (this.encoding_info.size() > 0 && !this.moreData()) {
                this.tag_class = -1;
                return -1;
            }
            this.decodeNextTag();
        }
        if (this.next_tag_class == this.tag_class && this.next_tag_number == this.tag_value) {
            this.next_tag_class = -1;
            this.tag_class = -1;
            return this.next_length;
        }
        this.tag_class = -1;
        return -1;
    }

    private void decodeNextTag() throws IOException {
        byte by = (byte)this.read();
        by = (byte)(by & 0xFF);
        this.next_tag_class = by & 0xC0;
        this.next_is_constructed = (by & 0x20) != 0;
        this.next_tag_number = by & 0x1F;
        if (this.next_tag_number == 31) {
            this.next_tag_number = 0;
            do {
                by = (byte)this.read();
                this.next_tag_number <<= 7;
                this.next_tag_number |= by & 0x7F;
            } while ((by & 0x80) != 0);
        }
        this.next_length = this.decodeLengthOctets();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private int decodeLengthOctets() throws IOException {
        int n;
        block5: {
            int n2;
            int n3;
            block4: {
                n3 = this.read();
                if ((n3 & 0x80) == 0) {
                    n = n3;
                    this.next_is_indefinite = false;
                    return n;
                }
                if ((n3 & 0x7F) == 0) {
                    this.next_is_indefinite = true;
                    return 0;
                }
                this.next_is_indefinite = false;
                n3 = (byte)(n3 & 0x7F);
                n = 0;
                if (!true) break block4;
                n2 = n3;
                n3 = (byte)(n2 - 1);
                if (n2 <= 0) break block5;
            }
            do {
                n = n << 8 | (byte)this.read() & 0xFF;
                n2 = n3;
                n3 = (byte)(n2 - 1);
            } while (n2 > 0);
        }
        return n;
    }

    public byte[] octetstring_codec(Object object, boolean bl) throws IOException {
        byte[] byArray = null;
        if (this.next_length == 0 && this.next_is_constructed) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte by = (byte)this.read();
            byte by2 = (byte)this.read();
            while (by != 0 && by2 != 0) {
                byteArrayOutputStream.write(by);
                by = by2;
                by2 = (byte)this.read();
            }
            byArray = byteArrayOutputStream.toByteArray();
        } else {
            byte[] byArray2 = new byte[this.next_length];
            int n = this.next_length;
            int n2 = 0;
            while (n > 0) {
                int n3 = this.read(byArray2, n2, n);
                n -= n3;
                n2 += n3;
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public Boolean boolean_codec(Object object, boolean bl) throws IOException {
        Boolean bl2 = null;
        byte by = (byte)this.read();
        bl2 = by != 0 ? Boolean.TRUE : Boolean.FALSE;
        return bl2;
    }

    public BigInteger integer_codec(Object object, boolean bl) throws IOException {
        byte[] byArray = new byte[this.next_length];
        int n = this.next_length;
        int n2 = 0;
        while (n > 0) {
            int n3 = this.read(byArray, n2, n);
            n -= n3;
            n2 += n3;
        }
        return new BigInteger(byArray);
    }

    public int[] oid_codec(Object object, boolean bl) throws IOException {
        int[] nArray = new int[this.next_length + 1];
        byte[] byArray = new byte[this.next_length];
        int n = 2;
        int n2 = this.next_length;
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.read(byArray, n3, n2);
            n2 -= n4;
            n3 += n4;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte by = (byte)byteArrayInputStream.read();
        if (by >= 80) {
            nArray[0] = 2;
            nArray[1] = by - 80;
        } else if (by >= 40) {
            nArray[0] = 1;
            nArray[1] = by - 40;
        } else {
            nArray[0] = 0;
            nArray[1] = by;
        }
        while (byteArrayInputStream.available() > 0) {
            nArray[n++] = this.decodeBase128Int(byteArrayInputStream);
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public byte[] any_codec(Object object, boolean bl) throws IOException {
        byte[] byArray = null;
        if (this.next_length > 0 && this.next_is_constructed) {
            byArray = new byte[this.next_length];
            int n = this.next_length;
            int n2 = 0;
            while (n > 0) {
                int n3 = this.read(byArray, n2, n);
                n -= n3;
                n2 += n3;
            }
        } else if (this.next_length == 0) {
            StringWriter stringWriter = new StringWriter();
            byte by = (byte)this.read();
            byte by2 = (byte)this.read();
            while (by != 0 && by2 != 0) {
                stringWriter.write(by);
                by = by2;
                by2 = (byte)this.read();
            }
            byArray = stringWriter.toString().getBytes();
        } else {
            throw new IOException("Problem decoding any");
        }
        return byArray;
    }

    public AsnBitString bitstring_codec(Object object, boolean bl) throws IOException {
        AsnBitString asnBitString = (AsnBitString)object;
        int n = this.read();
        if (this.next_length > 0) {
            byte[] byArray = new byte[this.next_length - 1];
            byArray = new byte[this.next_length - 1];
            int n2 = this.next_length - 1;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = this.read(byArray, n3, n2);
                n2 -= n4;
                n3 += n4;
            }
            asnBitString = new AsnBitString(byArray, n);
        }
        return asnBitString;
    }

    public AsnNull null_codec(Object object, boolean bl) throws IOException {
        Object var3_3 = null;
        if (this.next_length != 0) {
            throw new IOException("Unexpected length encoding of null");
        }
        return new AsnNull();
    }

    public Object choice(Object object, Object[][] objectArray, String string) throws IOException {
        ChoiceType choiceType = (ChoiceType)object;
        Object object2 = null;
        int n = 0;
        while (n < objectArray.length && object2 == null) {
            Integer n2 = (Integer)objectArray[n][0];
            Integer n3 = (Integer)objectArray[n][1];
            Integer n4 = (Integer)objectArray[n][2];
            base_codec base_codec2 = (base_codec)objectArray[n][3];
            if (n2.equals(SerializationManager.TAGMODE_NONE)) {
                object2 = base_codec2.serialize(this, object2, true, (String)objectArray[n][4]);
            } else if (n2.equals(SerializationManager.IMPLICIT)) {
                object2 = this.implicit_tag(base_codec2, object2, n3, n4, true, (String)objectArray[n][4]);
            } else if (this.constructedBegin(n3, n4)) {
                object2 = base_codec2.serialize(this, object2, false, (String)objectArray[n][4]);
                this.constructedEnd();
            }
            if (object2 != null) {
                choiceType.o = object2;
                choiceType.which = n;
            }
            ++n;
        }
        if (object2 == null) {
            choiceType = null;
        }
        return choiceType;
    }

    public boolean sequenceBegin() throws IOException {
        if (this.tag_class < 0) {
            this.tag_class = 0;
            this.tag_value = 16;
        }
        return this.constructedBegin(this.tag_class, this.tag_value);
    }

    public boolean sequenceEnd() throws IOException {
        return this.constructedEnd();
    }

    public boolean constructedBegin(int n, int n2) throws IOException {
        if (this.tag_class < 0) {
            this.tag_class = n;
            this.tag_value = n2;
        }
        if (this.tag_codec(true) >= 0) {
            CodecStackInfo codecStackInfo = new CodecStackInfo();
            codecStackInfo.content_length = this.next_length;
            codecStackInfo.bytes_processed = 0;
            codecStackInfo.is_constructed = this.next_is_constructed;
            codecStackInfo.is_indefinite_length = this.next_is_indefinite;
            this.encoding_info.push(codecStackInfo);
            return true;
        }
        return false;
    }

    public boolean constructedEnd() throws IOException {
        CodecStackInfo codecStackInfo = (CodecStackInfo)this.encoding_info.pop();
        if (codecStackInfo.is_indefinite_length) {
            byte by = (byte)this.read();
            byte by2 = (byte)this.read();
            if (by == 0 && by2 == 0) {
                this.next_tag_class = -1;
                this.tag_class = -1;
            } else {
                throw new IOException("Expected indefinite length terminating octets for constructed type, found other values");
            }
        }
        if (this.encoding_info.size() > 0) {
            CodecStackInfo codecStackInfo2 = (CodecStackInfo)this.encoding_info.peek();
            codecStackInfo2.bytes_processed += codecStackInfo.bytes_processed;
        }
        return true;
    }

    public Object implicit_tag(base_codec base_codec2, Object object, int n, int n2, boolean bl, String string) throws IOException {
        Object object2 = null;
        this.implicit_settag(n, n2);
        object2 = base_codec2.serialize(this, object, bl, string);
        return object2;
    }

    public Object explicit_tag(base_codec base_codec2, Object object, int n, int n2, boolean bl, String string) throws IOException {
        Object object2 = object;
        if (this.constructedBegin(n, n2)) {
            object2 = base_codec2.serialize(this, object2, bl, string);
            this.constructedEnd();
        }
        return object2;
    }

    public Vector sequenceOf(Vector vector, base_codec base_codec2) throws IOException {
        if (vector != null) {
            while (this.moreData()) {
                Object object = base_codec2.serialize(this, null, true, "SequenceOf item");
                if (object == null) {
                    throw new IOException("Error expecting member of sequenceOf");
                }
                vector.add(object);
            }
        }
        return vector;
    }

    public void implicit_settag(int n, int n2) {
        if (this.tag_class < 0) {
            this.tag_class = n;
            this.tag_value = n2;
        }
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new IOException("Connection Closed");
        }
        if (this.encoding_info.size() > 0) {
            CodecStackInfo codecStackInfo = (CodecStackInfo)this.encoding_info.peek();
            ++codecStackInfo.bytes_processed;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 == -1) {
            throw new IOException("Connection Closed");
        }
        if (this.encoding_info.size() > 0) {
            CodecStackInfo codecStackInfo = (CodecStackInfo)this.encoding_info.peek();
            codecStackInfo.bytes_processed += n3;
        }
        return n3;
    }

    public boolean moreData() throws IOException {
        if (this.encoding_info.size() > 0) {
            CodecStackInfo codecStackInfo = (CodecStackInfo)this.encoding_info.peek();
            if (codecStackInfo.content_length > 0) {
                return codecStackInfo.bytes_processed < codecStackInfo.content_length;
            }
            if (codecStackInfo.is_indefinite_length) {
                this.in.mark(5);
                int n = this.in.read();
                int n2 = this.in.read();
                this.in.reset();
                return n != 0 || n2 != 0;
            }
        }
        return false;
    }

    private int decodeBase128Int(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = -128;
        while ((n2 & 0x80) == 128) {
            n2 = (byte)inputStream.read();
            n = n << 7 | n2 & 0x7F;
        }
        return n;
    }

    public base_codec getHintCodec() {
        return this.codec_hint;
    }

    public void setHintCodec(base_codec base_codec2) {
        this.codec_hint = base_codec2;
    }

    public String getCharsetEncoding() {
        return this.encoding;
    }
}

