/*
 * Decompiled with CFR 0.152.
 */
package org.medfoster.sqljep.function;

import java.math.BigDecimal;
import org.medfoster.sqljep.ASTFunNode;
import org.medfoster.sqljep.JepRuntime;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.function.PostfixCommand;

public final class ComparativeEQ
extends PostfixCommand {
    public final int getNumberOfParameters() {
        return 2;
    }

    public void evaluate(ASTFunNode aSTFunNode, JepRuntime jepRuntime) throws ParseException {
        aSTFunNode.childrenAccept(jepRuntime.ev, null);
        Comparable comparable = jepRuntime.stack.pop();
        Comparable comparable2 = jepRuntime.stack.pop();
        if (comparable2 == null || comparable == null) {
            jepRuntime.stack.push(Boolean.FALSE);
        } else {
            jepRuntime.stack.push(Boolean.valueOf(ComparativeEQ.compareTo(comparable2, comparable) == 0));
        }
    }

    public static int compareTo(Comparable comparable, Comparable comparable2) throws ParseException {
        if (comparable.getClass() == comparable2.getClass()) {
            return comparable.compareTo(comparable2);
        }
        if (comparable2 instanceof Number && comparable instanceof String) {
            comparable = ComparativeEQ.parse((String)((Object)comparable));
        } else if (comparable instanceof Number && comparable2 instanceof String) {
            comparable2 = ComparativeEQ.parse((String)((Object)comparable2));
        }
        if (comparable instanceof Number && comparable2 instanceof Number) {
            long l;
            Number number = (Number)((Object)comparable);
            Number number2 = (Number)((Object)comparable2);
            if (number instanceof BigDecimal || number2 instanceof BigDecimal) {
                BigDecimal bigDecimal = ComparativeEQ.getBigDecimal(number);
                BigDecimal bigDecimal2 = ComparativeEQ.getBigDecimal(number2);
                return bigDecimal.compareTo(bigDecimal2);
            }
            if (number instanceof Double || number2 instanceof Double || number instanceof Float || number2 instanceof Float) {
                return Double.compare(number.doubleValue(), number2.doubleValue());
            }
            long l2 = number.longValue();
            return l2 < (l = number2.longValue()) ? -1 : (l2 == l ? 0 : 1);
        }
        throw new ParseException("Not comparable");
    }
}

