/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.canvas.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.gvsig.raster.swing.gcanvas.InfoLayer;
import org.gvsig.raster.swing.impl.canvas.layer.DefaultGraphicHistogram;
import org.gvsig.raster.swing.impl.canvas.layer.DefaultMinMaxLines;

public class DefaultInfoLayer
extends InfoLayer {
    private Color color = null;
    private double min = 0.0;
    private double max = 1.0;
    private String statusRight = null;
    private String statusLeft = null;

    public DefaultInfoLayer(Color c) {
        this.color = c;
    }

    public void firstActions() {
        this.canvas.addBorder(0, 15, 0, 15);
    }

    public void setLimits(double min, double max) {
        this.min = min;
        this.max = max;
    }

    protected void paint(Graphics g) {
        List list;
        Graphics2D graphics2 = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        graphics2.setRenderingHints(hints);
        graphics2.setColor(this.color);
        graphics2.setFont(new Font("Times", 1, 12));
        String min2 = this.clipDecimals(this.min, 1) + "";
        String max2 = this.clipDecimals(this.max, 1) + "";
        Rectangle2D rectangle2D = graphics2.getFontMetrics().getStringBounds(max2, g);
        graphics2.drawString(min2, this.canvas.getCanvasMinX(), this.canvas.getCanvasMinX() + 12);
        graphics2.drawString(max2, (int)((double)((Component)this.canvas).getWidth() - rectangle2D.getWidth() - (double)this.canvas.getCanvasMinX()), this.canvas.getCanvasMinX() + 12);
        if (this.statusRight != null) {
            rectangle2D = graphics2.getFontMetrics().getStringBounds(this.statusRight, g);
            graphics2.drawString(this.statusRight, (int)((double)((Component)this.canvas).getWidth() - rectangle2D.getWidth() - (double)this.canvas.getCanvasMinX()), ((Component)this.canvas).getHeight() - this.canvas.getCanvasMinX());
        }
        if (this.statusLeft != null) {
            graphics2.drawString(this.statusLeft, this.canvas.getCanvasMinX(), ((Component)this.canvas).getHeight() - this.canvas.getCanvasMinX());
        }
        if ((list = this.canvas.getDrawableElements(DefaultMinMaxLines.class)).size() > 0) {
            DefaultMinMaxLines minMaxLines = (DefaultMinMaxLines)((Object)list.get(0));
            double minP = this.min + minMaxLines.getMinDistance() * (this.max - this.min);
            double maxP = this.min + minMaxLines.getMaxDistance() * (this.max - this.min);
            min2 = this.clipDecimals(minP, 1) + "";
            max2 = this.clipDecimals(maxP, 1) + "";
            list = this.canvas.getDrawableElements(DefaultGraphicHistogram.class);
            if (list.size() > 0) {
                DefaultGraphicHistogram histogram = (DefaultGraphicHistogram)((Object)list.get(0));
                double[] ds = histogram.getHistogramValues();
                double total = 0.0;
                double totalmin = 0.0;
                double totalmax = 0.0;
                for (int i = 0; i < ds.length; ++i) {
                    double value = this.min + (double)i * (this.max - this.min) / ((double)ds.length - 1.0);
                    total += ds[i];
                    if (minP > value) {
                        totalmin += ds[i];
                    }
                    if (!(maxP < value)) continue;
                    totalmax += ds[i];
                }
                totalmin = 100.0 * totalmin / total;
                totalmax = 100.0 * totalmax / total;
                min2 = min2 + " (" + this.clipDecimals(totalmin, 2) + "%)";
                max2 = max2 + " (" + this.clipDecimals(totalmax, 2) + "%)";
            }
            rectangle2D = graphics2.getFontMetrics().getStringBounds(max2, g);
            if (this.statusLeft == null) {
                graphics2.drawString(min2, this.canvas.getCanvasMinX(), ((Component)this.canvas).getHeight() - this.canvas.getCanvasMinX());
            }
            if (this.statusRight == null) {
                graphics2.drawString(max2, (int)((double)((Component)this.canvas).getWidth() - rectangle2D.getWidth() - (double)this.canvas.getCanvasMinX()), ((Component)this.canvas).getHeight() - this.canvas.getCanvasMinX());
            }
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setStatusRight(String statusRight) {
        this.statusRight = statusRight;
    }

    public void setStatusLeft(String statusLeft) {
        this.statusLeft = statusLeft;
    }

    public void firstDrawActions() {
    }

    public double clipDecimals(double num, int n) {
        long m = (long)Math.pow(10.0, n);
        long aux = Math.round(num * (double)m);
        return (double)aux / (double)m;
    }
}

