/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.pagedtable;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.pagedtable.PagedTable;
import org.gvsig.raster.swing.pagedtable.PagedTableEvent;
import org.gvsig.raster.swing.pagedtable.PagedTableListener;

public class Pager
extends Observable {
    private List<Object> entries = null;
    private int entriesPerPage = 0;
    private int selectedPage = 0;
    private int[] selectedRows = null;
    private List<PagedTableListener> listeners = null;
    private PagedTable table = null;
    private String deleteOneEntryMessage = null;
    private String deleteAllEntriesMessage = null;

    public Pager(int entriesPerPage, PagedTable table) {
        this.entriesPerPage = entriesPerPage;
        this.entries = new ArrayList<Object>();
        this.listeners = new ArrayList<PagedTableListener>();
        this.table = table;
    }

    public void throwEvent(int event, int[] rows) {
        this.setChanged();
        this.notifyObservers(event);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).tableChanged(new PagedTableEvent((Object)this.table, event, rows));
        }
    }

    public void setConfirmationMessageDeleteAllEntries(String message) {
        this.deleteAllEntriesMessage = message;
    }

    public void setConfirmationMessageDeleteOneEntry(String message) {
        this.deleteOneEntryMessage = message;
    }

    public void setSelectedRows(int[] rows) {
        this.selectedRows = rows;
        this.throwEvent(PagedTableEvent.EVENT_SELECTED_ROWS, rows);
    }

    public void increaseSelectedRows() {
        boolean change = false;
        for (int i = 0; i < this.selectedRows.length; ++i) {
            if (this.selectedRows[i] >= this.getEntriesCount()) continue;
            int n = i;
            this.selectedRows[n] = this.selectedRows[n] + 1;
            change = true;
        }
        if (change) {
            this.throwEvent(PagedTableEvent.EVENT_SELECTED_ROWS, this.selectedRows);
        }
    }

    public void decreaseSelectedRows() {
        boolean change = false;
        for (int i = 0; i < this.selectedRows.length; ++i) {
            if (this.selectedRows[i] <= 0) continue;
            int n = i;
            this.selectedRows[n] = this.selectedRows[n] - 1;
            change = true;
        }
        if (change) {
            this.throwEvent(PagedTableEvent.EVENT_SELECTED_ROWS, this.selectedRows);
        }
    }

    public void addSelectedRow(int row) {
        int[] newSelected = new int[this.selectedRows.length + 1];
        for (int i = 0; i < this.selectedRows.length; ++i) {
            newSelected[i] = this.selectedRows[i];
        }
        newSelected[newSelected.length - 1] = row;
        this.selectedRows = newSelected;
        this.throwEvent(PagedTableEvent.EVENT_SELECTED_ROWS, this.selectedRows);
    }

    public int[] getSelectedRows() {
        return this.selectedRows;
    }

    public void addEntry(Object entry) {
        int newSelectedRow = this.entries.size();
        if (!this.isInCurrentPage(newSelectedRow)) {
            this.setSelectedPage(this.getPageFromRow(newSelectedRow));
            this.throwEvent(PagedTableEvent.EVENT_SELECTED_PAGE, new int[]{newSelectedRow});
        }
        this.entries.add(entry);
        this.throwEvent(PagedTableEvent.EVENT_ADD_ENTRY, new int[]{newSelectedRow});
        this.setSelectedRows(new int[]{newSelectedRow});
    }

    public Object[] getEntry(int row) {
        if (row >= 0 && row < this.entries.size()) {
            return (Object[])this.entries.get(row);
        }
        return null;
    }

    public void removeEntry(int pos) {
        if (this.deleteOneEntryMessage != null && !this.messageBoxYesOrNot(this.deleteOneEntryMessage, null)) {
            return;
        }
        if (pos >= 0 && pos < this.entries.size()) {
            int newRowSelected;
            int newPageSelected;
            int oldSelectedPageInRow = this.getPageFromRow(pos);
            int oldSelectedPage = this.getSelectedPageNumber();
            Object removedEntry = this.entries.get(pos);
            this.entries.remove(pos);
            if (this.isSelectedRow(pos) && oldSelectedPageInRow == oldSelectedPage && (newPageSelected = this.getPageFromRow(newRowSelected = this.selectAlternativeRow(pos))) != oldSelectedPage) {
                this.setSelectedPage(newPageSelected);
                this.throwEvent(PagedTableEvent.EVENT_SELECTED_PAGE, new int[]{pos});
                return;
            }
            this.setChanged();
            this.notifyObservers(PagedTableEvent.EVENT_REMOVE_ENTRY);
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).tableChanged(new PagedTableEvent((Object)this.table, PagedTableEvent.EVENT_REMOVE_ENTRY, removedEntry));
            }
        }
    }

    private int selectAlternativeRow(int row) {
        for (int i = 0; i < this.selectedRows.length; ++i) {
            if (this.selectedRows[i] != row || this.selectedRows[i] == 0) continue;
            int n = i;
            this.selectedRows[n] = this.selectedRows[n] - 1;
            return this.selectedRows[i];
        }
        return row;
    }

    public void swapRow(int i, int j) {
        if (i == j) {
            return;
        }
        if (j < i) {
            int aux = i;
            i = j;
            j = aux;
        }
        Object a = this.entries.get(i);
        Object b = this.entries.get(j);
        this.entries.add(i, b);
        this.entries.remove(i + 1);
        this.entries.add(j, a);
        this.entries.remove(j + 1);
        if (!this.isSelectedRow(j) || !this.isSelectedRow(i)) {
            for (int k = 0; k < this.selectedRows.length; ++k) {
                if (this.selectedRows[k] == j) {
                    this.selectedRows[k] = i;
                    this.throwEvent(PagedTableEvent.EVENT_SELECTED_ROWS, new int[]{i, j});
                    break;
                }
                if (this.selectedRows[k] != i) continue;
                this.selectedRows[k] = j;
                this.throwEvent(PagedTableEvent.EVENT_SELECTED_ROWS, new int[]{i, j});
                break;
            }
        }
        this.throwEvent(PagedTableEvent.EVENT_SWAP_ENTRIES, new int[]{i, j});
    }

    public boolean isSelectedRow(int row) {
        if (this.selectedRows == null) {
            return false;
        }
        for (int i = 0; i < this.selectedRows.length; ++i) {
            if (this.selectedRows[i] != row) continue;
            return true;
        }
        return false;
    }

    public int getEntriesCount() {
        return this.entries.size();
    }

    public int getRowFromPageRow(int pageRow) {
        return this.getSelectedPageNumber() * this.getEntriesPerPage() + pageRow;
    }

    public Object[] getLastEntry() {
        return (Object[])this.entries.get(this.entries.size() - 1);
    }

    public void removeAllEntries() {
        if (this.deleteAllEntriesMessage != null && !this.messageBoxYesOrNot(this.deleteAllEntriesMessage, null)) {
            return;
        }
        this.entries.clear();
        this.throwEvent(PagedTableEvent.EVENT_REMOVE_ALL, null);
    }

    public void removeAllEntriesWithoutAsk() {
        this.entries.clear();
        this.throwEvent(PagedTableEvent.EVENT_REMOVE_ALL, null);
    }

    public void setEntriesPerPage(int n) {
        this.entriesPerPage = n;
        this.setChanged();
        this.notifyObservers(PagedTableEvent.EVENT_SELECTED_PAGE);
    }

    public void increaseSelectedPage() {
        if (this.selectedPage < this.getPageCount() - 1) {
            ++this.selectedPage;
            this.throwEvent(PagedTableEvent.EVENT_SELECTED_PAGE, null);
        }
    }

    public void decreaseSelectedPage() {
        if (this.selectedPage > 0) {
            --this.selectedPage;
            this.throwEvent(PagedTableEvent.EVENT_SELECTED_PAGE, null);
        }
    }

    public void setSelectedPage(int page) {
        if (page >= 0 && page < this.getPageCount()) {
            this.selectedPage = page;
            this.throwEvent(PagedTableEvent.EVENT_SELECTED_PAGE, null);
        }
    }

    public int getPageFromRow(int row) {
        if (this.getEntriesPerPage() > 0) {
            return row / this.getEntriesPerPage();
        }
        return 0;
    }

    public List<Object> getSelectedPage() {
        return this.getPage(this.getSelectedPageNumber());
    }

    public void removePage(int page) {
        if (page >= 0 && page < this.getPageCount()) {
            int init = this.entriesPerPage * page;
            int end = init + this.entriesPerPage;
            for (int i = end - 1; i >= init; --i) {
                this.entries.remove(i);
            }
        }
    }

    public int getPageCount() {
        return (int)Math.ceil((double)this.entries.size() / (double)this.entriesPerPage);
    }

    public boolean isInCurrentPage(int row) {
        int init = this.selectedPage * this.getEntriesPerPage();
        int end = init + this.getEntriesPerPage() - 1;
        return row >= init && row <= end;
    }

    public List<Object> getPage(int page) {
        if (page >= 0 && page < this.getPageCount()) {
            int init = this.entriesPerPage * page;
            int end = init + this.entriesPerPage;
            end = end >= this.entries.size() ? this.entries.size() : end;
            return this.entries.subList(init, end);
        }
        return null;
    }

    public int getEntriesPerPage() {
        return this.entriesPerPage;
    }

    public int getSelectedPageNumber() {
        if (this.selectedPage >= this.getPageCount()) {
            this.selectedPage = this.getPageCount() - 1;
            if (this.selectedPage < 0) {
                this.selectedPage = 0;
            }
        }
        return this.selectedPage;
    }

    public void addListener(PagedTableListener listener) {
        this.listeners.add(listener);
    }

    public boolean messageBoxYesOrNot(String msg, Object parentWindow) {
        String string1 = Messages.getText((String)"yes");
        String string2 = Messages.getText((String)"no");
        Object[] options = new Object[]{string1, string2};
        int n = JOptionPane.showOptionDialog(this.table.getJTable(), "<html>" + msg.replaceAll("\n", "<br>") + "</html>", PluginServices.getText((Object)parentWindow, (String)"confirmacion"), 0, 3, null, options, string1);
        return n == 0;
    }
}

