/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.pagedtable;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.raster.swing.impl.pagedtable.MoveRowsPanel;
import org.gvsig.raster.swing.impl.pagedtable.PaginationBarPanel;
import org.gvsig.raster.swing.impl.pagedtable.TableEntryControllerPanel;
import org.gvsig.raster.swing.pagedtable.PagedTable;
import org.gvsig.raster.swing.pagedtable.TableModel;

public class TableControllerListener
implements ActionListener,
ListSelectionListener {
    public static boolean comboEventEnable = true;
    private PagedTable pagedTable = null;
    private TableEntryControllerPanel controlPanel = null;
    private MoveRowsPanel moveRowsPanel = null;
    private PaginationBarPanel paginationBarPanel = null;
    public boolean enableNewLineListener = true;

    public TableControllerListener(PagedTable tableContainer) {
        this.pagedTable = tableContainer;
    }

    public void setControlPanel(TableEntryControllerPanel control) {
        this.controlPanel = control;
    }

    public void setMoveRowsPanel(MoveRowsPanel moveRowsPanel) {
        this.moveRowsPanel = moveRowsPanel;
    }

    public void setPaginationBarPanel(PaginationBarPanel paginationBarPanel) {
        this.paginationBarPanel = paginationBarPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row;
        if (!comboEventEnable) {
            return;
        }
        comboEventEnable = false;
        if (this.enableNewLineListener && e.getSource() == this.controlPanel.getBNew() && this.pagedTable.getTableModel() instanceof TableModel) {
            this.pagedTable.addRow(this.pagedTable.getTableModel().getNewLine());
        }
        if (this.enableNewLineListener && e.getSource() == this.controlPanel.getBClear()) {
            this.pagedTable.removeAllRows();
        }
        if (this.enableNewLineListener && e.getSource() == this.controlPanel.getBDelPoint()) {
            int[] listSelection = this.pagedTable.getSelectedRows();
            for (int i = listSelection.length - 1; i >= 0; --i) {
                this.pagedTable.delRow(listSelection[i]);
            }
        }
        if (e.getSource() == this.controlPanel.getBFirst()) {
            this.pagedTable.setSelectedRow(0);
        }
        if (e.getSource() == this.controlPanel.getBLast()) {
            this.pagedTable.setSelectedRow(-1);
        }
        if (e.getSource() == this.controlPanel.getBNext()) {
            this.pagedTable.increaseSelectedRows();
        }
        if (e.getSource() == this.controlPanel.getBPrev()) {
            this.pagedTable.decreaseSelectedRows();
        }
        if (e.getSource() == this.controlPanel.getCPoint()) {
            this.pagedTable.setSelectedRow(this.controlPanel.getCPoint().getSelectedIndex());
        }
        if (e.getSource() == this.paginationBarPanel.getButtonUp()) {
            this.pagedTable.prevPage();
        }
        if (e.getSource() == this.paginationBarPanel.getButtonDown()) {
            this.pagedTable.nextPage();
        }
        if (e.getSource() == this.moveRowsPanel.getBUp() && this.pagedTable.getSelectedRows() != null) {
            for (int i = 0; i < this.pagedTable.getSelectedRows().length; ++i) {
                row = this.pagedTable.getSelectedRows()[i];
                this.pagedTable.swapRow(row, row - 1);
            }
        }
        if (e.getSource() == this.moveRowsPanel.getBDown() && this.pagedTable.getSelectedRows() != null) {
            for (int i = 0; i < this.pagedTable.getSelectedRows().length; ++i) {
                row = this.pagedTable.getSelectedRows()[i];
                this.pagedTable.swapRow(row, row + 1);
            }
        }
        comboEventEnable = true;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }
}

