/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.roimask.lib.impl.regionalpha;

import org.gvsig.raster.roimask.lib.impl.regionalpha.RegionAlphaFilter;

public class RegionAlphaByteFilter
extends RegionAlphaFilter {
    @Override
    public void process(int x, int y) {
        if (this.bufferExtent == null) {
            for (int j = 0; j < this.raster.getBandCount(); ++j) {
                this.rasterResult.setElem(y, x, j, this.raster.getElemByte(y, x, j));
            }
            return;
        }
        double wcX = this.bufferExtent.minX() + (double)x * this.bufferExtent.width() / (double)this.raster.getWidth();
        double wcY = this.bufferExtent.minY() + (double)(this.raster.getHeight() - y) * this.bufferExtent.height() / (double)this.raster.getHeight();
        for (int iBand = 0; iBand < this.numberOfBandsToProcess(); ++iBand) {
            this.rasterResult.setElem(y, x, iBand, this.raster.getElemByte(y, x, iBand));
        }
        for (int i = 0; i < this.getROIList().size(); ++i) {
            if (!this.selectedROI[i] || !this.getROIList().get(i).isInside(wcX, wcY, this.cellsize, this.cellsize)) continue;
            if (this.inverse) {
                if (this.hasInputTransparency()) {
                    this.rasterResult.setElem(y, x, this.rasterResult.getBandCount() - 1, this.raster.getElemByte(y, x, this.transparency.getAlphaBandNumber()));
                } else {
                    this.rasterResult.setElem(y, x, this.rasterResult.getBandCount() - 1, (byte)-1);
                }
            } else {
                this.rasterResult.setElem(y, x, this.rasterResult.getBandCount() - 1, (byte)(255 - this.alpha));
            }
            return;
        }
        if (this.inverse) {
            this.rasterResult.setElem(y, x, this.rasterResult.getBandCount() - 1, (byte)(255 - this.alpha));
        } else if (this.hasInputTransparency()) {
            this.rasterResult.setElem(y, x, this.rasterResult.getBandCount() - 1, this.raster.getElemByte(y, x, this.transparency.getAlphaBandNumber()));
        } else {
            this.rasterResult.setElem(y, x, this.rasterResult.getBandCount() - 1, (byte)-1);
        }
    }
}

