/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.roimask.lib.impl.regionalpha;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.grid.FilterUIListener;
import org.gvsig.fmap.dal.coverage.grid.RegistrableFilterListener;
import org.gvsig.gui.beans.table.TableContainer;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.roi.ROI;

public class RegionAlphaUI
extends JPanel
implements RegistrableFilterListener,
TableModelListener,
ChangeListener {
    private static final long serialVersionUID = 4525736825113598035L;
    private TableContainer tableContainer = null;
    private JLabel warning = null;
    private JCheckBox negative = null;
    private boolean lastInv = false;
    protected Params loadedParams = null;
    private ArrayList<FilterUIListener> actionCommandListeners = new ArrayList();

    public RegionAlphaUI() {
        this.init(null);
    }

    public void init(Object obj) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTableContainer(), "Center");
        this.add((Component)this.getWarning(), "North");
        this.add((Component)this.getInverse(), "South");
    }

    private TableContainer getTableContainer() {
        if (this.tableContainer == null) {
            String[] columnNames = new String[]{" ", "Nombre", ""};
            int[] columnWidths = new int[]{22, 334, 0};
            this.tableContainer = new TableContainer(columnNames, columnWidths);
            this.tableContainer.setPreferredSize(new Dimension(0, 130));
            this.tableContainer.setModel("CheckBoxModel");
            this.tableContainer.initialize();
            this.tableContainer.setControlVisible(false);
            this.tableContainer.setMoveRowsButtonsVisible(false);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(0).setMinWidth(22);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(0).setMaxWidth(22);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(2).setMinWidth(0);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(2).setMaxWidth(0);
            this.tableContainer.getModel().addTableModelListener(this);
        }
        return this.tableContainer;
    }

    private JCheckBox getInverse() {
        if (this.negative == null) {
            this.negative = new JCheckBox();
            this.negative.setText(Messages.getText((String)"inversa"));
            this.negative.addChangeListener(this);
        }
        return this.negative;
    }

    public JLabel getWarning() {
        if (this.warning == null) {
            this.warning = new JLabel(Messages.getText((String)"rois_needed"));
            this.warning.setVisible(false);
        }
        return this.warning;
    }

    public void setROIList(List<ROI> roiList) {
        if (roiList == null || roiList.size() == 0) {
            this.getWarning().setVisible(true);
        }
        if (roiList != null) {
            for (int i = 0; i < roiList.size(); ++i) {
                ROI roi = roiList.get(i);
                Object[] row = new Object[]{"", "", ""};
                boolean active = false;
                if (roiList != null) {
                    for (int r = 0; r < roiList.size(); ++r) {
                        if (roiList.get(r) != roi) continue;
                        active = true;
                        break;
                    }
                }
                row[0] = new Boolean(active);
                row[1] = roi.getName();
                row[2] = new Integer(i);
                try {
                    this.getTableContainer().addRow(row);
                    continue;
                }
                catch (NotInitializeException notInitializeException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean[] getPositionSelectedROIs() {
        boolean[] selectedROIs = new boolean[this.tableContainer.getModel().getRowCount()];
        for (int i = 0; i < this.tableContainer.getModel().getRowCount(); ++i) {
            try {
                selectedROIs[i] = (Boolean)this.tableContainer.getModel().getValueAt(i, 0);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return selectedROIs;
    }

    public Params getParams() {
        Params params = null;
        if (this.loadedParams != null) {
            params = this.loadedParams;
            this.loadedParams = null;
            return params;
        }
        params = RasterLocator.getManager().createParams("selected_roi", (Object)this.getPositionSelectedROIs(), -1, null);
        params.setParam("inverse", (Object)new Boolean(this.getInverse().isSelected()), -1, null);
        return params;
    }

    public void setParams(Params params) {
        this.loadedParams = params;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.callStateChanged();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.getInverse()) && ((JCheckBox)e.getSource()).isSelected() != this.lastInv) {
            this.callStateChanged();
            this.lastInv = ((JCheckBox)e.getSource()).isSelected();
        }
    }

    public void addFilterUIListener(FilterUIListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void callStateChanged() {
        for (FilterUIListener listener : this.actionCommandListeners) {
            listener.actionValuesCompleted(new EventObject(this));
        }
    }

    public void removeStateChangedListener(FilterUIListener listener) {
        this.actionCommandListeners.remove(listener);
    }
}

