/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynform;

import com.jeta.forms.components.panel.FormPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynform.AbstractJDynForm;
import org.gvsig.tools.dynform.spi.dynform.JDynFormFactory;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.script.Script;

public class AbeilleJDynForm
extends AbstractJDynForm
implements JDynFormField.JDynFormFieldListener {
    private Map<String, JDynFormField> components;
    private String resourceName;
    private AbeilleComponentsFactory componentsFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbeilleJDynForm(DynFormSPIManager manager, JDynFormFactory factory, JDynForm.DynFormContext context, DynFormDefinition definition) {
        block6: {
            super(manager, factory, definition, context);
            this.components = null;
            this.resourceName = null;
            this.components = new HashMap<String, JDynFormField>();
            this.resourceName = (String)definition.getTags().get("dynform.abeille.form.resource");
            if (this.resourceName == null) {
                ResourcesStorage storage = null;
                try {
                    storage = context.getResourcesStorage();
                    if (storage.exists("jetaform")) {
                        this.resourceName = "jetaform";
                        break block6;
                    }
                    if (storage.exists("jfrm")) {
                        this.resourceName = "jfrm";
                        break block6;
                    }
                    throw new IllegalArgumentException("Can't locate form resource. Need tag 'dynform.abeille.form.resource' or resource 'jetaform'.");
                }
                finally {
                    DisposeUtils.disposeQuietly((Disposable)storage);
                }
            }
        }
        this.componentsFactory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JComponent getFieldsContainer() {
        InputStream is = null;
        FormPanel form = null;
        ResourcesStorage.Resource resource = null;
        try {
            File f = new File(this.resourceName);
            if (f.isAbsolute() && f.exists()) {
                is = new FileInputStream(f);
            } else {
                ResourcesStorage storage = null;
                try {
                    storage = this.getContext().getResourcesStorage();
                    resource = storage.getResource(FilenameUtils.getName((String)this.resourceName));
                    if (resource == null || !resource.exists()) {
                        throw new IllegalArgumentException("Can't locate abeille form '" + this.resourceName + "'.");
                    }
                    is = resource.asInputStream();
                }
                finally {
                    DisposeUtils.disposeQuietly((Disposable)storage);
                }
            }
            form = new FormPanel(is);
            this.componentsFactory = new AbeilleComponentsFactory(form);
            for (DynFormFieldDefinition definition : this.getDefinition().getDefinitions()) {
                if (definition == null || definition.isHidden() || !this.componentsFactory.containsComponents(definition)) continue;
                try {
                    JDynFormFieldFactory factory = this.getServiceManager().getJDynFormFieldFactory(this.getContext(), definition);
                    JDynFormField jfield = factory.create(this.getServiceManager(), (DynFormSPIManager.ComponentsFactory)this.componentsFactory, definition, null);
                    if (jfield instanceof AbstractJDynFormField) {
                        ((AbstractJDynFormField)jfield).setForm((JDynForm)this);
                    }
                    if (this.isReadOnly()) {
                        jfield.setReadOnly(true);
                    } else {
                        jfield.setReadOnly(definition.isReadOnly());
                    }
                    jfield.addListener((JDynFormField.JDynFormFieldListener)this);
                    this.configurePopupMenu(jfield);
                    this.components.put(jfield.getName(), jfield);
                    jfield.asJComponent();
                    jfield.getJLabel();
                }
                catch (Throwable th1) {
                    LOGGER.warn("Can't load field '" + definition.getName() + "' for abeille form '" + this.resourceName + "'.", th1);
                }
            }
            this.bindUserCode(form);
            this.callUserEvent("form_onLoad", new Object[]{this});
        }
        catch (Throwable th) {
            try {
                LOGGER.warn("Can't load abeille form '" + this.resourceName + "'.", th);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(resource);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly(resource);
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Closeable)resource);
        return form;
    }

    public Iterator getFieldsIterator() {
        if (!this.isContentsInitialized()) {
            this.initComponents();
        }
        return this.components.values().iterator();
    }

    public void setReadOnly(boolean readOnly) {
        if (this.isReadOnly() == readOnly) {
            return;
        }
        super.setReadOnly(readOnly);
        if (this.isContentsInitialized()) {
            Iterator it = this.getFieldsIterator();
            while (it.hasNext()) {
                JDynFormField field = (JDynFormField)it.next();
                if (readOnly) {
                    field.setReadOnly(true);
                    continue;
                }
                if (field.getDefinition().isReadOnly()) {
                    field.setReadOnly(true);
                    continue;
                }
                field.setReadOnly(false);
            }
        }
    }

    private void bindUserCode(FormPanel form) {
        Script theScript = this.getScript();
        if (theScript == null) {
            return;
        }
        List names = theScript.getNames();
        if (names == null) {
            return;
        }
        for (String name : names) {
            String componentName;
            Component c;
            if (!name.endsWith("_click") || !((c = form.getComponentByName(componentName = name.substring(0, name.length() - 6))) instanceof JButton)) continue;
            JButton button = (JButton)c;
            final String fnName = name;
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbeilleJDynForm.this.callUserEvent(fnName, new Object[]{e});
                }
            });
        }
    }

    public void setValues(DynObject values) {
        if (!this.isContentsInitialized()) {
            this.values = values;
            return;
        }
        for (JDynFormField jfield : this.getFields()) {
            String name = "unknown";
            try {
                name = jfield.getName();
                jfield.setValue(values.getDynValue(jfield.getName()));
            }
            catch (Exception ex) {
                LOGGER.warn("Can't set value to field '" + name + "'.", (Throwable)ex);
            }
        }
        this.callUserEvent("form_onSetvalues", new Object[]{this, values});
        try {
            if (((Boolean)this.callUserFunction("form_isReadOnly", new Object[]{this})).booleanValue()) {
                this.setReadOnly(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Iterable<JDynFormField> getFields() {
        if (!this.isContentsInitialized()) {
            this.initComponents();
        }
        return this.components.values();
    }

    public JDynFormField getField(String fieldName) {
        JDynFormField field = this.components.get(fieldName);
        return field;
    }

    public void getValues(DynObject values) {
        DynField[] fields;
        if (values == null) {
            return;
        }
        for (DynField field : fields = values.getDynClass().getDynFields()) {
            String name = field.getName();
            JDynFormField jfield = this.getField(name);
            if (jfield == null || jfield.isReadOnly()) continue;
            try {
                jfield.fetch(values);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't get value of field '" + name + "'.", (Throwable)ex);
            }
        }
    }

    public Object getValue(String fieldName) {
        JDynFormField field = this.getField(fieldName);
        return field.getValue();
    }

    public void setValue(String fieldName, Object value) {
        JDynFormField field = this.getField(fieldName);
        try {
            value = field.getDefinition().getDataType().coerce(value);
        }
        catch (CoercionException e) {
            String msg = "Invalid value '" + (value == null ? "(null)" : value.toString()) + "' for field '" + fieldName + "'.";
            LOGGER.warn(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        field.setValue(value);
    }

    public boolean hasValidValues() {
        for (JDynFormField jfield : this.getFields()) {
            if (jfield.hasValidValue()) continue;
            return false;
        }
        try {
            return (Boolean)this.callUserFunction("form_validate", new Object[]{this});
        }
        catch (Exception exception) {
            return true;
        }
    }

    public boolean hasValidValues(List<String> fieldsName) {
        if (fieldsName == null) {
            fieldsName = new ArrayList<String>();
        }
        for (JDynFormField jfield : this.getFields()) {
            if (jfield.hasValidValue()) continue;
            fieldsName.add(jfield.getName());
        }
        return fieldsName.isEmpty();
    }

    public boolean isModified() {
        if (this.isReadOnly()) {
            return false;
        }
        try {
            if (this.getScript() != null) {
                return (Boolean)this.callUserFunction("form_isModified", new Object[]{this, this.values});
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception ex) {
            LOGGER.warn("Error calling user function form_IsModified.", (Throwable)ex);
        }
        for (JDynFormField jfield : this.getFields()) {
            if (!jfield.isModified()) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        for (JDynFormField jfield : this.getFields()) {
            jfield.clear();
        }
        this.callUserEvent("form_clear", new Object[]{this});
    }

    public void fieldEnter(JDynFormField field) {
        this.message(field.getDefinition().getDescription());
        this.callUserEvent("form_onFieldEnter", new Object[]{this, field});
    }

    public void fieldExit(JDynFormField field) {
        this.message();
        this.callUserEvent("form_onFieldExit", new Object[]{this, field});
    }

    public void fieldChanged(JDynFormField field) {
        this.fireFieldChangeEvent(field);
        this.callUserEvent("form_onFieldChanged", new Object[]{this, field});
    }

    public void message(JDynFormField field, String message) {
        this.message(message);
    }

    private class AbeilleComponentsFactory
    implements DynFormSPIManager.ComponentsFactory {
        private static final String PREFIX_JCHECKBOX = "chk";
        private static final String PREFIX_JLABEL = "lbl";
        private static final String PREFIX_DROPDOWN = "lblDdn";
        private static final String PREFIX_JCOMBOBOX = "cbo";
        private static final String PREFIX_JSPINNER = "spn";
        private static final String PREFIX_JTEXTFIELD = "txt";
        private static final String PREFIX_JTEXTAREA = "txt";
        private static final String PREFIX_JBUTTON = "btn";
        private static final String PREFIX_JLIST = "lst";
        private static final String PREFIX_JTABLE = "tbl";
        private final FormPanel form;

        public AbeilleComponentsFactory(FormPanel form) {
            this.form = form;
        }

        public boolean containsComponents(DynFormFieldDefinition definition) {
            String[] prefixes;
            for (String prefix : prefixes = new String[]{PREFIX_JCHECKBOX, PREFIX_JLABEL, PREFIX_DROPDOWN, PREFIX_JCOMBOBOX, PREFIX_JSPINNER, "txt", "txt", PREFIX_JBUTTON, PREFIX_JLIST, PREFIX_JTABLE}) {
                Component component = this.form.getComponentByName(prefix + definition.getName());
                if (component == null) continue;
                return true;
            }
            return false;
        }

        public boolean containsJComboBox(DynFormFieldDefinition definition, String prefix) {
            Component component = this.form.getComponentByName(PREFIX_JCOMBOBOX + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
            return component instanceof JComboBox;
        }

        public boolean containsJButton(DynFormFieldDefinition definition, String prefix) {
            Component component = this.form.getComponentByName(PREFIX_JBUTTON + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
            return component instanceof JButton;
        }

        public boolean containsJToggleButton(DynFormFieldDefinition definition, String prefix) {
            Component component = this.form.getComponentByName(PREFIX_JBUTTON + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
            return component instanceof JToggleButton;
        }

        public boolean containsJLabel(DynFormFieldDefinition definition, String prefix) {
            Component component = this.form.getComponentByName(PREFIX_JLABEL + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
            return component instanceof JLabel;
        }

        public boolean containsJSpinner(DynFormFieldDefinition definition, String prefix) {
            Component component = this.form.getComponentByName(PREFIX_JSPINNER + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
            return component instanceof JSpinner;
        }

        public boolean containsJTextField(DynFormFieldDefinition definition, String prefix) {
            Component component = this.form.getComponentByName("txt" + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
            return component instanceof JTextComponent;
        }

        public boolean containsJTextArea(DynFormFieldDefinition definition, String prefix) {
            Component component = this.form.getComponentByName("txt" + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
            return component instanceof JTextComponent;
        }

        public JCheckBox getJCheckBox(DynFormFieldDefinition definition, String prefix) {
            try {
                Component component = this.form.getComponentByName(PREFIX_JCHECKBOX + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
                return (JCheckBox)component;
            }
            catch (Throwable th) {
                return null;
            }
        }

        public JLabel getJLabel(DynFormFieldDefinition definition, String prefix) {
            try {
                Component component = this.form.getComponentByName(PREFIX_JLABEL + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
                return (JLabel)component;
            }
            catch (Throwable th) {
                return null;
            }
        }

        public JComboBox getJComboBox(DynFormFieldDefinition definition, String prefix) {
            try {
                Component component = this.form.getComponentByName(PREFIX_JCOMBOBOX + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
                return (JComboBox)component;
            }
            catch (Throwable th) {
                return null;
            }
        }

        public JTextComponent getJTextField(DynFormFieldDefinition definition, String prefix) {
            try {
                Component component = this.form.getComponentByName("txt" + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
                return (JTextComponent)component;
            }
            catch (Throwable th) {
                return null;
            }
        }

        public JTextComponent getJPasswordField(DynFormFieldDefinition definition, String prefix) {
            return this.getJTextField(definition, prefix);
        }

        public DynFormSPIManager.ComponentsFactory.ScrolledComponent<JTextArea> getJTextArea(DynFormFieldDefinition definition, String prefix) {
            try {
                JTextArea component = (JTextArea)this.form.getComponentByName("txt" + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
                return new DefaultScrolledComponent<JTextArea>(component);
            }
            catch (Throwable th) {
                return null;
            }
        }

        public DynFormSPIManager.ComponentsFactory.ScrolledComponent<JList> getJList(DynFormFieldDefinition definition, String prefix) {
            try {
                JList component = (JList)this.form.getComponentByName(PREFIX_JLIST + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
                return new DefaultScrolledComponent<JList>(component);
            }
            catch (Throwable th) {
                return null;
            }
        }

        public DynFormSPIManager.ComponentsFactory.ScrolledComponent<JTable> getJTable(DynFormFieldDefinition definition, String prefix) {
            try {
                JTable component = (JTable)this.form.getComponentByName(PREFIX_JTABLE + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
                return new DefaultScrolledComponent<JTable>(component);
            }
            catch (Throwable th) {
                return null;
            }
        }

        public JSpinner getJSpinner(DynFormFieldDefinition definition, String prefix) {
            try {
                Component component = this.form.getComponentByName(PREFIX_JSPINNER + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
                return (JSpinner)component;
            }
            catch (Throwable th) {
                return null;
            }
        }

        public JButton getJButton(DynFormFieldDefinition definition, String prefix) {
            try {
                Component component = this.form.getComponentByName(PREFIX_JBUTTON + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
                return (JButton)component;
            }
            catch (Throwable th) {
                return null;
            }
        }

        public JToggleButton getJToggleButton(DynFormFieldDefinition definition, String prefix) {
            try {
                Component component = this.form.getComponentByName(PREFIX_JBUTTON + (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"") + definition.getName());
                return (JToggleButton)component;
            }
            catch (Throwable th) {
                return null;
            }
        }

        private class DefaultScrolledComponent<T>
        implements DynFormSPIManager.ComponentsFactory.ScrolledComponent<T> {
            private final T component;

            public DefaultScrolledComponent(T component) {
                this.component = component;
            }

            public JScrollPane getScrollPane() {
                try {
                    Container p1 = ((JComponent)this.component).getParent();
                    if (p1 instanceof JViewport) {
                        p1 = ((JComponent)this.component).getParent();
                    }
                    if (p1 instanceof JScrollPane) {
                        return (JScrollPane)p1;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }

            public T getComponent() {
                return this.component;
            }
        }
    }
}

