/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynformfield.URL;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.services.dynformfield.File.JDynFormFieldFile;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;

public class JDynFormFieldURL
extends JDynFormFieldFile {
    protected URL assignedValue = null;
    protected URL currentValue = null;

    public JDynFormFieldURL(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = (URL)value;
    }

    @Override
    public Object getValue() {
        URL value = null;
        String s = "";
        s = this.jtext.getText();
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        try {
            value = new URL(s);
        }
        catch (MalformedURLException e) {
            LOGGER.info("Error. URL Syntax: " + s.toString());
            value = null;
        }
        return value;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.jtext.setText("");
            this.assignedValue = null;
        } else {
            if (!(value instanceof URL)) {
                LOGGER.info("setValue invoked with non URL value (" + value.toString() + ").");
                return;
            }
            this.jtext.setText(((URL)value).toString());
            this.fixPreferredWidth(this.jtext);
            try {
                this.assignedValue = new URL(((URL)value).toString());
            }
            catch (MalformedURLException e) {
                LOGGER.info("Error in URL creation.");
                this.assignedValue = null;
            }
        }
        this.currentValue = this.assignedValue;
    }

    public File[] showOpenFileDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 0, 2, false, initialPath, null, false);
    }

    @Override
    public boolean isModified() {
        String s = this.jtext.getText();
        URL assigned = (URL)this.getAssignedValue();
        if (StringUtils.isBlank((CharSequence)s)) {
            return assigned != null;
        }
        try {
            URL value = new URL(s);
            return !Objects.equals(value, assigned);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

