/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.taskplanning.retrieving;

import java.util.Date;
import java.util.Vector;
import org.gvsig.remoteclient.taskplanning.FIFOTaskPlanner;
import org.gvsig.remoteclient.taskplanning.IQueue;
import org.gvsig.remoteclient.taskplanning.IRunnableTask;
import org.gvsig.remoteclient.taskplanning.ITaskPlanner;
import org.gvsig.remoteclient.taskplanning.retrieving.URLRequest;
import org.gvsig.remoteclient.taskplanning.retrieving.URLRetrieveTask;

public class RetrieveQueue
implements IQueue {
    private String hostName;
    private Date startTime;
    private Vector tasks = new Vector();
    private boolean waiting;
    private ITaskPlanner taskPlanner;
    private Worker worker;

    public RetrieveQueue(String hName) {
        this.hostName = hName;
        this.startTime = new Date();
        this.worker = new Worker();
        new Thread(this.worker).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRunnableTask put(IRunnableTask task) {
        this.tasks.add(task);
        if (this.waiting) {
            RetrieveQueue retrieveQueue = this;
            synchronized (retrieveQueue) {
                this.notifyAll();
            }
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRunnableTask take() {
        if (this.tasks.isEmpty()) {
            RetrieveQueue retrieveQueue = this;
            synchronized (retrieveQueue) {
                this.waiting = true;
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    this.waiting = false;
                }
            }
        }
        return this.getTaskPlanner().nextTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        RetrieveQueue retrieveQueue = this;
        synchronized (retrieveQueue) {
            return this.tasks.isEmpty() && !this.worker.r.isRunning();
        }
    }

    @Override
    public ITaskPlanner getTaskPlanner() {
        if (this.taskPlanner == null) {
            this.taskPlanner = new FIFOTaskPlanner(this);
        }
        return this.taskPlanner;
    }

    @Override
    public void setTaskPlanner(ITaskPlanner planner) {
        this.taskPlanner = planner;
    }

    @Override
    public void pause() {
        this.waiting = true;
    }

    @Override
    public void resume() {
        this.waiting = false;
    }

    @Override
    public Vector getTasks() {
        return this.tasks;
    }

    protected URLRetrieveTask getURLPreviousRequest(URLRequest request) {
        for (int i = 0; i < this.tasks.size(); ++i) {
            URLRetrieveTask task = (URLRetrieveTask)this.tasks.get(i);
            URLRequest aWorkingRequest = task.getRequest();
            if (!aWorkingRequest.equals(request)) continue;
            return task;
        }
        return null;
    }

    private class Worker
    implements Runnable {
        URLRetrieveTask r;
        int i = 0;

        private Worker() {
        }

        @Override
        public void run() {
            while (true) {
                this.r = (URLRetrieveTask)RetrieveQueue.this.take();
                this.r.execute();
            }
        }
    }
}

