/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.utils;

public class BoundaryBox {
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private String srs;

    public double getXmin() {
        return this.xmin;
    }

    public void setXmin(double _xmin) {
        this.xmin = _xmin;
    }

    public double getXmax() {
        return this.xmax;
    }

    public void setXmax(double _xmax) {
        this.xmax = _xmax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public void setYmin(double _ymin) {
        this.ymin = _ymin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public void setYmax(double _ymax) {
        this.ymax = _ymax;
    }

    public String getSrs() {
        return this.srs;
    }

    public void setSrs(String _srs) {
        this.srs = _srs;
    }

    public String toString() {
        String s = this.srs + " (" + this.xmin + ", " + this.ymin + ", " + this.xmax + ", " + this.ymax + ")";
        return s;
    }

    public static boolean validLat(double v) {
        return v >= -90.0 && v <= 90.0;
    }

    public static boolean validLon(double v) {
        return v >= -180.0 && v <= 180.0;
    }

    public static BoundaryBox clipGeodeticBBox(BoundaryBox bbox) {
        BoundaryBox resp = new BoundaryBox();
        resp.setSrs(bbox.getSrs());
        resp.setXmin(bbox.getXmin());
        resp.setXmax(bbox.getXmax());
        resp.setYmin(bbox.getYmin());
        resp.setYmax(bbox.getYmax());
        if (resp.getXmax() > resp.getXmin() && BoundaryBox.validLon(resp.getXmin()) && !BoundaryBox.validLon(resp.getXmax())) {
            resp.setXmax(180.0);
        } else if (resp.getXmax() > resp.getXmin() && !BoundaryBox.validLon(resp.getXmin()) && BoundaryBox.validLon(resp.getXmax())) {
            resp.setXmin(-180.0);
        } else if (!(resp.getXmax() > resp.getXmin() && BoundaryBox.validLon(resp.getXmin()) && BoundaryBox.validLon(resp.getXmax()))) {
            resp.setXmax(180.0);
            resp.setXmin(-180.0);
        }
        if (resp.getYmax() > resp.getYmin() && BoundaryBox.validLat(resp.getYmin()) && !BoundaryBox.validLat(resp.getYmax())) {
            resp.setYmax(90.0);
        } else if (resp.getYmax() > resp.getYmin() && !BoundaryBox.validLat(resp.getYmin()) && BoundaryBox.validLat(resp.getYmax())) {
            resp.setYmin(-90.0);
        } else if (!(resp.getYmax() > resp.getYmin() && BoundaryBox.validLat(resp.getYmin()) && BoundaryBox.validLat(resp.getYmax()))) {
            resp.setYmax(90.0);
            resp.setYmin(-90.0);
        }
        return resp;
    }
}

