/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl;

import java.text.MessageFormat;
import org.gvsig.installer.lib.api.Dependency;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.Version;
import org.gvsig.installer.lib.impl.DefaultVersion;
import org.gvsig.tools.exception.BaseRuntimeException;
import org.gvsig.tools.packageutils.StringWithAlias;
import org.gvsig.tools.packageutils.impl.DefaultStringWithAlias;

public class DefaultDependency
implements Dependency {
    private String type;
    private StringWithAlias code;
    private String op;
    private Version version;

    public DefaultDependency() {
        this.clear();
    }

    public DefaultDependency(PackageInfo packageInfo) {
        this();
        this.code = packageInfo.getAllCodes();
        this.type = "required";
        this.op = ">=";
        this.version = packageInfo.getVersion();
    }

    public void clear() {
        this.type = "required";
        this.code = new DefaultStringWithAlias("unknow");
        this.op = "=";
        this.version = new DefaultVersion();
    }

    public Dependency parse(String dependency) {
        if (dependency == null) {
            this.clear();
            return this;
        }
        if ((dependency = dependency.trim()).equals("")) {
            this.clear();
            return this;
        }
        String s = dependency;
        s = s.replace('\n', ' ');
        s = s.replace('\t', ' ');
        s = s.replace('\r', ' ');
        s = s.replace(':', ' ');
        while (s.indexOf("  ") != -1) {
            s = s.replaceAll("  ", " ");
        }
        String[] x = s.split(" ");
        if (x.length != 4) {
            throw new InvalidDependencyFormatException(dependency);
        }
        this.type = x[0];
        this.code = new DefaultStringWithAlias(x[1]);
        this.op = x[2];
        this.version.parse(x[3]);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public String getCode() {
        return this.code.toString();
    }

    public String getOp() {
        return this.op;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean match(String type, String code, Version version) {
        if (!this.type.equalsIgnoreCase(type)) {
            return false;
        }
        if (!this.code.equalsIgnoreCase((Object)code)) {
            return false;
        }
        return version.check(this.op, this.version);
    }

    public boolean match(String type, StringWithAlias code, Version version) {
        if (!this.type.equalsIgnoreCase(type)) {
            return false;
        }
        if (!code.equalsIgnoreCase((Object)this.code)) {
            return false;
        }
        return version.check(this.op, this.version);
    }

    public String toString() {
        return MessageFormat.format("{0}: {1} {2} {3}", this.type, this.code.toString(), this.op, this.version.toString());
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultDependency x = (DefaultDependency)super.clone();
        x.version = (Version)this.version.clone();
        return x;
    }

    public boolean equals(Object obj) {
        Dependency other;
        try {
            other = (Dependency)obj;
        }
        catch (Exception ex) {
            return false;
        }
        if (!this.code.equalsIgnoreCase((Object)other.getCode())) {
            return false;
        }
        if (!this.type.equalsIgnoreCase(other.getType())) {
            return false;
        }
        if (!this.op.equalsIgnoreCase(other.getOp())) {
            return false;
        }
        return this.version.equals(other.getVersion());
    }

    public int hashCode() {
        return this.version.hashCode() + this.code.hashCode() + this.type.hashCode() + this.op.hashCode();
    }

    private class InvalidDependencyFormatException
    extends BaseRuntimeException {
        private static final long serialVersionUID = 2856837862117653856L;
        private static final String message = "Error parsing dependecy '%(dependency)s'";
        private static final String KEY = "_Error_parsing_dependecy_XdependecyX";

        public InvalidDependencyFormatException(String dependency) {
            super(message, null, KEY, 2856837862117653856L);
            this.setValue("dependency", dependency);
        }
    }
}

