/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.lib.impl.creation;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.creation.MakePluginPackageService;
import org.gvsig.installer.lib.api.creation.MakePluginPackageServiceException;
import org.gvsig.installer.lib.impl.DefaultPackageInfo;
import org.gvsig.installer.lib.impl.utils.DeleteFile;
import org.gvsig.installer.lib.spi.InstallPackageProviderServices;
import org.gvsig.installer.lib.spi.InstallerProviderLocator;
import org.gvsig.tools.service.Manager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMakePluginPackageService
implements MakePluginPackageService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMakePluginPackageService.class);
    public static final String ANT_FILE_NAME = "install.xml";
    public static final String COPIED_FILES_DIRECTORY_NAME = "files";
    private static final Logger logger = LoggerFactory.getLogger(DefaultMakePluginPackageService.class);
    private final InstallerManager manager;
    private List<PackageInfo> installerInfos = null;
    protected String antScript = null;
    private InstallPackageProviderServices installerProviderServices = null;

    public DefaultMakePluginPackageService(InstallerManager manager) throws MakePluginPackageServiceException {
        this.manager = manager;
        this.installerInfos = new ArrayList<PackageInfo>();
        this.installerProviderServices = InstallerProviderLocator.getProviderManager().createInstallerProviderServices();
        this.initialize();
    }

    private void initialize() throws MakePluginPackageServiceException {
        List addonFolders = this.manager.getAddonFolders();
        if (addonFolders == null) {
            throw new MakePluginPackageServiceException("The addonFolders list is null");
        }
        for (int i = 0; i < addonFolders.size(); ++i) {
            File copiedFilesDirectory;
            File pluginDirectoryFile = (File)addonFolders.get(i);
            if (!pluginDirectoryFile.exists()) {
                pluginDirectoryFile.mkdirs();
                LOG.info("Plugins folder created: {}", (Object)pluginDirectoryFile);
            }
            DefaultPackageInfo packageInfo = new DefaultPackageInfo();
            this.installerProviderServices.readPackageInfo(new File(pluginDirectoryFile.getAbsolutePath()), (PackageInfo)packageInfo);
            File antFile = this.getAntFile(pluginDirectoryFile);
            if (antFile.exists()) {
                try {
                    packageInfo.setAntScript(this.readFileAsString(antFile.getAbsolutePath()));
                }
                catch (IOException e) {
                    logger.error("Not possible to read the ant file");
                }
            }
            if ((copiedFilesDirectory = this.getCopiedFilesDirectory(pluginDirectoryFile)).exists()) {
                this.loadCopiedFiles(copiedFilesDirectory, copiedFilesDirectory, packageInfo);
            }
            this.installerInfos.add(packageInfo);
        }
    }

    private void loadCopiedFiles(File file, File filesDirectory, PackageInfo packageInfo) throws MakePluginPackageServiceException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.loadCopiedFiles(files[i], filesDirectory, packageInfo);
            }
        } else {
            String pluginFileName = file.getAbsolutePath().substring(filesDirectory.getAbsolutePath().length(), file.getAbsolutePath().length());
            File pluginFile = new File(System.getProperty("user.dir") + pluginFileName);
            packageInfo.getFilesToCopy().add(pluginFile);
        }
    }

    public void createPackageSet(PackageInfo packageInfo, OutputStream packageStream) throws MakePluginPackageServiceException {
        LOG.debug("Creating a package set of the package info: \n{0}", (Object)packageInfo);
        String pluginFileName = this.manager.getPackageFileName(packageInfo);
        this.installerProviderServices.compressPackageSet(this.getAbsolutePluginPackageDirectory(packageInfo), pluginFileName, packageStream);
    }

    public void preparePackage(PackageInfo packageInfo, File originalPluginDir) throws MakePluginPackageServiceException {
        LOG.debug("Preparing a package set of the package info: \n{0}", (Object)packageInfo);
        this.writePackageInfo(packageInfo);
        if (packageInfo.getAntScript() != null) {
            this.writeAntFile(packageInfo);
            this.writeSelectedFiles(packageInfo);
        }
    }

    public void createPackage(PackageInfo packageInfo, OutputStream packageStream) throws MakePluginPackageServiceException {
        LOG.debug("Creating package of the package info: \n{0}", (Object)packageInfo);
        this.installerProviderServices.compressPackage(this.getAbsolutePluginPackageDirectory(packageInfo), packageStream);
    }

    public void createPackageIndex(PackageInfo packageInfo, OutputStream packageStream) throws MakePluginPackageServiceException {
        LOG.debug("Creating package index of the package info: \n{0}", (Object)packageInfo);
        this.installerProviderServices.compressPackageIndex(this.getAbsolutePluginPackageDirectory(packageInfo), packageStream);
    }

    private void writePackageInfo(PackageInfo packageInfo) throws MakePluginPackageServiceException {
        this.writePackageInfo(packageInfo, this.getAbsolutePluginPackageDirectory(packageInfo));
    }

    public void writePackageInfo(PackageInfo packageInfo, File folder) throws MakePluginPackageServiceException {
        this.installerProviderServices.writePackageInfo(folder, packageInfo);
    }

    public void writePackageInfoForIndex(PackageInfo packageInfo, File folder) throws MakePluginPackageServiceException {
        this.installerProviderServices.writePackageInfoForIndex(folder, packageInfo);
    }

    private void createInstallDirInPluginDir(PackageInfo packageInfo) throws MakePluginPackageServiceException {
        File pluginDirectory = this.getAbsolutePluginPackageDirectory(packageInfo);
        File installdir = new File(pluginDirectory, "install");
        installdir.mkdir();
    }

    private void writeAntFile(PackageInfo packageInfo) throws MakePluginPackageServiceException {
        try {
            int len;
            this.createInstallDirInPluginDir(packageInfo);
            ByteArrayInputStream in = new ByteArrayInputStream(packageInfo.getAntScript().getBytes());
            FileOutputStream out = new FileOutputStream(this.getAbsoluteAntFile(packageInfo));
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new MakePluginPackageServiceException("Exception writing the ant file");
        }
    }

    private void writeSelectedFiles(PackageInfo packageInfo) throws MakePluginPackageServiceException {
        try {
            this.createInstallDirInPluginDir(packageInfo);
            String copiedFilesDirectoryName = this.getAbsoulteCopiedFilesDirectoryName(packageInfo);
            File copiedFilesDirectoryfile = new File(copiedFilesDirectoryName);
            DefaultMakePluginPackageService.deleteDirectory(copiedFilesDirectoryfile);
            String applicationDirectory = System.getProperty("user.dir");
            List files = packageInfo.getFilesToCopy();
            for (int i = 0; i < files.size(); ++i) {
                String sourceFile = ((File)files.get(i)).getAbsolutePath();
                String destFile = sourceFile.substring(applicationDirectory.length(), sourceFile.length());
                destFile = copiedFilesDirectoryName + destFile;
                this.copy(new File(sourceFile), new File(destFile));
            }
        }
        catch (IOException e) {
            throw new MakePluginPackageServiceException("Exception copying the files", (Throwable)e);
        }
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    DefaultMakePluginPackageService.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    private void copy(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                this.copy(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            int len;
            targetLocation.getParentFile().mkdirs();
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    private File getCopiedFilesDirectory(File pluginDirectory) throws MakePluginPackageServiceException {
        return new File(pluginDirectory.getAbsolutePath() + File.separator + "install" + File.separator + COPIED_FILES_DIRECTORY_NAME);
    }

    private String getAbsoulteCopiedFilesDirectoryName(PackageInfo packageInfo) throws MakePluginPackageServiceException {
        return this.getAbsolutePluginPackageDirectory(packageInfo).getAbsolutePath() + File.separator + "install" + File.separator + COPIED_FILES_DIRECTORY_NAME;
    }

    private File getAntFile(File pluginDirectory) throws MakePluginPackageServiceException {
        return new File(pluginDirectory.getAbsolutePath() + File.separator + "install" + File.separator + ANT_FILE_NAME);
    }

    private File getAbsoluteAntFile(PackageInfo packageInfo) throws MakePluginPackageServiceException {
        String destinationFilePath = this.manager.getDefaultLocalAddonRepository().getAbsolutePath() + File.separator + packageInfo.getCode();
        return new File(destinationFilePath + File.separator + "install" + File.separator + ANT_FILE_NAME);
    }

    private File getAbsolutePluginPackageDirectory(PackageInfo packageInfo) throws MakePluginPackageServiceException {
        File folder = this.manager.getAddonFolder(packageInfo.getCode());
        if (folder == null) {
            folder = this.manager.getDefaultLocalAddonRepository(packageInfo.getType(), 1);
            folder = new File(folder, packageInfo.getCode());
        }
        return folder.getAbsoluteFile();
    }

    public Manager getManager() {
        return this.manager;
    }

    public PackageInfo getPluginPackageInfo(int index) {
        if (index >= this.installerInfos.size()) {
            return null;
        }
        return this.installerInfos.get(index);
    }

    public PackageInfo getPluginPackageInfo(String code) {
        for (int i = 0; i < this.getPluginPackageCount(); ++i) {
            if (this.installerInfos.get(i).getCode() == null || !this.installerInfos.get(i).getCode().equals(code)) continue;
            return this.installerInfos.get(i);
        }
        DefaultPackageInfo info = new DefaultPackageInfo();
        info.setCode(code);
        return info;
    }

    public int getPluginPackageCount() {
        return this.installerInfos.size();
    }

    public String getDefaultAntScript() throws MakePluginPackageServiceException {
        try {
            URL resource = this.getClass().getResource(ANT_FILE_NAME);
            return this.readUrlAsString(resource);
        }
        catch (IOException e) {
            throw new MakePluginPackageServiceException("Impossible to read the default ant file", (Throwable)e);
        }
    }

    private String readUrlAsString(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        InputStream inputStream = urlConnection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer fileData = new StringBuffer(1000);
        String line = bufferedReader.readLine();
        while (line != null) {
            fileData.append(line + "\n");
            line = bufferedReader.readLine();
        }
        bufferedReader.close();
        return fileData.toString();
    }

    private String readFileAsString(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    public PackageInfo[] getInstalledPackages() throws MakePluginPackageServiceException {
        return this.installerInfos.toArray(new PackageInfo[this.installerInfos.size()]);
    }

    public File getPluginFolder(PackageInfo packageInfo) throws MakePluginPackageServiceException {
        return this.getAbsolutePluginPackageDirectory(packageInfo);
    }

    public boolean deleteDir(File folder) {
        DeleteFile file = new DeleteFile();
        return file.delete(folder);
    }
}

