/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.CoordinateOperation;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CassiniSoldner
extends Projection {
    public static final Identifier CASS = new Identifier("EPSG", "9806", "Cassini-Soldner", "CASS");
    protected final double lat0;
    protected final double lon0 = this.getCentralMeridian();
    protected final double M0;
    protected final double FE;
    protected final double FN;
    protected final double k0;
    protected final double e;
    protected final double e2;

    public CassiniSoldner(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(CASS, ellipsoid, parameters);
        this.lat0 = this.getLatitudeOfOrigin();
        this.FE = this.getFalseEasting();
        this.FN = this.getFalseNorthing();
        this.e = ellipsoid.getEccentricity();
        this.e2 = ellipsoid.getSquareEccentricity();
        this.k0 = this.getScaleFactor();
        this.M0 = ellipsoid.arcFromLat(this.lat0);
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.CYLINDRICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.APHYLACTIC;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TANGENT;
    }

    @Override
    public double[] transform(double[] coord) throws CoordinateDimensionException {
        double lon = coord[1];
        double lat = coord[0];
        double A = (lon - this.lon0) * Math.cos(lat);
        double A2 = A * A;
        double A4 = A2 * A2;
        double T = Math.pow(Math.tan(lat), 2.0);
        double C = this.e2 * Math.pow(Math.cos(lat), 2.0) / (1.0 - this.e2);
        double v = this.ellipsoid.transverseRadiusOfCurvature(lat);
        double M = this.ellipsoid.arcFromLat(lat);
        double dE = v * A * (1.0 - T * A2 / 6.0 - (8.0 * (1.0 + C) - T) * T * A4 / 120.0);
        double dN = M - this.M0 + v * Math.tan(lat) * (A2 / 2.0 + (5.0 - T + 6.0 * C) * A4 / 24.0);
        coord[0] = this.FE + dE;
        coord[1] = this.FN + dN;
        return coord;
    }

    @Override
    public CoordinateOperation inverse() throws NonInvertibleOperationException {
        return new CassiniSoldner(this.ellipsoid, this.parameters){

            public double[] transform(double[] coord) throws CoordinateDimensionException {
                double M1 = this.M0 + coord[1] - this.FN;
                double lat1 = this.ellipsoid.latFromArc(M1);
                double T1 = Math.pow(Math.tan(lat1), 2.0);
                double v1 = this.ellipsoid.transverseRadiusOfCurvature(lat1);
                double rho1 = this.ellipsoid.meridionalRadiusOfCurvature(lat1);
                double D = (coord[0] - this.FE) / v1;
                double D2 = D * D;
                coord[1] = this.lon0 + D * (1.0 - T1 * D2 / 3.0 + (1.0 + 3.0 * T1) * T1 * D2 * D2 / 15.0) / Math.cos(lat1);
                coord[0] = lat1 - v1 * Math.tan(lat1) / rho1 * D2 / 2.0 * (1.0 - (1.0 + 3.0 * T1) * D2 / 12.0);
                return coord;
            }
        };
    }
}

