/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.transformation.grid.GridShift;
import org.cts.op.transformation.grid.GridShiftFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTv2GridShiftTransformation
extends AbstractCoordinateOperation {
    static final Logger LOGGER = LoggerFactory.getLogger(NTv2GridShiftTransformation.class);
    private static final Identifier opId = new Identifier("EPSG", "9615", "NTv2 Geographic Offset", "NTv2");
    public static final int SPEED = 0;
    public static final int LOW_MEMORY = 1;
    private int mode = 1;
    private URL grid_file;
    private GridShiftFile gsf;

    public static NTv2GridShiftTransformation createNTv2GridShiftTransformation(String ntv2_gridName) throws URISyntaxException, MalformedURLException, NullPointerException {
        return new NTv2GridShiftTransformation(GridShift.class.getResource(ntv2_gridName).toURI().toURL());
    }

    public NTv2GridShiftTransformation(URL ntv2_gridFile, double precision) {
        super(opId);
        this.grid_file = ntv2_gridFile;
        this.gsf = new GridShiftFile();
        this.precision = Math.max(1.0E-9, precision);
    }

    public NTv2GridShiftTransformation(URL ntv2_gridFile) {
        super(opId);
        this.grid_file = ntv2_gridFile;
        if (ntv2_gridFile == null) {
            LOGGER.warn("No NTv2 Grid file specified.");
        }
        this.gsf = new GridShiftFile();
    }

    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord.length < 2) {
            throw new CoordinateDimensionException(coord, 2);
        }
        GridShift gs = new GridShift();
        gs.setLatDegrees(coord[0] * 180.0 / Math.PI);
        gs.setLonPositiveEastDegrees(coord[1] * 180.0 / Math.PI);
        try {
            boolean withinGrid;
            if (this.gsf == null) {
                this.loadGridShiftFile();
            }
            if (withinGrid = this.gsf.gridShiftForward(gs)) {
                coord[0] = gs.getShiftedLatDegrees() * Math.PI / 180.0;
                coord[1] = gs.getShiftedLonPositiveEastDegrees() * Math.PI / 180.0;
            }
        }
        catch (IOException ioe) {
            throw new CoordinateDimensionException(ioe.getMessage());
        }
        return coord;
    }

    public CoordinateOperation inverse() throws NonInvertibleOperationException {
        return new NTv2GridShiftTransformation(this.grid_file, this.precision){

            public double[] transform(double[] coord) throws IllegalCoordinateException {
                if (coord.length < 2) {
                    throw new CoordinateDimensionException(coord, 2);
                }
                GridShift gs = new GridShift();
                gs.setLatDegrees(coord[0] * 180.0 / Math.PI);
                gs.setLonPositiveEastDegrees(coord[1] * 180.0 / Math.PI);
                try {
                    boolean withinGrid;
                    if (NTv2GridShiftTransformation.this.gsf == null) {
                        this.loadGridShiftFile();
                    }
                    if (withinGrid = NTv2GridShiftTransformation.this.gsf.gridShiftReverse(gs)) {
                        coord[0] = gs.getShiftedLatDegrees() * Math.PI / 180.0;
                        coord[1] = gs.getShiftedLonPositiveEastDegrees() * Math.PI / 180.0;
                    }
                }
                catch (IOException ioe) {
                    throw new CoordinateDimensionException(ioe.getMessage());
                }
                return coord;
            }

            public CoordinateOperation inverse() throws NonInvertibleOperationException {
                return NTv2GridShiftTransformation.this;
            }
        };
    }

    public void loadGridShiftFile() throws IOException {
        if (this.grid_file != null) {
            if (this.mode == 0) {
                if (this.grid_file.getProtocol().equals("file")) {
                    File file = new File(this.grid_file.getFile());
                    if (!file.exists() || !file.canRead()) {
                        LOGGER.warn("This grid doesn't exist or cannot be read.");
                    } else {
                        this.gsf.loadGridShiftFile(new FileInputStream(file), false);
                    }
                } else {
                    BufferedInputStream is = new BufferedInputStream(this.grid_file.openConnection().getInputStream());
                    this.gsf.loadGridShiftFile(is, false);
                }
            } else if (this.mode == 1) {
                if (this.grid_file.getProtocol().equals("file")) {
                    File file = new File(this.grid_file.getFile());
                    if (!file.exists() || !file.canRead()) {
                        LOGGER.warn("This grid doesn't exist or cannot be read.");
                    } else {
                        this.gsf.loadGridShiftFile(new RandomAccessFile(file, "r"));
                    }
                } else {
                    LOGGER.warn("This grid cannot be accessed.");
                }
            } else {
                LOGGER.warn("This mode is not supported. The grid won't be used.");
            }
        } else {
            LOGGER.warn("The location of the grid is null. Any grid will be used.");
        }
    }

    public boolean isLoaded() {
        return this.gsf.isLoaded();
    }

    public void unload() throws IOException {
        this.gsf.unload();
    }

    public boolean setMode(int mode) throws IOException {
        if ((mode == 0 || mode == 1) && this.mode != mode) {
            this.mode = mode;
            this.unload();
            this.loadGridShiftFile();
            return true;
        }
        return false;
    }

    public String toString() {
        return "NTv2 Geographic Offset (" + this.grid_file + ")";
    }

    public String getFromDatum() {
        return this.gsf.getFromEllipsoid().trim().toLowerCase();
    }

    public String getToDatum() {
        return this.gsf.getToEllipsoid().trim().toLowerCase();
    }
}

