/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.awt.Color;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.ReprMethod;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.util.PropertiesSupportHelper;

public class DefaultExpressionBuilder
implements ExpressionBuilder {
    private static final String FORMAT_QUOTE_FOR_STRINGS = "'";
    private static final String FORMAT_QUOTE_FOR_IDENTIFIERS = "\"";
    private static final String FORMAT_TRUE = "TRUE";
    private static final String FORMAT_FALSE = "FALSE";
    private static final String FORMAT_GROUP = "( {0} )";
    private static final String FORMAT_ISNULL = "( ({0}) IS NULL )";
    private static final String FORMAT_NOTISNULL = "( ({0}) IS NOT NULL )";
    private static final String FORMAT_OPERATOR_NOT = "( NOT ({0}) )";
    private static final String FORMAT_OPERATOR_AND = "({0} AND {1})";
    private static final String FORMAT_OPERATOR_OR = "({0} OR {1})";
    private static final String FORMAT_OPERATOR_EQ = "( ({0}) = ({1}) )";
    private static final String FORMAT_OPERATOR_NE = "( ({0}) <> ({1}) )";
    private static final String FORMAT_OPERATOR_GT = "( ({0}) > ({1}) )";
    private static final String FORMAT_OPERATOR_GE = "( ({0}) >= ({1}) )";
    private static final String FORMAT_OPERATOR_LT = "( ({0}) < ({1}) )";
    private static final String FORMAT_OPERATOR_LE = "( ({0}) <= ({1}) )";
    private static final String FORMAT_OPERATOR_LIKE = "( ({0}) LIKE ({1}) )";
    private static final String FORMAT_OPERATOR_ILIKE = "( ({0}) ILIKE ({1}) )";
    private static final String FORMAT_OPERATOR_ADD = "{0} + {1}";
    private static final String FORMAT_OPERATOR_SUBST = "{0} - {1}";
    private static final String FORMAT_OPERATOR_MULT = "({0} * {1})";
    private static final String FORMAT_OPERATOR_DIV = "({0} / {1})";
    private static final String FORMAT_OPERATOR_CONCAT = "{0} || {1}";
    private final PropertiesSupportHelper propertiesHelper;
    protected ExpressionBuilder.Value value;
    protected ExpressionEvaluatorManager manager;
    protected Formatter<ExpressionBuilder.Value> formatter;

    public DefaultExpressionBuilder(ExpressionEvaluatorManager manager) {
        this.manager = manager;
        this.propertiesHelper = new PropertiesSupportHelper();
    }

    public Object getProperty(String name) {
        return this.propertiesHelper.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.propertiesHelper.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesHelper.getProperties();
    }

    public void setProperties(Class filter, final Object ... values) {
        for (int i = 0; i < values.length; i += 2) {
            this.propertiesHelper.setProperty((String)values[i], values[i + 1]);
        }
        this.accept(new ExpressionBuilder.Visitor(){

            public void visit(ExpressionBuilder.Visitable v) {
                for (int i = 0; i < values.length; i += 2) {
                    ((ExpressionBuilder.Value)v).setProperty((String)values[i], values[i + 1]);
                }
            }
        }, (ExpressionBuilder.VisitorFilter)new ExpressionBuilder.ClassVisitorFilter(filter));
    }

    public Formatter<ExpressionBuilder.Value> formatter() {
        if (this.formatter == null) {
            this.formatter = this.manager.getExpressionBuilderFormatter();
        }
        return this.formatter;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public ExpressionBuilder createExpressionBuilder() {
        return new DefaultExpressionBuilder(this.manager);
    }

    public ExpressionBuilder.Value value() {
        return this.value;
    }

    public ExpressionBuilder value(ExpressionBuilder.Value value) {
        this.value = value;
        return this;
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public String toString(Formatter<ExpressionBuilder.Value> formatter) {
        if (this.value == null) {
            return "";
        }
        return this.value.toString(formatter);
    }

    public String build() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public String build(Formatter<ExpressionBuilder.Value> formatter) {
        if (this.value == null) {
            return null;
        }
        return this.value.toString(formatter);
    }

    public ExpressionBuilder.Value toValue(String expression) {
        try {
            Code code = ExpressionUtils.compile((String)expression);
            code.link((SymbolTable)ExpressionUtils.createSymbolTable());
            return code.toValue((ExpressionBuilder)this);
        }
        catch (Throwable ex) {
            return this.custom(expression);
        }
    }

    public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
        if (this.value == null) {
            return;
        }
        this.value.accept(visitor, filter);
    }

    public String quote_for_identifiers() {
        return FORMAT_QUOTE_FOR_IDENTIFIERS;
    }

    public String quote_for_strings() {
        return FORMAT_QUOTE_FOR_STRINGS;
    }

    public String string(String s) {
        String quote = this.quote_for_strings();
        if (s.startsWith(quote)) {
            return s;
        }
        return quote + StringUtils.replace((String)s, (String)quote, (String)(quote + quote)) + quote;
    }

    public String identifier(String id) {
        String quote = this.quote_for_identifiers();
        if (id.startsWith(quote)) {
            return id;
        }
        return quote + id + quote;
    }

    public String bytearray_hex(byte[] data) {
        StringBuilder builder = new StringBuilder();
        for (byte abyte : data) {
            int v = abyte & 0xFF;
            builder.append(String.format("%02x", v));
        }
        return builder.toString();
    }

    public String bytearray_0x(byte[] data) {
        return "0x" + this.bytearray_hex(data);
    }

    public String bytearray_x(byte[] data) {
        return "x'" + this.bytearray_hex(data) + FORMAT_QUOTE_FOR_STRINGS;
    }

    public ExpressionBuilder.Constant bytearray(byte[] data) {
        return new ConstantBase(this, data);
    }

    public ExpressionBuilder.Variable variable(String name) {
        return new VariableBase(this, name);
    }

    public ExpressionBuilder.Variable column(String name) {
        return new VariableBase(this, name);
    }

    public ExpressionBuilder.Value column(String tableName, String columnName) {
        return this.getattr(tableName, columnName);
    }

    public ExpressionBuilder.Parameter parameter(String name) {
        List<ExpressionBuilder.Parameter> parameters = this.parameters();
        for (ExpressionBuilder.Parameter parameter : parameters) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)parameter.name())) continue;
            return parameter;
        }
        ExpressionBuilder.Parameter parameter = this.parameter();
        parameter.name(name);
        return parameter;
    }

    public ExpressionBuilder.Parameter parameter() {
        return new ParameterBase();
    }

    public ExpressionBuilder.Constant constant(Object value) {
        if (value == null) {
            return VALUE_NULL;
        }
        return new ConstantBase(this, value);
    }

    public ExpressionBuilder.Constant constant(Object value, Class theClass) {
        try {
            DataTypesManager dataTypeManager = ToolsLocator.getDataTypesManager();
            Coercion coercion = dataTypeManager.getDataType(theClass).getCoercion();
            return this.constant(coercion.coerce(value));
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't coerce value (" + Objects.toString(value) + ") to " + theClass.getSimpleName() + ".", ex);
        }
    }

    public ExpressionBuilder.Constant constant(Object value, int type) {
        try {
            DataTypesManager dataTypeManager = ToolsLocator.getDataTypesManager();
            Coercion coercion = dataTypeManager.getCoercion(type);
            return this.constant(coercion.coerce(value));
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't coerce value (" + Objects.toString(value) + ") to " + type + ".", ex);
        }
    }

    public ExpressionBuilder.Group group(ExpressionBuilder.Value value) {
        return new GroupBase(value);
    }

    public ExpressionBuilder.Custom custom(Object value) {
        return new CustomBase(value);
    }

    public ExpressionBuilder.Method method(ExpressionBuilder.Value instance, String name, ExpressionBuilder.Value ... values) {
        MethodBase method = new MethodBase(instance, name);
        for (ExpressionBuilder.Value theValue : values) {
            method.parameter(theValue);
        }
        return method;
    }

    public ExpressionBuilder.Function function(String name, ExpressionBuilder.Value ... values) {
        FunctionBase func = new FunctionBase(name);
        for (ExpressionBuilder.Value theValue : values) {
            func.parameter(theValue);
        }
        return func;
    }

    public ExpressionBuilder.Function builtin_function(String name, String format, ExpressionBuilder.Value ... values) {
        FunctionBase func = new FunctionBase(name, format);
        for (ExpressionBuilder.Value theValue : values) {
            func.parameter(theValue);
        }
        return func;
    }

    public ExpressionBuilder.BinaryOperator binaryOperator(String name, ExpressionBuilder.Value leftOperand, ExpressionBuilder.Value rightOperand) {
        return this.binaryOperator(name, null, leftOperand, rightOperand);
    }

    public ExpressionBuilder.BinaryOperator binaryOperator(String name, String format, ExpressionBuilder.Value leftOperand, ExpressionBuilder.Value rightOperand) {
        BinaryOperatorBase operator = new BinaryOperatorBase(name, format);
        operator.left(leftOperand);
        operator.right(rightOperand);
        return operator;
    }

    public List<ExpressionBuilder.Variable> variables() {
        HashSet vars = new HashSet();
        this.accept(value1 -> {
            if (!vars.contains((ExpressionBuilder.Variable)value1)) {
                vars.add((ExpressionBuilder.Variable)value1);
            }
        }, (ExpressionBuilder.VisitorFilter)new ExpressionBuilder.ClassVisitorFilter(ExpressionBuilder.Variable.class));
        ArrayList<ExpressionBuilder.Variable> lvars = new ArrayList<ExpressionBuilder.Variable>(vars);
        Collections.sort(lvars);
        return lvars;
    }

    public List<ExpressionBuilder.Parameter> parameters() {
        ArrayList<ExpressionBuilder.Parameter> params = new ArrayList<ExpressionBuilder.Parameter>();
        this.accept(value1 -> params.add((ExpressionBuilder.Parameter)value1), (ExpressionBuilder.VisitorFilter)new ExpressionBuilder.ClassVisitorFilter(ExpressionBuilder.Parameter.class));
        return params;
    }

    public List<String> parameters_names() {
        ArrayList<String> params = new ArrayList<String>();
        for (ExpressionBuilder.Parameter param : this.parameters()) {
            String s;
            Object theValue = param.value();
            switch (param.type()) {
                case 0: {
                    if (theValue == null) {
                        s = "NULL";
                        break;
                    }
                    if (theValue instanceof String) {
                        s = FORMAT_QUOTE_FOR_STRINGS + (String)theValue + FORMAT_QUOTE_FOR_STRINGS;
                        break;
                    }
                    if (theValue instanceof byte[]) {
                        s = this.bytearray_0x((byte[])theValue);
                        break;
                    }
                    s = theValue.toString();
                    break;
                }
                default: {
                    s = FORMAT_QUOTE_FOR_IDENTIFIERS + param.name() + FORMAT_QUOTE_FOR_IDENTIFIERS;
                }
            }
            params.add(s);
        }
        return params;
    }

    public List<String> variables_names() {
        ArrayList<String> vars = new ArrayList<String>();
        for (ExpressionBuilder.Variable var : this.variables()) {
            vars.add(var.name());
        }
        Collections.sort(vars);
        return vars;
    }

    public ExpressionBuilder set(ExpressionBuilder.Value value) {
        this.value = value;
        return this;
    }

    public ExpressionBuilder and(ExpressionBuilder.Value value) {
        if (this.value == null) {
            return this.set(value);
        }
        ExpressionBuilder.BinaryOperator operator = this.binaryOperator("AND", FORMAT_OPERATOR_AND, this.value, value);
        this.value = operator;
        return this;
    }

    public ExpressionBuilder or(ExpressionBuilder.Value value) {
        if (this.value == null) {
            return this.set(value);
        }
        ExpressionBuilder.BinaryOperator operator = this.binaryOperator("OR", FORMAT_OPERATOR_OR, this.value, value);
        this.value = operator;
        return this;
    }

    public ExpressionBuilder.Function is_null(ExpressionBuilder.Value value) {
        return this.builtin_function("IS NULL", FORMAT_ISNULL, value);
    }

    public ExpressionBuilder.Function not_is_null(ExpressionBuilder.Value value) {
        return this.builtin_function("IS NOT NULL", FORMAT_NOTISNULL, value);
    }

    public ExpressionBuilder.Function not(ExpressionBuilder.Value value) {
        return this.builtin_function("NOT", FORMAT_OPERATOR_NOT, value);
    }

    public ExpressionBuilder.BinaryOperator and(ExpressionBuilder.Value leftOperand, ExpressionBuilder.Value rightOperand) {
        return this.binaryOperator("AND", FORMAT_OPERATOR_AND, leftOperand, rightOperand);
    }

    public ExpressionBuilder.BinaryOperator and(Expression leftOperand, Expression rightOperand) {
        return this.binaryOperator("AND", FORMAT_OPERATOR_AND, leftOperand.getCode().toValue(), rightOperand.getCode().toValue());
    }

    public ExpressionBuilder.BinaryOperator and(Expression leftOperand, ExpressionBuilder.Value rightOperand) {
        return this.binaryOperator("AND", FORMAT_OPERATOR_AND, leftOperand.getCode().toValue(), rightOperand);
    }

    public ExpressionBuilder.BinaryOperator or(ExpressionBuilder.Value leftOperand, ExpressionBuilder.Value rightOperand) {
        return this.binaryOperator("OR", FORMAT_OPERATOR_OR, leftOperand, rightOperand);
    }

    public ExpressionBuilder.BinaryOperator eq(ExpressionBuilder.Value leftOperand, ExpressionBuilder.Value rightOperand) {
        return this.binaryOperator("=", FORMAT_OPERATOR_EQ, leftOperand, rightOperand);
    }

    public ExpressionBuilder.BinaryOperator ne(ExpressionBuilder.Value leftOperand, ExpressionBuilder.Value rightOperand) {
        return this.binaryOperator("<>", FORMAT_OPERATOR_NE, leftOperand, rightOperand);
    }

    public ExpressionBuilder.BinaryOperator gt(ExpressionBuilder.Value op1, ExpressionBuilder.Value op2) {
        return this.binaryOperator(">", FORMAT_OPERATOR_GT, op1, op2);
    }

    public ExpressionBuilder.BinaryOperator ge(ExpressionBuilder.Value op1, ExpressionBuilder.Value op2) {
        return this.binaryOperator(">=", FORMAT_OPERATOR_GE, op1, op2);
    }

    public ExpressionBuilder.BinaryOperator lt(ExpressionBuilder.Value op1, ExpressionBuilder.Value op2) {
        return this.binaryOperator("<", FORMAT_OPERATOR_LT, op1, op2);
    }

    public ExpressionBuilder.BinaryOperator le(ExpressionBuilder.Value op1, ExpressionBuilder.Value op2) {
        return this.binaryOperator("<=", FORMAT_OPERATOR_LE, op1, op2);
    }

    public ExpressionBuilder.BinaryOperator like(ExpressionBuilder.Value op1, ExpressionBuilder.Value op2) {
        return this.binaryOperator("LIKE", FORMAT_OPERATOR_LIKE, op1, op2);
    }

    public ExpressionBuilder.BinaryOperator ilike(ExpressionBuilder.Value op1, ExpressionBuilder.Value op2) {
        return this.binaryOperator("ILIKE", FORMAT_OPERATOR_ILIKE, op1, op2);
    }

    public ExpressionBuilder.BinaryOperator add(ExpressionBuilder.Value op1, ExpressionBuilder.Value op2) {
        return this.binaryOperator("+", FORMAT_OPERATOR_ADD, op1, op2);
    }

    public ExpressionBuilder.BinaryOperator subst(ExpressionBuilder.Value op1, ExpressionBuilder.Value op2) {
        return this.binaryOperator("-", FORMAT_OPERATOR_SUBST, op1, op2);
    }

    public ExpressionBuilder.BinaryOperator mult(ExpressionBuilder.Value op1, ExpressionBuilder.Value op2) {
        return this.binaryOperator("*", FORMAT_OPERATOR_MULT, op1, op2);
    }

    public ExpressionBuilder.BinaryOperator div(ExpressionBuilder.Value op1, ExpressionBuilder.Value op2) {
        return this.binaryOperator("/", FORMAT_OPERATOR_DIV, op1, op2);
    }

    public ExpressionBuilder.Function concat(ExpressionBuilder.Value ... values) {
        if (values.length == 2) {
            return this.binaryOperator("||", FORMAT_OPERATOR_CONCAT, values[0], values[1]);
        }
        FunctionBase func = new FunctionBase("CONCAT");
        for (ExpressionBuilder.Value theValue : values) {
            func.parameter(theValue);
        }
        return func;
    }

    public ExpressionBuilder.Function iif(ExpressionBuilder.Value condition, ExpressionBuilder.Value iftrue, ExpressionBuilder.Value iffalse) {
        return this.function("IIF", condition, iftrue, iffalse);
    }

    public ExpressionBuilder.Function ifnull(ExpressionBuilder.Value value, ExpressionBuilder.Value iftrue, ExpressionBuilder.Value iffalse) {
        return this.function("IFNULL", value, iftrue, iffalse);
    }

    public ExpressionBuilder.Function left(ExpressionBuilder.Value str, ExpressionBuilder.Value size) {
        return this.function("LEFT", str, size);
    }

    public ExpressionBuilder.Function right(ExpressionBuilder.Value str, ExpressionBuilder.Value len) {
        return this.function("RIGHT", str, len);
    }

    public ExpressionBuilder.Function locate(ExpressionBuilder.Value search, ExpressionBuilder.Value str, ExpressionBuilder.Value start) {
        return this.function("LOCATE", search, str, start);
    }

    public ExpressionBuilder.Function position(ExpressionBuilder.Value search, ExpressionBuilder.Value str) {
        return this.function("POSITION", search, str);
    }

    public ExpressionBuilder.Function lpad(ExpressionBuilder.Value str, ExpressionBuilder.Value len, ExpressionBuilder.Value padstr) {
        return this.function("LPAD", str, len, padstr);
    }

    public ExpressionBuilder.Function rpad(ExpressionBuilder.Value str, ExpressionBuilder.Value len, ExpressionBuilder.Value padstr) {
        return this.function("RPAD", str, len, padstr);
    }

    public ExpressionBuilder.Function ltrim(ExpressionBuilder.Value str) {
        return this.function("LTRIM", str);
    }

    public ExpressionBuilder.Function rtrim(ExpressionBuilder.Value str) {
        return this.function("RTRIM", str);
    }

    public ExpressionBuilder.Function trim(ExpressionBuilder.Value str) {
        return this.function("TRIM", str);
    }

    public ExpressionBuilder.Function repeat(ExpressionBuilder.Value str, ExpressionBuilder.Value size) {
        return this.function("REPEAT", str, size);
    }

    public ExpressionBuilder.Function replace(ExpressionBuilder.Value str, ExpressionBuilder.Value search, ExpressionBuilder.Value replstr) {
        return this.function("REPLACE", str, search, replstr);
    }

    public ExpressionBuilder.Function ascii(ExpressionBuilder.Value str) {
        return this.function("ASCII", str);
    }

    public ExpressionBuilder.Function lenght(ExpressionBuilder.Value str) {
        return this.function("LENGHT", str);
    }

    public ExpressionBuilder.Function instr(ExpressionBuilder.Value str, ExpressionBuilder.Value search, ExpressionBuilder.Value start) {
        return this.function("INSTR", str, search, start);
    }

    public ExpressionBuilder.Function lower(ExpressionBuilder.Value str) {
        return this.function("LOWER", str);
    }

    public ExpressionBuilder.Function upper(ExpressionBuilder.Value str) {
        return this.function("UPPER", str);
    }

    public ExpressionBuilder.Function space(ExpressionBuilder.Value size) {
        return this.function("SPACE", size);
    }

    public ExpressionBuilder.Function substring(ExpressionBuilder.Value str, ExpressionBuilder.Value start, ExpressionBuilder.Value len) {
        return this.function("SUBSTRING", str, start, len);
    }

    public ExpressionBuilder.Function acos(ExpressionBuilder.Value num) {
        return this.function("ACOS", num);
    }

    public ExpressionBuilder.Function asin(ExpressionBuilder.Value num) {
        return this.function("ASIN", num);
    }

    public ExpressionBuilder.Function atan(ExpressionBuilder.Value num) {
        return this.function("ATAN", num);
    }

    public ExpressionBuilder.Function cos(ExpressionBuilder.Value num) {
        return this.function("COS", num);
    }

    public ExpressionBuilder.Function cosh(ExpressionBuilder.Value num) {
        return this.function("COSH", num);
    }

    public ExpressionBuilder.Function cot(ExpressionBuilder.Value num) {
        return this.function("COT", num);
    }

    public ExpressionBuilder.Function bitand(ExpressionBuilder.Value num1, ExpressionBuilder.Value num2) {
        return this.function("BITAND", num1, num2);
    }

    public ExpressionBuilder.Function bitor(ExpressionBuilder.Value num1, ExpressionBuilder.Value num2) {
        return this.function("BITOR", num1, num2);
    }

    public ExpressionBuilder.Function bitxor(ExpressionBuilder.Value num1, ExpressionBuilder.Value num2) {
        return this.function("BITXOR", num1, num2);
    }

    public ExpressionBuilder.Function ceil(ExpressionBuilder.Value num) {
        return this.function("CEIL", num);
    }

    public ExpressionBuilder.Function degrees(ExpressionBuilder.Value num) {
        return this.function("DEGREES", num);
    }

    public ExpressionBuilder.Function exp(ExpressionBuilder.Value num) {
        return this.function("EXP", num);
    }

    public ExpressionBuilder.Function floor(ExpressionBuilder.Value num) {
        return this.function("FLOOR", num);
    }

    public ExpressionBuilder.Function log(ExpressionBuilder.Value num) {
        return this.function("LOG", num);
    }

    public ExpressionBuilder.Function log10(ExpressionBuilder.Value num) {
        return this.function("LOG10", num);
    }

    public ExpressionBuilder.Function pi() {
        return this.function("PI", new ExpressionBuilder.Value[0]);
    }

    public ExpressionBuilder.Function abs(ExpressionBuilder.Value num) {
        return this.function("ABS", num);
    }

    public ExpressionBuilder.Function power(ExpressionBuilder.Value num) {
        return this.function("POWER", num);
    }

    public ExpressionBuilder.Function radians(ExpressionBuilder.Value num) {
        return this.function("RADIANS", num);
    }

    public ExpressionBuilder.Function rand(ExpressionBuilder.Value num) {
        return this.function("RAND", num);
    }

    public ExpressionBuilder.Function round(ExpressionBuilder.Value num) {
        return this.function("ROUND", num);
    }

    public ExpressionBuilder.Function sqrt(ExpressionBuilder.Value num) {
        return this.function("SQRT", num);
    }

    public ExpressionBuilder.Function sign(ExpressionBuilder.Value num) {
        return this.function("SIGN", num);
    }

    public ExpressionBuilder.Function sin(ExpressionBuilder.Value num) {
        return this.function("SIN", num);
    }

    public ExpressionBuilder.Function sinh(ExpressionBuilder.Value num) {
        return this.function("SINH", num);
    }

    public ExpressionBuilder.Function tan(ExpressionBuilder.Value num) {
        return this.function("TAN", num);
    }

    public ExpressionBuilder.Function tanh(ExpressionBuilder.Value num) {
        return this.function("TANH", num);
    }

    public ExpressionBuilder.Function zero() {
        return this.function("ZERO", new ExpressionBuilder.Value[0]);
    }

    public ExpressionBuilder.Function chr(ExpressionBuilder.Value num) {
        return this.function("CHR", num);
    }

    public ExpressionBuilder.Function cast(ExpressionBuilder.Value object, ExpressionBuilder.Value typeName) {
        CastBase func = new CastBase();
        func.parameter(object);
        func.parameter(typeName);
        return func;
    }

    public ExpressionBuilder.Function cast(ExpressionBuilder.Value object, int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 19: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Type " + type + " not valid");
            }
        }
        DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
        String typeName = dataTypesManager.getTypeName(type);
        return this.cast(object, (ExpressionBuilder.Value)this.constant(typeName));
    }

    public ExpressionBuilder.Function decode(ExpressionBuilder.Value value, ExpressionBuilder.Value format) {
        return this.function("DECODE", value, format);
    }

    public ExpressionBuilder.Function toDouble(ExpressionBuilder.Value num) {
        return this.function("TODOUBLE", num);
    }

    public ExpressionBuilder.Function toFloat(ExpressionBuilder.Value num) {
        return this.function("TOFLOAT", num);
    }

    public ExpressionBuilder.Function toLong(ExpressionBuilder.Value num) {
        return this.function("TOLONG", num);
    }

    public ExpressionBuilder.Function toInteger(ExpressionBuilder.Value num) {
        return this.function("TOINTEGER", num);
    }

    public ExpressionBuilder.Function toStr(ExpressionBuilder.Value object) {
        return this.function("TOSTR", object);
    }

    public ExpressionBuilder.Function list() {
        return this.function("LIST", new ExpressionBuilder.Value[0]);
    }

    public ExpressionBuilder.Function tuple() {
        return this.function("TUPLE", new ExpressionBuilder.Value[0]);
    }

    public ExpressionBuilder.Function tuple(Object ... values) {
        ExpressionBuilder.Function fn = this.function("TUPLE", new ExpressionBuilder.Value[0]);
        for (Object theValue : values) {
            if (theValue instanceof ExpressionBuilder.Value) {
                fn.parameter((ExpressionBuilder.Value)theValue);
                continue;
            }
            fn.parameter((ExpressionBuilder.Value)this.constant(theValue));
        }
        return fn;
    }

    public String repr(Object value) {
        return this.manager.getReprMethod(value).repr(value);
    }

    public ExpressionBuilder.Function getattr(String objectId, String attributeId) {
        ExpressionBuilder.Function fn = this.function("GETATTR", new ExpressionBuilder.Value[0]);
        fn.parameter((ExpressionBuilder.Value)this.variable(objectId));
        fn.parameter((ExpressionBuilder.Value)this.variable(attributeId));
        return fn;
    }

    public ExpressionBuilder.Function date(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return this.function("DATE", new ExpressionBuilder.Value[]{this.constant(df.format(date))});
    }

    public ExpressionBuilder.Function time(Date time) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        return this.function("TIME", new ExpressionBuilder.Value[]{this.constant(df.format(time))});
    }

    public ExpressionBuilder.Function timestamp(Date timestamp) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return this.function("TIMESTAMP", new ExpressionBuilder.Value[]{this.constant(df.format(timestamp))});
    }

    public ExpressionBuilder.Function date(String date) {
        Date d;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            d = df.parse(date);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Can't parse argument '" + date + "' as date.", ex);
        }
        return this.function("DATE", new ExpressionBuilder.Value[]{this.constant(df.format(d))});
    }

    public ExpressionBuilder.Function time(String time) {
        Date t;
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        try {
            t = df.parse(time);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Can't parse argument '" + time + "' as date.", ex);
        }
        return this.function("TIME", new ExpressionBuilder.Value[]{this.constant(df.format(t))});
    }

    public ExpressionBuilder.Function timestamp(String timestamp) {
        Date ts;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            ts = df.parse(timestamp);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Can't parse argument '" + timestamp + "' as date.", ex);
        }
        return this.function("TIMESTAMP", new ExpressionBuilder.Value[]{this.constant(df.format(ts))});
    }

    public ExpressionBuilder.Function color(Color color) {
        return this.function("COLOR", new ExpressionBuilder.Value[]{this.constant(color.getRed()), this.constant(color.getGreen()), this.constant(color.getBlue()), this.constant(color.getAlpha())});
    }

    public ExpressionBuilder.Function color(ExpressionBuilder.Value red, ExpressionBuilder.Value green, ExpressionBuilder.Value blue, ExpressionBuilder.Value alfa) {
        return this.function("COLOR", red, green, blue, alfa);
    }

    public ExpressionBuilder.Function date(ExpressionBuilder.Value date) {
        return this.function("DATE", date);
    }

    public ExpressionBuilder.Function time(ExpressionBuilder.Value time) {
        return this.function("TIME", time);
    }

    public ExpressionBuilder.Function timestamp(ExpressionBuilder.Value timestamp) {
        return this.function("TIMESTAMP", timestamp);
    }

    public ExpressionBuilder.Function current_date() {
        return this.function("CURRENT_DATE", new ExpressionBuilder.Value[0]);
    }

    public ExpressionBuilder.Function current_time() {
        return this.function("CURRENT_TIME", new ExpressionBuilder.Value[0]);
    }

    public ExpressionBuilder.Function current_timestamp() {
        return this.function("CURRENT_TIMESTAMP", new ExpressionBuilder.Value[0]);
    }

    public ExpressionBuilder.Function date_add(ExpressionBuilder.Value datefield, ExpressionBuilder.Value valueToAdd, ExpressionBuilder.Value date) {
        return this.function("DATEADD", datefield, valueToAdd, date);
    }

    public ExpressionBuilder.Function let(String name, ExpressionBuilder.Value value) {
        return this.function("LET", new ExpressionBuilder.Value[]{this.variable(name), value});
    }

    public ExpressionBuilder.Function date_diff(ExpressionBuilder.Value datefield, ExpressionBuilder.Value valueToSubst, ExpressionBuilder.Value date) {
        return this.function("DATEDIFF", datefield, valueToSubst, date);
    }

    public ExpressionBuilder.Function to_date(ExpressionBuilder.Value date, ExpressionBuilder.Value format) {
        return this.function("TO_DATE", date, format);
    }

    public ExpressionBuilder.Function to_timestamp(ExpressionBuilder.Value timestamp, ExpressionBuilder.Value format) {
        return this.function("TO_TIMESTAMP", timestamp, format);
    }

    public ExpressionBuilder.Function extract(ExpressionBuilder.Value datefield, ExpressionBuilder.Value source) {
        return this.function("EXTRACT", datefield, source);
    }

    public ExpressionBuilder.Function hostexpression(ExpressionBuilder.Value expression) {
        return this.function("$HOSTEXPRESSION", expression);
    }

    public class BinaryOperatorBase
    extends FunctionBase
    implements ExpressionBuilder.BinaryOperator {
        private static final int LEFT = 0;
        private static final int RIGHT = 1;

        public BinaryOperatorBase(String name, String format) {
            super(name, format);
            this.parameters = new ArrayList();
            this.parameters.add(null);
            this.parameters.add(null);
        }

        @Override
        public ExpressionBuilder.Function parameter(ExpressionBuilder.Value parameter) {
            throw new UnsupportedOperationException("BinaryOperator can support add parameters.");
        }

        @Override
        public String name() {
            return this.name;
        }

        public ExpressionBuilder.BinaryOperator left(ExpressionBuilder.Value operand) {
            this.parameters.set(0, operand);
            return this;
        }

        public ExpressionBuilder.BinaryOperator right(ExpressionBuilder.Value operand) {
            this.parameters.set(1, operand);
            return this;
        }

        public ExpressionBuilder.Value left() {
            return (ExpressionBuilder.Value)this.parameters.get(0);
        }

        public ExpressionBuilder.Value right() {
            return (ExpressionBuilder.Value)this.parameters.get(1);
        }

        @Override
        public String toString() {
            return this.toString(DefaultExpressionBuilder.this.formatter());
        }

        @Override
        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            if (this.format == null) {
                StringBuilder builder = new StringBuilder();
                builder.append("(");
                builder.append(this.left().toString(formatter));
                builder.append(" ");
                builder.append(this.name);
                builder.append(" ");
                builder.append(this.right().toString(formatter));
                builder.append(")");
                return builder.toString();
            }
            return MessageFormat.format(this.format, this.left().toString(formatter), this.right().toString(formatter));
        }
    }

    public class MethodBase
    extends FunctionBase
    implements ExpressionBuilder.Method {
        private ExpressionBuilder.Value instance;

        public MethodBase(ExpressionBuilder.Value instance, String name) {
            super(name);
            this.instance = instance;
        }

        @Override
        public MethodBase clone() throws CloneNotSupportedException {
            MethodBase other = (MethodBase)super.clone();
            other.instance = this.instance.clone();
            return other;
        }

        public ExpressionBuilder.Value instance() {
            return this.instance;
        }

        @Override
        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren) {
                this.instance.accept(visitor, filter);
            }
        }

        @Override
        public void replace(ExpressionBuilder.Value target, ExpressionBuilder.Value replacement) {
            if (this.instance == target) {
                this.instance = replacement;
            } else {
                this.instance.replace(target, replacement);
            }
        }

        @Override
        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            builder.append(this.instance.toString(formatter));
            builder.append("->");
            builder.append(this.name());
            builder.append("(");
            if (this.parameters != null && !this.parameters.isEmpty()) {
                boolean first = true;
                for (ExpressionBuilder.Value argument : this.parameters) {
                    if (first) {
                        first = false;
                        builder.append(argument.toString(formatter));
                        continue;
                    }
                    builder.append(", ");
                    builder.append(argument.toString(formatter));
                }
            }
            builder.append(")");
            return builder.toString();
        }
    }

    public class CastBase
    extends FunctionBase {
        public CastBase() {
            super("CAST");
        }

        @Override
        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            builder.append(this.name);
            builder.append("(");
            builder.append(((ExpressionBuilder.Value)this.parameters.get(0)).toString(formatter));
            builder.append(" AS ");
            builder.append(((ExpressionBuilder.Constant)this.parameters.get(1)).value().toString());
            builder.append(")");
            return builder.toString();
        }
    }

    public class FunctionBase
    extends ExpressionBuilder.AbstractValue
    implements ExpressionBuilder.Function {
        protected String name;
        protected String format;
        protected List<ExpressionBuilder.Value> parameters;

        public FunctionBase(String name, String format) {
            this.name = name;
            this.format = format;
        }

        public FunctionBase clone() throws CloneNotSupportedException {
            FunctionBase other = (FunctionBase)super.clone();
            if (other.parameters != null) {
                for (int i = 0; i < this.parameters.size(); ++i) {
                    ExpressionBuilder.Value v = this.parameters.get(i).clone();
                    other.parameters.set(i, v);
                }
            }
            return other;
        }

        public FunctionBase(String name) {
            this(name, null);
        }

        public List<ExpressionBuilder.Value> parameters() {
            if (this.parameters == null) {
                this.parameters = new ArrayList<ExpressionBuilder.Value>();
            }
            return this.parameters;
        }

        public ExpressionBuilder.Function format(String format) {
            this.format = format;
            return this;
        }

        public ExpressionBuilder.Function parameter(ExpressionBuilder.Value parameter) {
            this.parameters().add(parameter);
            return this;
        }

        public String name() {
            return this.name;
        }

        public String name(String name) {
            this.name = name;
            return this.name;
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren && this.parameters != null) {
                for (ExpressionBuilder.Value argument : this.parameters) {
                    if (argument == null) continue;
                    argument.accept(visitor, filter);
                }
            }
        }

        public void replace(ExpressionBuilder.Value target, ExpressionBuilder.Value replacement) {
            if (this.parameters != null) {
                for (int i = 0; i < this.parameters.size(); ++i) {
                    ExpressionBuilder.Value argument = this.parameters.get(i);
                    if (argument == null) continue;
                    if (argument == target) {
                        this.parameters.set(i, replacement);
                        continue;
                    }
                    argument.replace(target, replacement);
                }
            }
        }

        public String toString() {
            return this.toString(DefaultExpressionBuilder.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            if (this.format == null) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.name);
                builder.append("(");
                if (this.parameters != null && !this.parameters.isEmpty()) {
                    boolean first = true;
                    for (ExpressionBuilder.Value argument : this.parameters) {
                        if (first) {
                            first = false;
                            builder.append(argument.toString(formatter));
                            continue;
                        }
                        builder.append(", ");
                        builder.append(argument.toString(formatter));
                    }
                }
                builder.append(")");
                return builder.toString();
            }
            if (this.parameters != null && !this.parameters.isEmpty()) {
                ArrayList<String> values = new ArrayList<String>();
                for (ExpressionBuilder.Value argument : this.parameters) {
                    values.add(argument.toString(formatter));
                }
                return MessageFormat.format(this.format, values.toArray());
            }
            return this.format;
        }
    }

    public class CustomBase
    extends ExpressionBuilder.AbstractValue
    implements ExpressionBuilder.Custom {
        protected Object value;
        protected List<ExpressionBuilder.Value> values;

        public CustomBase(Object value) {
            this.value = value;
        }

        public ExpressionBuilder.Custom clone() throws CloneNotSupportedException {
            CustomBase other = (CustomBase)super.clone();
            if (other.values != null) {
                for (int i = 0; i < this.values.size(); ++i) {
                    ExpressionBuilder.Value v = this.values.get(i).clone();
                    other.values.set(i, v);
                }
            }
            return other;
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren && this.values != null) {
                for (ExpressionBuilder.Value theValue : this.values) {
                    theValue.accept(visitor, filter);
                }
            }
        }

        public void replace(ExpressionBuilder.Value target, ExpressionBuilder.Value replacement) {
            if (this.values == null) {
                return;
            }
            for (int i = 0; i < this.values.size(); ++i) {
                ExpressionBuilder.Value theValue = this.values.get(i);
                if (target == theValue) {
                    this.values.set(i, replacement);
                    continue;
                }
                theValue.replace(target, replacement);
            }
        }

        public Object value() {
            return this.value;
        }

        public ExpressionBuilder.Custom add(ExpressionBuilder.Variable variable) {
            if (this.values == null) {
                this.values = new ArrayList<ExpressionBuilder.Value>();
            }
            this.values.add((ExpressionBuilder.Value)variable);
            return this;
        }

        public ExpressionBuilder.Custom add(ExpressionBuilder.Parameter parameter) {
            if (this.values == null) {
                this.values = new ArrayList<ExpressionBuilder.Value>();
            }
            this.values.add((ExpressionBuilder.Value)parameter);
            return this;
        }

        public String toString() {
            return this.toString(DefaultExpressionBuilder.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            return Objects.toString(this.value, "");
        }
    }

    public class ConstantBase
    extends ExpressionBuilder.AbstractValue
    implements ExpressionBuilder.Constant {
        protected Object value;
        protected ExpressionBuilder builder;

        public ConstantBase(ExpressionBuilder builder, Object value) {
            this.value = value;
            this.builder = builder;
        }

        public ExpressionBuilder.Constant clone() throws CloneNotSupportedException {
            ConstantBase other = (ConstantBase)super.clone();
            return other;
        }

        public Object value() {
            return this.value;
        }

        public String toString() {
            return this.toString(DefaultExpressionBuilder.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            if (this.value == null) {
                return "NULL";
            }
            if (this.value instanceof byte[]) {
                return "DECODE('" + this.builder.bytearray_hex((byte[])this.value) + "','hex')";
            }
            if (this.value instanceof String) {
                return this.builder.string((String)this.value);
            }
            if (this.value instanceof Boolean) {
                if (((Boolean)this.value).booleanValue()) {
                    return DefaultExpressionBuilder.FORMAT_TRUE;
                }
                return DefaultExpressionBuilder.FORMAT_FALSE;
            }
            ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
            ReprMethod repr = manager.getReprMethod(this.value);
            return repr.repr(this.value);
        }

        public ExpressionBuilder builder() {
            return this.builder;
        }
    }

    public class ParameterBase
    extends ExpressionBuilder.AbstractValue
    implements ExpressionBuilder.Parameter {
        protected String name = null;
        protected Object value = null;
        protected int type = 0;

        public ParameterBase clone() throws CloneNotSupportedException {
            ParameterBase other = (ParameterBase)super.clone();
            return other;
        }

        public ExpressionBuilder.Parameter as_constant() {
            this.type = 0;
            if (this.value == null && this.name != null) {
                this.value = this.name;
            }
            return this;
        }

        public ExpressionBuilder.Parameter as_variable() {
            this.type = 1;
            if (this.value != null && this.name == null) {
                this.name = (String)this.value;
            }
            return this;
        }

        public String name() {
            switch (this.type) {
                case 1: {
                    return this.name;
                }
                case 0: {
                    if (this.value == null) {
                        return null;
                    }
                    return this.value.toString();
                }
            }
            if (this.name != null) {
                return this.name;
            }
            if (this.value != null) {
                return this.value.toString();
            }
            return null;
        }

        public int type() {
            return this.type;
        }

        public boolean is_constant() {
            return this.type == 0;
        }

        public boolean is_variable() {
            return this.type == 1;
        }

        public ExpressionBuilder.Parameter value(Object value) {
            this.value = value;
            return this;
        }

        public ExpressionBuilder.Parameter name(String name) {
            this.type = 1;
            this.name = name;
            return this;
        }

        public Object value() {
            try {
                switch (this.type) {
                    case 0: {
                        return this.value;
                    }
                }
                return this.value;
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't get value from parameter.", ex);
            }
        }

        public String toString() {
            return this.toString(DefaultExpressionBuilder.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            switch (this.type) {
                case 0: {
                    return Objects.toString(this.value);
                }
            }
            return "?";
        }
    }

    public class VariableBase
    extends ExpressionBuilder.AbstractValue
    implements ExpressionBuilder.Variable {
        protected String name;
        protected ExpressionBuilder builder;

        public VariableBase(ExpressionBuilder builder, String name) {
            if (StringUtils.contains((CharSequence)name, (int)34)) {
                throw new IllegalArgumentException("The name of a variable should not contain double quotes.");
            }
            this.name = name;
            this.builder = builder;
        }

        public VariableBase clone() throws CloneNotSupportedException {
            VariableBase other = (VariableBase)super.clone();
            return other;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.toString(DefaultExpressionBuilder.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            return this.builder.identifier(this.name);
        }

        public int compareTo(ExpressionBuilder.Variable o) {
            return this.name.compareTo(o.name());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExpressionBuilder.Variable)) {
                return false;
            }
            return this.name.equals(((ExpressionBuilder.Variable)obj).name());
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + Objects.hashCode(this.name);
            return hash;
        }
    }

    public class GroupBase
    extends ExpressionBuilder.AbstractValue
    implements ExpressionBuilder.Group {
        protected ExpressionBuilder.Value value;

        public GroupBase(ExpressionBuilder.Value value) {
            this.value = value;
        }

        public GroupBase clone() throws CloneNotSupportedException {
            GroupBase other = (GroupBase)super.clone();
            other.value = this.value.clone();
            return other;
        }

        public ExpressionBuilder.Value value() {
            return this.value;
        }

        public void accept(ExpressionBuilder.Visitor visitor, ExpressionBuilder.VisitorFilter filter) {
            boolean visitChildren = true;
            if (filter == null || filter.accept((ExpressionBuilder.Visitable)this)) {
                visitor.visit((ExpressionBuilder.Visitable)this);
            } else {
                boolean bl = visitChildren = !filter.skipChildren();
            }
            if (visitChildren) {
                this.value.accept(visitor, filter);
            }
        }

        public void replace(ExpressionBuilder.Value target, ExpressionBuilder.Value replacement) {
            if (this.value == target) {
                this.value = replacement;
            } else {
                this.value.replace(target, replacement);
            }
        }

        public String toString() {
            return this.toString(DefaultExpressionBuilder.this.formatter());
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            return MessageFormat.format(DefaultExpressionBuilder.FORMAT_GROUP, this.value.toString(formatter));
        }
    }
}

