/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.image;

import java.awt.geom.AffineTransform;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;

public class ImageTransformFunction
extends AbstractFunction {
    public ImageTransformFunction() {
        super("Image", "IMAGETRANSFORM", Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(4)), "", "IMAGETRANSFORM({{image}})", new String[]{"image", "transform", "width - Optional.", "height - Optional."}, "SimpleImage", false);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        Object source = this.getObject(args, 0);
        AffineTransform transform = (AffineTransform)this.getObject(args, 1);
        SimpleImage image = ToolsSwingLocator.getToolsSwingManager().createSimpleImage(source);
        if (image.isEmpty()) {
            return null;
        }
        switch (args.length) {
            case 2: {
                image = image.transform(transform);
                break;
            }
            case 4: {
                int width = this.getInt(args, 2);
                int height = this.getInt(args, 3);
                image = image.transform(transform, width, height);
                break;
            }
            default: {
                throw new ExpressionRuntimeException(null, "Incorrect number of arguments", "The IMAGETRANSFORM function has 2 arguments, image and transform, or 4 arguments, image, transform, width and height.");
            }
        }
        return image;
    }
}

