/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.numeric;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class BitGetFunction
extends AbstractFunction {
    public BitGetFunction() {
        super("Numeric", "BITGET", Range.is((Comparable)Integer.valueOf(2)), "Returns true if and only if the first parameter has a bit set in the position specified by the second parameter. This method returns a boolean. The second parameter is zero-indexed; the least significant bit has position 0", "BITGET({{bits}}, nbit)", new String[]{"bits - a bit set", "nbit - bit to check"}, "Boolean", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        Object value = args[0];
        int bit = this.getInt(args, 1);
        if (value instanceof Integer) {
            int mask = 1 << bit;
            boolean r = (((Number)value).intValue() & mask) == mask;
            return r;
        }
        if (value instanceof Number) {
            int mask = 1 << bit;
            boolean r = (((Number)value).longValue() & (long)mask) == (long)mask;
            return r;
        }
        throw new IllegalArgumentException("Types not allowed in '" + this.name() + "' function.");
    }
}

