/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.PrettyFormatter;
import org.gvsig.expressionevaluator.impl.DefaultInterpreter;
import org.gvsig.expressionevaluator.impl.HostExpressionUtils;
import org.gvsig.expressionevaluator.impl.function.programming.BreakFunction;
import org.gvsig.expressionevaluator.impl.function.programming.ReturnFunction;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class CodeBlockFunction
extends AbstractFunction {
    public static final String NAME = "BLOCK";

    public CodeBlockFunction() {
        super("Programming", NAME, Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), "Evaluate each of the arguments sequentially.", "BEGIN\n  {{sentence}};\nEXCEPT\n  PASS\nEND\n", null, "Object", false);
    }

    public boolean isHidden() {
        return true;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        Object value = null;
        int argn = 0;
        for (Code statement : args) {
            try {
                statement = HostExpressionUtils.resolveHostExpressions(statement, interpreter);
                value = ((DefaultInterpreter)interpreter).runCode(statement);
            }
            catch (BreakFunction.BreakException | ReturnFunction.ReturnException ex) {
                throw ex;
            }
            catch (Exception ex) {
                String stmt = "unknown";
                try {
                    stmt = Objects.toString(statement);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOGGER.debug("Error in block function calling arg " + argn + ", " + stmt, (Throwable)ex);
                throw ex;
            }
            ++argn;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Codes args, Formatter<Code> formatter) {
        PrettyFormatter builder = PrettyFormatter.get(formatter);
        try {
            builder.push();
            builder.append((Object)"BEGIN ");
            builder.indent();
            for (Code statement : args) {
                builder.nl();
                builder.append((Object)statement.toString(formatter));
                builder.append((Object)"; ");
            }
            builder.unindent();
            builder.nl();
            builder.append((Object)"END ");
            String string = builder.build();
            return string;
        }
        finally {
            builder.pop();
        }
    }
}

