/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.image.ImageFromHTMLFunction;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateHtmlPanelFunction
extends AbstractFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateHtmlPanelFunction.class);

    public CreateHtmlPanelFunction() {
        super("Programming", "CREATE_HTMLPANEL", Range.is((Comparable)Integer.valueOf(1)), null, "CREATE_HTMLPANEL({{with}}, height, source)", new String[]{"width - with of the image in pixels", "height - height of the image in pixels", "source - HTML source or URL"}, "JPanel", false);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        int width = this.getInt(args, 0);
        int height = this.getInt(args, 1);
        String source = this.getStr(args, 2);
        URL url = null;
        try {
            url = new URL(source);
        }
        catch (Exception ex) {
            LOGGER.debug("Can't parse url", (Throwable)ex);
        }
        BufferedImage img = ImageFromHTMLFunction.createImageFromHTML(width, height, url, source);
        if (img == null) {
            return null;
        }
        JLabel comp = new JLabel(new ImageIcon(img));
        comp.setPreferredSize(new Dimension(width, height));
        comp.setSize(new Dimension(width, height));
        comp.setOpaque(false);
        return comp;
    }
}

