/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.json.JsonObject;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.AttributeHandler;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.expressionevaluator.spi.JsonUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.util.GetItemByKey;
import org.gvsig.tools.util.PropertiesSupport;

public class GetattrFunction
extends AbstractFunction {
    public GetattrFunction() {
        super("Programming", "GETATTR", Range.is((Comparable)Integer.valueOf(2)), null, "GETATTR({{object}}, attribute_name_as_string)", null, null, true);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Object value;
        Object obj = this.getObject(args, 0);
        String attrname = this.getStr(args, 1);
        if (StringUtils.isBlank((CharSequence)attrname)) {
            throw new NullPointerException("A attribute name was expected and a null was received");
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof DynObject && ((DynObject)obj).hasDynValue(attrname)) {
            value = ((DynObject)obj).getDynValue(attrname);
        } else if (obj instanceof AttributeHandler) {
            value = ((AttributeHandler)obj).get((Object)attrname);
        } else if (obj instanceof GetItemByKey) {
            value = ((GetItemByKey)obj).get((Object)attrname);
        } else {
            Field field = this.getField(obj, attrname);
            if (field != null) {
                value = field.get(obj);
            } else {
                Method method = this.getMethod(obj, "get" + StringUtils.capitalize((String)attrname));
                if (method != null) {
                    value = method.invoke(obj, new Object[0]);
                } else if (obj instanceof PropertiesSupport) {
                    value = ((PropertiesSupport)obj).getProperty(attrname);
                } else if (obj instanceof JsonObject) {
                    JsonObject jsonobj = (JsonObject)obj;
                    value = JsonUtils.getitem((JsonObject)jsonobj, (String)attrname);
                } else if (obj instanceof Map) {
                    value = ((Map)obj).get(attrname);
                } else {
                    throw new NoSuchFieldException(attrname);
                }
            }
        }
        return value;
    }

    public String toString(Codes args, Formatter<Code> formatter) {
        StringBuilder builder = new StringBuilder();
        Code arg0 = (Code)args.get(0);
        Code arg1 = (Code)args.get(1);
        if (arg0 instanceof Code.Identifier && arg1 instanceof Code.Constant && ((Code.Constant)arg1).value() instanceof CharSequence) {
            builder.append(arg0.toString(formatter));
            builder.append(".\"");
            builder.append(((Code.Constant)arg1).value().toString());
            builder.append("\"");
        } else {
            builder.append(this.name());
            builder.append("(");
            builder.append(arg0.toString(formatter));
            builder.append(", ");
            builder.append(arg1.toString(formatter));
            builder.append(")");
        }
        return builder.toString();
    }

    private Field getField(Object obj, String attrname) {
        Class<?> theClass = obj.getClass();
        try {
            Field field = theClass.getField(attrname);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private Method getMethod(Object obj, String methodname) {
        Class<?> theClass = obj.getClass();
        try {
            Method method = theClass.getMethod(methodname, new Class[0]);
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public ExpressionBuilder.Value toValue(ExpressionBuilder builder, Codes parameters) {
        Code arg0 = (Code)parameters.get(0);
        Code arg1 = (Code)parameters.get(1);
        if (arg0 instanceof Code.Identifier && arg1 instanceof Code.Constant && ((Code.Constant)arg1).value() instanceof CharSequence) {
            return builder.getattr(((Code.Identifier)arg0).name(), ((Code.Constant)arg1).value().toString());
        }
        return builder.function("GETATTR", new ExpressionBuilder.Value[]{arg0.toValue(), arg1.toValue()});
    }
}

