/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.util.PropertiesSupport;
import org.gvsig.tools.util.SetItem;

public class SetattrFunction
extends AbstractFunction {
    public SetattrFunction() {
        super("Programming", "SETATTR", Range.is((Comparable)Integer.valueOf(3)), null, "SETATTR({{object}}, attribute_name_as_string, value)", null, null, false);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        String nameobj = this.getStr(args, 0);
        String attrname = this.getStr(args, 1);
        Object value = this.getObject(args, 2);
        if (StringUtils.isBlank((CharSequence)attrname)) {
            throw new NullPointerException("A attribute name was expected and a null was received");
        }
        if (nameobj == null) {
            return null;
        }
        Object obj = interpreter.getSymbolTable().value(nameobj);
        if (obj instanceof DynObject && ((DynObject)obj).hasDynValue(attrname)) {
            ((DynObject)obj).setDynValue(attrname, value);
        } else if (obj instanceof SetItem) {
            ((SetItem)obj).set((Object)attrname, value);
        } else {
            Field field = this.getField(obj, attrname);
            if (field != null) {
                field.set(obj, value);
            } else {
                Method method = this.getMethod(obj, "set" + StringUtils.capitalize((String)attrname), value.getClass());
                if (method != null) {
                    value = method.invoke(obj, value);
                } else if (obj instanceof SetItem) {
                    ((SetItem)obj).set((Object)attrname, value);
                } else if (obj instanceof PropertiesSupport) {
                    ((PropertiesSupport)obj).setProperty(attrname, value);
                } else if (obj instanceof Map) {
                    ((Map)obj).put(attrname, value);
                } else {
                    throw new NoSuchFieldException(attrname);
                }
            }
        }
        return value;
    }

    private Field getField(Object obj, String attrname) {
        Class<?> theClass = obj.getClass();
        try {
            Field field = theClass.getField(attrname);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private Method getMethod(Object obj, String methodname, Class<?> ... paramTypes) {
        Class<?> theClass = obj.getClass();
        try {
            Method method = theClass.getMethod(methodname, paramTypes);
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

