/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.typeconversion;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;

public class CastFunction
extends AbstractFunction {
    public CastFunction() {
        super("Conversion", "CAST", Range.is((Comparable)Integer.valueOf(2)), "", "CAST( {{value}} AS type_identifier)", null, null, true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        DataTypesManager manager = ToolsLocator.getDataTypesManager();
        Object valueIn = this.getObject(args, 0);
        String typeName = this.getStr(args, 1);
        int type = manager.getType(typeName);
        if (type == 0) {
            throw new ExpressionRuntimeException("The value of type (" + typeName + ") in function CAST is incorrect", this.getTip());
        }
        Coercion converter = manager.get(type).getCoercion();
        if (converter == null) {
            throw new IllegalArgumentException("Can't convert to the indicated type (" + typeName + ").");
        }
        Object valueOut = converter.coerce(valueIn);
        return valueOut;
    }

    private String getTip() {
        DataTypesManager manager = ToolsLocator.getDataTypesManager();
        StringBuilder builder = new StringBuilder();
        for (DataType dataType : manager) {
            builder.append("- ");
            builder.append(dataType.getName());
            builder.append("\n");
        }
        return "The valid type names for the function CAST are:\n" + builder.toString();
    }

    public String toString(Codes args, Formatter<Code> formatter) {
        StringBuilder builder = new StringBuilder();
        Code expression = (Code)args.get(0);
        Code typeName = (Code)args.get(1);
        if (typeName instanceof Code.Constant && ((Code.Constant)typeName).value() instanceof CharSequence) {
            builder.append(this.name());
            builder.append("(");
            builder.append(expression.toString(formatter));
            builder.append(" AS ");
            builder.append(((Code.Constant)typeName).value().toString());
            builder.append(")");
            return builder.toString();
        }
        return super.toString(args, formatter);
    }
}

