/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.javascripting;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.impl.javascripting.CosaCompiledScript;
import org.gvsig.expressionevaluator.impl.javascripting.SymbolTableToBindingsAdapter;

public class CosaScriptEngine
extends AbstractScriptEngine
implements ScriptEngine,
Compilable,
Invocable {
    private final ScriptEngineFactory factory;
    private final MutableSymbolTable symbolTable;
    private final Interpreter interpreter;
    private final ExpressionEvaluatorManager manager;

    public CosaScriptEngine(ScriptEngineFactory factory) {
        this.factory = factory;
        this.manager = ExpressionEvaluatorLocator.getManager();
        this.symbolTable = this.manager.createSymbolTable();
        this.interpreter = this.manager.createInterpreter();
        this.interpreter.setSymbolTable((SymbolTable)this.symbolTable);
        this.context = new MyContextScript();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Object eval(String source, ScriptContext context) throws ScriptException {
        CompiledScript script = this.compile(source);
        Object x = script.eval(context);
        return x;
    }

    @Override
    public Object eval(Reader source, ScriptContext context) throws ScriptException {
        CompiledScript script = this.compile(source);
        Object x = script.eval(context);
        return x;
    }

    @Override
    public Bindings createBindings() {
        return new SymbolTableToBindingsAdapter(this.symbolTable);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        Code code = this.manager.compile(script);
        CosaCompiledScript x = new CosaCompiledScript(this, code);
        return x;
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        List lines;
        try {
            lines = IOUtils.readLines((Reader)script);
        }
        catch (IOException ex) {
            throw new ScriptException(ex);
        }
        String source = StringUtils.join((Iterable)lines, (String)"\n");
        return this.compile(source);
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (!this.interpreter.hasFunction(name)) {
            throw new NoSuchMethodException(name);
        }
        try {
            return this.interpreter.call(name, args);
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException(this.interpreter.getCurrentCode(), "Error calling funcion '" + name + "'.", (Throwable)ex);
        }
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        return null;
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        return null;
    }

    private class MyContextScript
    extends SimpleScriptContext {
        public MyContextScript() {
            this.engineScope = new SymbolTableToBindingsAdapter(CosaScriptEngine.this.symbolTable);
        }

        @Override
        public void setWriter(Writer writer) {
            super.setWriter(writer);
            CosaScriptEngine.this.interpreter.setWriter(writer);
        }

        @Override
        public void setErrorWriter(Writer writer) {
            super.setErrorWriter(writer);
        }
    }
}

