/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.javascripting;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.gvsig.expressionevaluator.impl.javascripting.CosaScriptEngine;

public class CosaScriptEngineFactory
implements ScriptEngineFactory {
    public static final String ENGINE_NAME = "Cosa";
    public static final String ENGINE_VERSION = "1.0.0";
    public static final String LANGUAGE_NAME = "cosa";
    public static final String LANGUAGE_VERSION = "1.0";
    public static final String[] NAMES = new String[]{"Cosa", "COSA", "cosa"};
    public static final String[] FILE_EXTENSIONS = new String[]{"cosa"};
    public static final String[] MIME_TYPES = new String[]{"text/cosa", "application/cosa", "text/x-cosa", "application/x-cosa"};

    @Override
    public String getEngineName() {
        return ENGINE_NAME;
    }

    @Override
    public String getEngineVersion() {
        return ENGINE_VERSION;
    }

    @Override
    public List<String> getExtensions() {
        return Collections.unmodifiableList(Arrays.asList(FILE_EXTENSIONS));
    }

    @Override
    public String getLanguageName() {
        return LANGUAGE_NAME;
    }

    @Override
    public String getLanguageVersion() {
        return LANGUAGE_VERSION;
    }

    @Override
    public Object getParameter(String key) {
        switch (key) {
            case "javax.script.engine": {
                return this.getEngineName();
            }
            case "javax.script.engine_version": {
                return this.getEngineVersion();
            }
            case "javax.script.name": {
                return this.getEngineName();
            }
            case "javax.script.language": {
                return this.getLanguageName();
            }
            case "javax.script.language_version": {
                return this.getLanguageVersion();
            }
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.format("%s.%s(", obj, m));
        int i = args.length;
        for (String arg : args) {
            buffer.append(arg);
            if (i-- <= 0) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuilder buffer = new StringBuilder(toDisplay.length() + 8);
        buffer.append("print('");
        buffer.append(toDisplay.replace("'", "''"));
        buffer.append("')");
        return buffer.toString();
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder buffer = new StringBuilder();
        for (String statement : statements) {
            buffer.append(statement);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new CosaScriptEngine(this);
    }

    @Override
    public List<String> getMimeTypes() {
        return Collections.unmodifiableList(Arrays.asList(MIME_TYPES));
    }

    @Override
    public List<String> getNames() {
        return Collections.unmodifiableList(Arrays.asList(NAMES));
    }
}

