/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.persist.cache.AbstractBaseCache;
import org.exolab.castor.persist.cache.Cache;
import org.exolab.castor.persist.cache.CacheType;
import org.exolab.castor.persist.cache.CountLimited;
import org.exolab.castor.persist.cache.InvalidCacheTypeException;
import org.exolab.castor.persist.cache.NoCache;
import org.exolab.castor.persist.cache.TimeLimited;
import org.exolab.castor.persist.cache.Unlimited;

public class CacheFactory {
    public static final String DEFAULT_TYPE_IDENTIFIER = "count-limited";
    public static final CacheType DEFAULT_TYPE = CacheType.CACHE_COUNT_LIMITED;
    public static final int DEFAULT_PARAM = 100;
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$persist$cache$CacheFactory == null ? (class$org$exolab$castor$persist$cache$CacheFactory = CacheFactory.class$("org.exolab.castor.persist.cache.CacheFactory")) : class$org$exolab$castor$persist$cache$CacheFactory);
    static /* synthetic */ Class class$org$exolab$castor$persist$cache$CacheFactory;

    public static Cache create(String type, int param) throws InvalidCacheTypeException {
        AbstractBaseCache cache = null;
        CacheType cacheType = null;
        if (type == null) {
            type = DEFAULT_TYPE_IDENTIFIER;
        }
        try {
            cacheType = CacheType.create(type);
        }
        catch (InvalidCacheTypeException e) {
            _log.error((Object)"Invalid cache type encountered", (Throwable)e);
            throw e;
        }
        if (cacheType == DEFAULT_TYPE) {
            param = 100;
        }
        if (cacheType == CacheType.CACHE_COUNT_LIMITED) {
            cache = param > 0 ? new CountLimited(param) : new NoCache();
        } else if (cacheType == CacheType.CACHE_TIME_LIMITED) {
            cache = param > 0 ? new TimeLimited(param) : new NoCache();
        } else if (cacheType == CacheType.CACHE_UNLIMITED) {
            cache = new Unlimited();
        } else if (cacheType == CacheType.CACHE_NONE) {
            cache = new NoCache();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Creating cache instance for type " + cacheType.toString()));
        }
        cache.setCacheType(cacheType);
        return cache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

