/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.functions;

import java.sql.Connection;
import java.sql.SQLException;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.sqlite.dal.functions.Functions;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryBuilder;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.sqlite.SQLiteConnection;

public class ST_GeomFromWKB
extends Functions.AbstractFunction {
    public ST_GeomFromWKB(SQLiteConnection conn) {
        super("ST_GeomFromWKB", conn);
    }

    protected void xFunc() throws SQLException {
        try {
            byte[] wkb = this.value_blob(0);
            if (wkb == null) {
                this.result();
                return;
            }
            int srs_id = this.value_int(1);
            IProjection proj = GeopackageUtils.getProjection((Connection)this.getConnection(), srs_id);
            GeometryManager geommanager = GeometryLocator.getGeometryManager();
            Geometry geom1 = geommanager.createFrom(wkb, proj);
            GeopackageGeometryBuilder builder = GeopackageUtils.createGeometryBuilder();
            builder.setGeometry(this.getConnection(), geom1);
            byte[] bytes = builder.build();
            this.result(bytes);
        }
        catch (Throwable ex) {
            throw new SQLException("Can't get geometry bytes from wkb+srs_id", ex);
        }
    }
}

