/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.impl.panels;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.ExportAttributes;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.impl.panels.SelectAttributesPanelView;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.namestranslator.NamesTranslator;
import org.gvsig.tools.swing.api.FilteredTableModel;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.MessageBarController;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectAttributesPanel
extends SelectAttributesPanelView
implements ExportPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectAttributesPanel.class);
    private static final int COLUMN_FIELD_EXPORT = 0;
    private static final int COLUMN_FIELD_TYPE = 1;
    private static final int COLUMN_FIELD_SIZE = 2;
    private static final int COLUMN_FIELD_ORIGIN = 3;
    private static final int COLUMN_FIELD_CALCULATED = 4;
    private static final int COLUMN_FIELD_NAME = 5;
    private static final int COLUMN_FIELD_NEW_NAME = 6;
    private static final int COLUMN_FIELD_COUNT = 7;
    private static final int ORIGIN_REAL = 0;
    private static final int ORIGIN_QUERY_CALCULATED = 1;
    private static final int ORIGIN_TABLE_CALCULATED = 2;
    private MessageBarController messageController;
    private final ExportParameters parameters;
    private final JExportProcessPanel processPanel;
    private TableModel tableModel;
    private TableFilterController tableFilterController;
    private FeatureType targetFeatureType;

    public SelectAttributesPanel(JExportProcessPanel processPanel, ExportParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = parameters;
        this.parameters.getExportAttributes().setActive(true);
        this.initComponents();
    }

    public String getIdPanel() {
        return "PANEL_ATTRIBUTES_SELECTION";
    }

    public String getTitlePanel() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Attribute_Selection");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        ExportAttributes attributes = this.parameters.getExportAttributes();
        FeatureType theTargetFeatureType = attributes.getTargetFeatureType();
        boolean areComputed = false;
        for (FeatureAttributeDescriptor featureAttributeDescriptor : theTargetFeatureType) {
            if (!featureAttributeDescriptor.isComputed()) continue;
            areComputed = true;
            break;
        }
        if (areComputed) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            int r = dialogs.confirmDialog(i18n.getTranslation("_Virtual_attribute_have_been_selected_it_is_very_possible_that_the_result_can_only_be_opened_by_gvSIG") + "\n" + i18n.getTranslation("_do_you_wish_to_continue"), i18n.getTranslation("_Attributes_selection"), 0, 2, "_export_wizard_virtual_attributes_selection");
            if (r != 0) {
                return false;
            }
        }
        return true;
    }

    public void enterPanel() {
        this.fillTableWithAttributes();
    }

    public void previousPanel() {
        this.fillTableWithAttributes();
    }

    public void nextPanel() {
    }

    public JComponent asJComponent() {
        return this;
    }

    private boolean isOriginalType(int row, String type) {
        try {
            if (this.targetFeatureType == null) {
                return true;
            }
            TableModel model = this.tblAttributes.getModel();
            String name = (String)model.getValueAt(row, 5);
            FeatureAttributeDescriptor attr = this.targetFeatureType.getAttributeDescriptor(name);
            if (attr == null) {
                return true;
            }
            return StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)attr.getDataTypeName());
        }
        catch (Exception ex) {
            return true;
        }
    }

    private ExportAttributes getExportAttributes() {
        ExportAttributes attributes = this.parameters.getExportAttributes();
        return attributes;
    }

    private void fillTableWithAttributes() {
        ExportAttributes attributes = this.getExportAttributes();
        if (this.targetFeatureType == null) {
            this.targetFeatureType = this.getExportAttributes().getTargetFeatureType();
        }
        this.tableModel = new AttributesTableModel(attributes, this);
        this.tblAttributes.setModel(this.tableModel);
        this.tableFilterController.setModel(this.tableModel);
        TableColumnModel columnModel = this.tblAttributes.getColumnModel();
        columnModel.getColumn(3).setCellRenderer(new OriginCellRenderer());
        columnModel.getColumn(1).setCellEditor(new DataTypeCellEditor());
        columnModel.getColumn(1).setCellRenderer(new DataTypeCellRenderer());
        columnModel.getColumn(0).setPreferredWidth(new JCheckBox().getPreferredSize().width * 2);
        columnModel.getColumn(1).setPreferredWidth(new JLabel((String)"XIntegerX").getPreferredSize().width);
        columnModel.getColumn(2).setPreferredWidth(new JLabel((String)"00000").getPreferredSize().width);
        columnModel.getColumn(3).setPreferredWidth(new JLabel((String)"000").getPreferredSize().width);
        columnModel.getColumn(4).setPreferredWidth(new JLabel((String)"000").getPreferredSize().width);
    }

    private void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.tblAttributes.getTableHeader().setToolTipText(i18n.getTranslation("_Select_in_the_check_box_wich_fields_wanted_to_be_exported_and_configure_its_attributes"));
        this.messageController = ToolsSwingLocator.getToolsSwingManager().createMessageBarController(this.lblMessage, 10000);
        this.tblAttributes.setAutoCreateRowSorter(true);
        this.tblAttributes.setAutoResizeMode(3);
        this.lblHeader.setText("<HTML>" + i18n.getTranslation("_Check_wich_fields_you_want_to_export_and_configure_its_attributes") + ". " + i18n.getTranslation("_Select_the_name_of_the_new_field_size_and_type_that_each_field_will_have_in_the_export_result") + ".</HTML>");
        this.tableFilterController = new TableFilterController(this.tblAttributes, this.txtFilter, this.btnFilter, 5);
        this.btnCheckAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectAttributesPanel.this.doCheckAll();
            }
        });
        this.btnUncheckAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectAttributesPanel.this.doUncheckAll();
            }
        });
        this.translate();
    }

    private void doUncheckAll() {
        TableModel model = this.tblAttributes.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            model.setValueAt(false, row, 0);
        }
    }

    private void doCheckAll() {
        TableModel model = this.tblAttributes.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            model.setValueAt(true, row, 0);
        }
    }

    private void translate() {
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        manager.translate(this.lblHeader);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        URL url = this.getClass().getResource(name + ".png");
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    private void setMessage(String toString) {
        this.messageController.setText(toString);
    }

    private class DataTypeCellEditor
    extends DefaultCellEditor {
        private int currentRow;

        public DataTypeCellEditor() {
            super(new JComboBox());
            this.currentRow = -1;
            JComboBox combo = (JComboBox)this.getComponent();
            combo.setRenderer(new DataTypeListCellRenderer());
            combo.setModel(this.getDataTypeComboModel());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentRow = row;
            JComboBox combo = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            ListElement.setSelected((JComboBox)combo, (Object)value);
            return combo;
        }

        private DefaultComboBoxModel getDataTypeComboModel() {
            DataTypesManager dataManager = ToolsLocator.getDataTypesManager();
            ArrayList<Object> fieldTypes = new ArrayList<Object>();
            for (DataType dataType : dataManager) {
                fieldTypes.add(new ListElement(dataType.getName(), (Object)dataType.getType()));
            }
            fieldTypes.sort(new Comparator<ListElement<Integer>>(){

                @Override
                public int compare(ListElement<Integer> o1, ListElement<Integer> o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            DefaultComboBoxModel<ListElement> model = new DefaultComboBoxModel<ListElement>();
            for (ListElement listElement : fieldTypes) {
                model.addElement(listElement);
            }
            return model;
        }

        private class DataTypeListCellRenderer
        extends DefaultListCellRenderer {
            private DataTypeListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    label.setText(value.toString());
                    Font f = label.getFont();
                    if (SelectAttributesPanel.this.isOriginalType(DataTypeCellEditor.this.currentRow, value.toString())) {
                        label.setFont(f.deriveFont(f.getStyle() | 1));
                    } else {
                        label.setFont(f.deriveFont(f.getStyle() & 0xFFFFFFFE));
                    }
                }
                return label;
            }
        }
    }

    private class OriginCellRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 3) {
                int origin = (Integer)table.getModel().getValueAt(row, 3);
                IconTheme iconManager = ToolsSwingLocator.getIconThemeManager().getDefault();
                I18nManager i18Manager = ToolsLocator.getI18nManager();
                this.setHorizontalAlignment(0);
                switch (origin) {
                    case 1: {
                        this.setToolTipText(i18Manager.getTranslation("_Query_calculated_field"));
                        this.setIcon(iconManager.get("featurestore-query-calculated-column"));
                        break;
                    }
                    case 2: {
                        this.setToolTipText(i18Manager.getTranslation("_Table_calculated_field"));
                        this.setIcon(iconManager.get("featurestore-calculated-column"));
                        break;
                    }
                    case 0: {
                        this.setToolTipText(i18Manager.getTranslation("_Real_field"));
                        this.setIcon(iconManager.get("featurestore-column"));
                        break;
                    }
                    default: {
                        this.setText(value.toString());
                    }
                }
                return this;
            }
            return this;
        }
    }

    private class DataTypeCellRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                String name = (String)table.getModel().getValueAt(row, 5);
                this.setText(value.toString());
                Font f = this.getFont();
                if (SelectAttributesPanel.this.isOriginalType(row, value.toString())) {
                    this.setFont(f.deriveFont(f.getStyle() & 0xFFFFFFFE));
                } else {
                    this.setFont(f.deriveFont(f.getStyle() | 1));
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private static class TableFilterController {
        private final JTable jtable;
        private final JTextComponent jtext;
        private final JButton btnFilter;
        private final int filterColumn;
        private FilteredTableModel tableModel;

        public TableFilterController(JTable jtable, final JTextComponent jtext, JButton btnFilter, int filterColumn) {
            this.jtable = jtable;
            this.filterColumn = filterColumn;
            this.btnFilter = btnFilter;
            this.jtext = jtext;
            this.tableModel = null;
            ToolsSwingLocator.getToolsSwingManager().setDefaultPopupMenu(jtext);
            ToolsSwingLocator.getToolsSwingManager().addClearButton(jtext, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (tableModel != null) {
                        tableModel.setFilter(null);
                        jtext.setText("");
                    }
                }
            });
            this.jtext.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyChar() == '\n' && tableModel != null) {
                        tableModel.setFilter(jtext.getText());
                    }
                }
            });
            this.btnFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (tableModel != null) {
                        tableModel.setFilter(jtext.getText());
                    }
                }
            });
        }

        public void setModel(TableModel tableModel) {
            this.tableModel = ToolsSwingLocator.getToolsSwingManager().createFilteredTableModel(tableModel, this.filterColumn);
            this.jtable.setModel((TableModel)this.tableModel);
        }
    }

    private static class AttributesTableModel
    extends AbstractTableModel
    implements TableModel {
        private final ExportAttributes attributes;
        private final String[] columnNames = new String[7];
        private final Class[] columnClases = new Class[7];
        private final String[] columnToolTips = new String[7];
        private final DataTypesManager dataManager;
        private final SelectAttributesPanel panel;

        public AttributesTableModel(ExportAttributes attributes, SelectAttributesPanel panel) {
            this.panel = panel;
            this.attributes = attributes;
            this.dataManager = ToolsLocator.getDataTypesManager();
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            this.columnNames[5] = i18nManager.getTranslation("_name");
            this.columnNames[6] = i18nManager.getTranslation("_New_name");
            this.columnNames[3] = i18nManager.getTranslation("_Origin");
            this.columnNames[1] = i18nManager.getTranslation("_type");
            this.columnNames[2] = i18nManager.getTranslation("_Size");
            this.columnNames[4] = i18nManager.getTranslation("_Virtual");
            this.columnNames[0] = "";
            this.columnClases[5] = String.class;
            this.columnClases[6] = String.class;
            this.columnClases[3] = String.class;
            this.columnClases[1] = String.class;
            this.columnClases[2] = Integer.class;
            this.columnClases[0] = Boolean.class;
            this.columnClases[4] = Boolean.class;
            this.columnToolTips[5] = i18nManager.getTranslation("_Actual_field_name");
            this.columnToolTips[6] = i18nManager.getTranslation("_New_field_name_in_the_export");
            this.columnToolTips[3] = i18nManager.getTranslation("_Origin");
            this.columnToolTips[1] = i18nManager.getTranslation("_Attribute_descriptor_type");
            this.columnToolTips[2] = i18nManager.getTranslation("_Field_size");
            this.columnToolTips[4] = i18nManager.getTranslation("_Export_attribute_as_an_expression_or_as_a_real_field");
            this.columnToolTips[0] = i18nManager.getTranslation("_Select_if_field_has_to_be_exported");
        }

        public String getColumnToolTip(int column) {
            return this.columnToolTips[column];
        }

        @Override
        public int getRowCount() {
            return this.attributes.size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnClases[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 5: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    ExportAttributes.ExportAttribute attr = (ExportAttributes.ExportAttribute)this.attributes.get(rowIndex);
                    if (!attr.getDescriptor().isComputed()) {
                        return false;
                    }
                    DataType dataType = attr.getDescriptor().getDataType();
                    if (dataType.getType() == 66) {
                        return true;
                    }
                    return !dataType.isContainer() && !dataType.isObject() && !dataType.isDynObject();
                }
            }
            return true;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ExportAttributes.ExportAttribute attr = (ExportAttributes.ExportAttribute)this.attributes.get(rowIndex);
            switch (columnIndex) {
                case 5: {
                    return attr.getName();
                }
                case 6: {
                    return attr.getNewName();
                }
                case 3: {
                    if (attr.getDescriptor().isComputed()) {
                        if (attr.isFromQuery()) {
                            return 1;
                        }
                        return 2;
                    }
                    return 0;
                }
                case 1: {
                    try {
                        return this.dataManager.getTypeName(attr.getNewDataType());
                    }
                    catch (Exception ex) {
                        return this.dataManager.getTypeName(attr.getDataType());
                    }
                }
                case 2: {
                    return attr.getSize();
                }
                case 0: {
                    return attr.isExported();
                }
                case 4: {
                    return attr.isComputed();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ExportAttributes.ExportAttribute attr = (ExportAttributes.ExportAttribute)this.attributes.get(rowIndex);
            switch (columnIndex) {
                case 5: {
                    break;
                }
                case 6: {
                    int indexChanged = attr.setNewName(Objects.toString(aValue, attr.getName()));
                    NamesTranslator translator = this.attributes.getNamesTranslator();
                    I18nManager i18 = ToolsLocator.getI18nManager();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)Objects.toString(aValue, attr.getName()), (CharSequence)translator.getTranslation(attr.getName()))) {
                        StringBuilder changedLog = new StringBuilder();
                        changedLog.append("'");
                        changedLog.append(Objects.toString(aValue, attr.getName()));
                        changedLog.append("' ");
                        changedLog.append(i18.getTranslation("_field_name_has_been_fixed_to"));
                        changedLog.append(" '");
                        changedLog.append(translator.getTranslation(attr.getName()));
                        changedLog.append("'");
                        this.panel.setMessage(changedLog.toString());
                    }
                    if (indexChanged == -1) break;
                    String fieldSource = translator.getSource(indexChanged);
                    String fieldTarget = translator.getTranslation(indexChanged);
                    StringBuilder changedLog = new StringBuilder();
                    changedLog.append("'");
                    changedLog.append(fieldSource);
                    changedLog.append("' ");
                    changedLog.append(i18.getTranslation("_has_been_changed_to_avoid_duplicates_for"));
                    changedLog.append(" '");
                    changedLog.append(fieldTarget);
                    changedLog.append("'");
                    this.panel.setMessage(changedLog.toString());
                    break;
                }
                case 1: {
                    attr.setNewType(this.dataManager.getType(Objects.toString(aValue)));
                    break;
                }
                case 2: {
                    try {
                        attr.setSize(Integer.parseInt(Objects.toString(aValue)));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Not been able to set size value of attribute " + attr.getName() + " (" + Objects.toString(aValue) + ").", (Throwable)ex);
                    }
                    break;
                }
                case 0: {
                    try {
                        attr.setExported(((Boolean)this.dataManager.get(1).coerce(aValue)).booleanValue());
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Not been able to set exported value of attribute " + attr.getName() + " (" + Objects.toString(aValue) + ").", (Throwable)ex);
                    }
                    break;
                }
                case 4: {
                    try {
                        attr.setComputed(((Boolean)this.dataManager.get(1).coerce(aValue)).booleanValue());
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Not been able to set calculated value of attribute " + attr.getName() + " (" + Objects.toString(aValue) + ").", (Throwable)ex);
                    }
                    break;
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

