/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.impl.panels;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.SortedMap;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.ExportCharsetParameters;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.impl.panels.SelectCharsetPanelView;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectCharsetPanel
extends SelectCharsetPanelView
implements ExportPanel {
    private static final Logger LOG = LoggerFactory.getLogger(SelectCharsetPanel.class);
    private final JExportProcessPanel processPanel;
    private final ExportParameters parameters;

    public SelectCharsetPanel(JExportProcessPanel processPanel, ExportParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = parameters;
        this.initComponents();
    }

    private void initComponents() {
        DynStruct parametersDefinition = ToolsLocator.getPersistenceManager().getDefinition("DBFStoreParameters");
        DynField dynField = parametersDefinition.getDynField("Encoding");
        DefaultListModel<String> model = new DefaultListModel<String>();
        SortedMap<String, Charset> availableCharsets = Charset.availableCharsets();
        for (Map.Entry<String, Charset> charset : availableCharsets.entrySet()) {
            model.addElement(charset.getKey());
        }
        this.lstCharset.setModel(model);
        this.lstCharset.setSelectedIndex(0);
        this.translate();
    }

    private void translate() {
        ToolsSwingManager i18nc = ToolsSwingLocator.getToolsSwingManager();
        i18nc.translate(this.lblCharset);
    }

    public JComponent asJComponent() {
        return this;
    }

    public String getIdPanel() {
        return this.getClass().getSimpleName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Select_encoding");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        return true;
    }

    public void enterPanel() {
        ExportCharsetParameters params = (ExportCharsetParameters)this.parameters;
        if (!StringUtils.isEmpty((CharSequence)params.getCharset())) {
            String charset = params.getCharset();
            ListElement.setSelected((JList)this.lstCharset, (Object)charset);
            return;
        }
        try {
            String sourceCharset = (String)this.parameters.getSourceFeatureStore().getParameters().getDynValue("charset");
            if (sourceCharset != null) {
                this.lstCharset.setSelectedValue(sourceCharset, true);
                return;
            }
        }
        catch (DynFieldNotFoundException e) {
            LOG.info("Can't find charset dyn value from source store");
        }
        this.lstCharset.setSelectedValue(Charset.forName("UTF-8").displayName(), true);
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        ExportCharsetParameters params = (ExportCharsetParameters)this.parameters;
        params.setCharset((String)this.lstCharset.getSelectedValue());
    }
}

