/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.swing.impl.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.ExportManager;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.impl.panels.SelectFilterPanelView;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.expressionevaluator.FeatureStoreElement;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ListElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectFilterPanel
extends SelectFilterPanelView
implements ExportPanel {
    private static final Logger LOG = LoggerFactory.getLogger(SelectFilterPanel.class);
    private final ExportParameters parameters;
    private final JExportProcessPanel processPanel;
    private ExpressionPickerController pickerExpression;

    public SelectFilterPanel(JExportProcessPanel processPanel, ExportParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = parameters;
        this.initComponents();
    }

    public String getIdPanel() {
        return "PANEL_SELECT_EXPORT_FILTER";
    }

    public String getTitlePanel() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Filter");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        this.checkPanel(true);
        return true;
    }

    public void enterPanel() {
        if (this.parameters.getFilterExpresion() != null) {
            this.pickerExpression.set((Object)this.parameters.getFilterExpresion());
        }
        switch (this.parameters.getFeaturesToUse()) {
            case 2: {
                this.rdbFilteredRows.setSelected(true);
                break;
            }
            case 1: {
                this.rdbSelectedRows.setSelected(true);
                break;
            }
            default: {
                this.rdbAllRows.setSelected(true);
            }
        }
        this.doChangeOption();
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        this.parameters.setFilterExpresion(this.getFilterExpresion());
        if (this.isFullLayerSelected()) {
            this.parameters.setFeaturesToUse(0);
        } else if (this.isPersonalizedFilterSelected()) {
            this.parameters.setFeaturesToUse(2);
        } else {
            this.parameters.setFeaturesToUse(1);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        ExportManager manager = ExportLocator.getManager();
        DefaultListModel<ListElement> model = new DefaultListModel<ListElement>();
        List filters = manager.getFilters();
        for (ExportManager.ExportFilter filter : filters) {
            model.addElement(new ListElement(filter.getName(), (Object)filter.getExpression()));
        }
        ActionListener changeOptionAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectFilterPanel.this.doChangeOption();
            }
        };
        this.rdbAllRows.addActionListener(changeOptionAction);
        this.rdbFilteredRows.addActionListener(changeOptionAction);
        this.rdbSelectedRows.addActionListener(changeOptionAction);
        this.rdbAllRows.setSelected(true);
        this.doChangeOption();
        ExpressionEvaluatorSwingManager expManager = ExpressionEvaluatorSwingLocator.getManager();
        this.pickerExpression = expManager.createExpressionPickerController((JTextComponent)this.txtPicker, this.btnPickerExp, this.btnPickerBook, this.btnPickerHis);
        FeatureStore store = this.parameters.getSourceFeatureStore();
        if (store != null) {
            DataSwingManager swm = DALSwingLocator.getSwingManager();
            FeatureStoreElement expStore = swm.createFeatureStoreElement(store);
            this.pickerExpression.getConfig().addElement((Element)expStore);
        }
        this.translate();
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.rdbAllRows.setText(i18nManager.getTranslation("_Todos_los_registros"));
        this.rdbSelectedRows.setText(i18nManager.getTranslation("_Los_registros_seleccionados"));
        this.rdbFilteredRows.setText(i18nManager.getTranslation("_Los_registros_que_cumplan_el_critrio_seleccionado"));
        this.lblHeader.setText(i18nManager.getTranslation("_Indique_que_registros_desea_exportar"));
    }

    protected void doChangeOption() {
    }

    public boolean isFullLayerSelected() {
        return this.rdbAllRows.isSelected();
    }

    public boolean isSelectedFeaturesSelected() {
        return this.rdbSelectedRows.isSelected();
    }

    public boolean isPersonalizedFilterSelected() {
        return this.rdbFilteredRows.isSelected();
    }

    public void checkPanel(boolean save) throws ExportPanelValidationException {
        if (this.rdbFilteredRows.isSelected()) {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            if (this.pickerExpression.isEmpty()) {
                throw new ExportPanelValidationException(i18nManager.getTranslation("_The_expresion_is_empty_Check_other_option_or_enter_a_expresion"));
            }
            if (!this.pickerExpression.isValid()) {
                throw new ExportPanelValidationException(i18nManager.getTranslation("_Problems_compiling_the_expesion_Check_the_sintax_Remember_use_SQL_expresion_sintax") + "\n\n" + this.pickerExpression.get().getPhrase());
            }
        }
    }

    public Expression getFilterExpresion() {
        if (this.pickerExpression.isValid()) {
            Expression exp = this.pickerExpression.get();
            return exp;
        }
        return null;
    }
}

