/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.gvsig.andami.Arguments;
import org.gvsig.andami.ConfigurationException;
import org.gvsig.andami.GlobalKeyEventDispatcher;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.LibraryExtension;
import org.gvsig.andami.LocaleManager;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.Utilities;
import org.gvsig.andami.actioninfo.ActionInfo;
import org.gvsig.andami.actioninfo.ActionInfoManager;
import org.gvsig.andami.config.generate.Andami;
import org.gvsig.andami.config.generate.AndamiConfig;
import org.gvsig.andami.config.generate.Plugin;
import org.gvsig.andami.impl.DefaultArguments;
import org.gvsig.andami.impl.UnsavedDataException;
import org.gvsig.andami.messages.Messages;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.persistence.serverData.ServerDataPersistence;
import org.gvsig.andami.plugins.ExclusiveUIExtension;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.plugins.ExtensionDecorator;
import org.gvsig.andami.plugins.IExtension;
import org.gvsig.andami.plugins.PluginClassLoader;
import org.gvsig.andami.plugins.config.generate.Action;
import org.gvsig.andami.plugins.config.generate.ActionTool;
import org.gvsig.andami.plugins.config.generate.AlternativeNames;
import org.gvsig.andami.plugins.config.generate.ComboButton;
import org.gvsig.andami.plugins.config.generate.ComboButtonElement;
import org.gvsig.andami.plugins.config.generate.ComboScale;
import org.gvsig.andami.plugins.config.generate.Depends;
import org.gvsig.andami.plugins.config.generate.Extensions;
import org.gvsig.andami.plugins.config.generate.LabelSet;
import org.gvsig.andami.plugins.config.generate.Menu;
import org.gvsig.andami.plugins.config.generate.PluginConfig;
import org.gvsig.andami.plugins.config.generate.PopupMenu;
import org.gvsig.andami.plugins.config.generate.PopupMenus;
import org.gvsig.andami.plugins.config.generate.SelectableTool;
import org.gvsig.andami.plugins.config.generate.SkinExtension;
import org.gvsig.andami.plugins.config.generate.SkinExtensionType;
import org.gvsig.andami.plugins.config.generate.ToolBar;
import org.gvsig.andami.plugins.status.IExtensionStatus;
import org.gvsig.andami.plugins.status.IUnsavedData;
import org.gvsig.andami.ui.AndamiEventQueue;
import org.gvsig.andami.ui.DisablePluginsConflictingLayoutPanel;
import org.gvsig.andami.ui.MDIManagerLoadException;
import org.gvsig.andami.ui.ToolsWindowManager;
import org.gvsig.andami.ui.fonts.FontUtils;
import org.gvsig.andami.ui.mdiFrame.MDIFrame;
import org.gvsig.andami.ui.mdiFrame.MainFrame;
import org.gvsig.andami.ui.mdiManager.MDIManagerFactory;
import org.gvsig.andami.ui.splash.MultiSplashWindow;
import org.gvsig.andami.ui.theme.Theme;
import org.gvsig.andami.ui.wizard.UnsavedDataPanel;
import org.gvsig.gui.beans.controls.IControl;
import org.gvsig.installer.lib.api.Dependencies;
import org.gvsig.installer.lib.api.Dependency;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.creation.MakePluginPackageServiceException;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.api.execution.InstallWizardPanel;
import org.gvsig.installer.swing.api.wizard.InstallerWizardActionListener;
import org.gvsig.installer.swing.api.wizard.InstallerWizardPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.ListBaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.library.impl.DefaultLibrariesInitializer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.gvsig.tools.util.FolderSet;
import org.gvsig.utils.DateTime;
import org.gvsig.utils.DefaultListModel;
import org.gvsig.utils.XMLEntity;
import org.gvsig.utils.xml.XMLEncodingUtils;
import org.gvsig.utils.xmlEntity.generate.XmlTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher {
    private static Arguments arguments;
    protected static Logger logger;
    protected static Preferences prefs;
    protected static AndamiConfig andamiConfig;
    protected static MultiSplashWindow splashWindow;
    protected static String appName;
    protected static Locale locale;
    protected static PluginsConfig pluginsConfig;
    protected static PluginsServices pluginsServices;
    protected static MDIFrame frame;
    protected static HashMap<Class<? extends IExtension>, ExtensionDecorator> classesExtensions;
    protected static String andamiConfigPath;
    protected static final String nonWinDefaultLookAndFeel = "com.formdev.flatlaf.FlatLightLaf";
    protected static final String DEFAULT_ICON_THEME_NAME = "TReCC22";
    protected static List<String> pluginsOrdered;
    protected static List<IExtension> extensions;
    protected static String appHomeDir;
    protected static final String CASTORENCODING = "UTF8";
    protected static ListBaseException launcherrors;
    protected static Theme theme;
    private List<String> deprecatedPluginNames = null;
    private static Launcher launcherInstance;
    private static final int INFO_OS_NAME = 0;
    private static final int INFO_OS_ARCH = 1;
    private static final int INFO_OS_VERSION = 2;
    private static final int INFO_OS_ADITIONAL = 3;
    private static final int INFO_JRE_VENDOR = 4;
    private static final int INFO_JRE_VERSION = 5;
    private static final int INFO_JRE_HOME = 6;
    private static final int INFO_PROXY_HOST = 7;
    private static final int INFO_PROXY_PORT = 8;
    private static final int INFO_PROXY_USER = 9;
    private static final int INFO_PROXY_PASSWORD = 10;
    private static final int INFO_APP_LOCALE = 11;
    private static final int INFO_APP_FOLDER = 12;
    private static final int INFO_APP_HOME = 13;
    private static final int INFO_APP_INSTALL_FOLDER = 14;
    private static final int INFO_APP_PLUGINS_FOLDER = 15;
    private static final int INFO_APP_THEME = 16;
    private static final int INFO_APP_SKIN = 17;
    private static final int INFO_PACKAGES = 18;
    private static final int INFO_TEMP_FOLDER = 19;

    public static Launcher getInstance() {
        if (launcherInstance == null) {
            launcherInstance = new Launcher();
        }
        return launcherInstance;
    }

    public static void main(String[] args) throws Exception {
        arguments = new DefaultArguments(args);
        Launcher launcher = Launcher.getInstance();
        try {
            if (arguments.contains("install")) {
                launcher.doInstall(args);
            } else {
                launcher.doMain(args);
            }
        }
        catch (Exception e) {
            logger.error("excepcion al arrancar", (Throwable)e);
            System.exit(-1);
        }
    }

    protected void downloadExtensions(String extDir) {
    }

    protected void addError(Throwable ex) {
        if (launcherrors == null) {
            launcherrors = new LaunchException();
        }
        launcherrors.add((Object)ex);
    }

    protected void addError(String msg, Throwable cause) {
        logger.error(msg, cause);
        this.addError(new RuntimeException(msg, cause));
    }

    protected void addError(String msg) {
        this.addError(msg, null);
    }

    private String translate(String msg) {
        return PluginServices.getText(Launcher.class, msg);
    }

    private List<String> getDeprecatedPluginNames() {
        if (this.deprecatedPluginNames == null) {
            String[] ss = new String[]{"org.gvsig.app", "org.gvsig.coreplugin", "org.gvsig.editing", "org.gvsig.installer.app.extension", "org.gvsig.exportto.app.extension"};
            this.deprecatedPluginNames = Arrays.asList(ss);
        }
        return this.deprecatedPluginNames;
    }

    public static Arguments getArguments() {
        return arguments;
    }

    public void doMain(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: Launcher appName plugins-directory [--language=locale]");
            System.err.println("No arguments specified.");
            System.err.println("Use default arguments 'gvSIG gvSIG/extensiones'");
            args = new String[]{"gvSIG", "gvSIG/extensiones"};
        }
        this.initializeApp(args, null);
        Policy.setPolicy(new Policy(){

            @Override
            public PermissionCollection getPermissions(CodeSource codesource) {
                Permissions perms = new Permissions();
                perms.add(new AllPermission());
                return perms;
            }

            @Override
            public void refresh() {
            }
        });
        new DefaultLibrariesInitializer().fullInitialize(true);
        InstallerLocator.getInstallerManager().setDownloadBaseURL(new URL("http://downloads.gvsig.org/download/gvsig-desktop/"));
        try {
            Launcher.initIconThemes();
        }
        catch (Exception ex) {
            this.addError("Can't initialize icon theme", ex);
        }
        try {
            this.registerIcons();
        }
        catch (Exception ex) {
            this.addError("Can't register icons", ex);
        }
        try {
            logger.info("Initialize andami theme");
            theme = this.getTheme(andamiConfig.getPluginsDirectory());
        }
        catch (Exception ex) {
            this.addError("Can't get personalized theme for the application", ex);
        }
        UIManager.put("Desktop.background", theme.getBackgroundColor());
        Frame f = new Frame();
        splashWindow = new MultiSplashWindow(f, theme, 27);
        splashWindow.process(this.translate("SplashWindow.configuring_proxy"));
        logger.info("Configute http proxy");
        this.configureProxy();
        splashWindow.process(this.translate("SplashWindow.looking_for_updates"));
        splashWindow.process(this.translate("SplashWindow.initialize_install_manager"));
        this.initializeInstallerManager();
        InstallerManager installerManager = InstallerLocator.getInstallerManager();
        PackageInfo[] installedPackages = null;
        try {
            installedPackages = installerManager.getInstalledPackages();
        }
        catch (MakePluginPackageServiceException makePluginPackageServiceException) {
            // empty catch block
        }
        logger.info("Dump system information");
        this.logger_info(Launcher.getInformation(installedPackages));
        this.saveEnvironInformation(installedPackages);
        splashWindow.process(this.translate("SplashWindow.load_plugins_configuration"));
        try {
            logger.info("Load plugins information");
            this.loadPluginConfigs();
            if (pluginsConfig.isEmpty()) {
                logger.warn("No valid plugin was found.");
                System.exit(-1);
            }
        }
        catch (Throwable ex) {
            this.addError("Can't load plugins", ex);
        }
        splashWindow.process(this.translate("SplashWindow.check_incompatible_plugins"));
        this.fixIncompatiblePlugins(installedPackages);
        splashWindow.process(this.translate("SplashWindow.setup_plugins_configuration"));
        try {
            logger.info("Configure plugins class loader");
            this.loadPluginServices();
        }
        catch (Throwable ex) {
            logger.warn("Can't initialize plugin's classloaders  ", ex);
        }
        try {
            this.registerActions();
        }
        catch (Throwable ex) {
            logger.warn("Can't register actions of plugins", ex);
        }
        this.initializeIdentityManagement(new File(andamiConfig.getPluginsDirectory()).getAbsoluteFile());
        splashWindow.process(this.translate("SplashWindow.initialize_plugins_libraries"));
        this.initializeLibraries();
        splashWindow.process(this.translate("SplashWindow.looking_for_a_skin"));
        logger.info("Initialize skin");
        this.skinPlugin(null);
        splashWindow.process(this.translate("setting_up_event_queue"));
        AndamiEventQueue waitQueue = new AndamiEventQueue();
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(waitQueue);
        splashWindow.process(this.translate("SplashWindow.starting_plugin_internationalization_system"));
        this.pluginsMessages();
        splashWindow.process(this.translate("SplashWindow.update_framework_configuration"));
        this.updateAndamiConfig();
        frame = MDIFrame.getInstance();
        splashWindow.process(this.translate("SplashWindow.setting_up_applications_name_and_icons"));
        Launcher.frameIcon(theme);
        splashWindow.process(this.translate("SplashWindow.preparing_workbench"));
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.init();
                frame.setVisible((Boolean)arguments.get("showgui", true));
            }
        });
        ToolsSwingLocator.registerWindowManager(ToolsWindowManager.class);
        splashWindow.process(this.translate("SplashWindow.loading_plugin_settings"));
        this.loadPluginsPersistence();
        splashWindow.process(this.translate("SplashWindow.initializing_extensions"));
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Launcher.this.initializeExtensions();
            }
        });
        splashWindow.process(this.translate("SplashWindow.setting_up_master_extension"));
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Launcher.initializeExclusiveUIExtension();
            }
        });
        frame.setClassesExtensions(classesExtensions);
        this.message(this.translate("SplashWindow.installing_extensions_controls"));
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Launcher.this.installPluginsControls();
            }
        });
        this.message(this.translate("SplashWindow.installing_extensions_menus"));
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Launcher.this.installPluginsMenus();
            }
        });
        this.message(this.translate("SplashWindow.initializing_server_data_persistence"));
        ServerDataPersistence.registerPersistence();
        this.message(this.translate("SplashWindow.installing_extensions_labels"));
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Launcher.this.installPluginsLabels();
            }
        });
        this.message(this.translate("creating_main_window"));
        frame.setVisible(true);
        frame.setCursor(3);
        this.message(this.translate("SplashWindow.initializing_accelerator_keys"));
        GlobalKeyEventDispatcher keyDispatcher = GlobalKeyEventDispatcher.getInstance();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(keyDispatcher);
        this.message(this.translate("SplashWindow.enable_controls"));
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    frame.enableControls();
                }
                catch (Throwable th) {
                    logger.warn("Problems enabling controls", th);
                }
            }
        });
        this.message(this.translate("SplashWindow.post_initializing_extensions"));
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Launcher.this.postInitializeExtensions();
            }
        });
        this.message(this.translate("SplashWindow.enable_controls"));
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    frame.enableControls();
                }
                catch (Throwable th) {
                    logger.warn("Problems enabling controls", th);
                }
            }
        });
        splashWindow.close();
        frame.setCursor(0);
        if (launcherrors != null) {
            NotificationManager.addError((Throwable)launcherrors);
        }
        if (!arguments.contains("showgui", "false")) {
            org.apache.log4j.Logger.getRootLogger().addAppender((Appender)new NotificationAppender());
        }
        PluginsLocator.getManager().executeStartupTasks();
    }

    private void initializeInstallerManager() {
        PluginsManager pluginmgr = PluginsLocator.getManager();
        InstallerManager installerManager = InstallerLocator.getInstallerManager();
        List<File> folders = pluginmgr.getPluginsFolders();
        for (File folder : folders) {
            installerManager.addLocalAddonRepository(folder, "plugin");
        }
        installerManager.setDefaultLocalAddonRepository(folders.get(0), "plugin");
        IconThemeManager iconManager = ToolsSwingLocator.getIconThemeManager();
        FolderSet fset = iconManager.getRepository();
        Iterator it = fset.iterator();
        boolean first = true;
        while (it.hasNext()) {
            FolderSet.FolderEntry entry = (FolderSet.FolderEntry)it.next();
            installerManager.addLocalAddonRepository(entry.getFolder(), "iconset");
            if (!first) continue;
            first = false;
            installerManager.setDefaultLocalAddonRepository(entry.getFolder(), "iconset");
        }
    }

    private void message(final String msg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Launcher.this.message(msg);
                    }
                });
            }
            catch (Exception e) {
                logger.info(msg);
                logger.warn("Error showing message.", (Throwable)e);
            }
            return;
        }
        if (splashWindow.isVisible()) {
            splashWindow.process(msg);
        }
        if (frame.isVisible()) {
            frame.message(msg, 1);
        }
    }

    private void initializeLibraries() {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(pluginsOrdered.size() + 1);
        classLoaders.add(this.getClass().getClassLoader());
        Iterator<String> iter = pluginsOrdered.iterator();
        logger.info("Initializing plugins libraries: ");
        while (iter.hasNext()) {
            String pName = iter.next();
            PluginServices ps = (PluginServices)pluginsServices.get(pName);
            logger.info("Initializing plugin libraries (" + pName + ")");
            classLoaders.add(ps.getClassLoader());
        }
        new DefaultLibrariesInitializer(classLoaders.toArray(new ClassLoader[classLoaders.size()])).fullInitialize(true);
        classLoaders.clear();
        classLoaders = null;
    }

    private void initializeApp(String[] args, String applicationClasifier) throws IOException, ConfigurationException {
        appName = args.length < 1 ? "gvSIG" : args[0];
        PluginServices.setArguments(args);
        this.getOrCreateConfigFolder();
        this.configureLogging(appName, applicationClasifier);
        if (!this.validJVM()) {
            logger.error("Not a valid JRE. Exit application.");
            System.exit(-1);
        }
        ToolsLocator.registerDefaultToolsLibraries();
        ToolsLocator.getFoldersManager().cleanTemporaryFiles();
        if (args.length < 2) {
            this.loadAndamiConfig("gvSIG/extensiones");
        } else {
            this.loadAndamiConfig(args[1]);
        }
        Launcher.configureLocales();
        logger.info("Configure LookAndFeel");
        this.configureLookAndFeel();
    }

    private void configureLookAndFeel() {
        try {
            String lookAndFeel = Launcher.getAndamiConfig().getLookAndFeel();
            if (lookAndFeel == null) {
                lookAndFeel = Launcher.getDefaultLookAndFeel();
            }
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception e) {
            logger.warn(Messages.getString("Launcher.look_and_feel"), (Throwable)e);
        }
        FontUtils.initFonts();
    }

    private void loadAndamiConfig(String pluginFolder) throws ConfigurationException {
        andamiConfigPath = appHomeDir + File.separator + "andami-config.xml";
        Launcher.andamiConfigFromXML(andamiConfigPath);
        andamiConfig.setPluginsDirectory(pluginFolder);
    }

    private void getOrCreateConfigFolder() {
        appHomeDir = System.getProperty(appName + ".home");
        if (appHomeDir == null) {
            appHomeDir = System.getProperty("user.home");
        }
        appHomeDir = appHomeDir + File.separator + appName;
        File parent = new File(appHomeDir);
        parent.mkdirs();
    }

    private void configureLogging(String appName, String applicationClasifier) throws IOException {
        String pathname = StringUtils.isBlank((CharSequence)applicationClasifier) ? appHomeDir + File.separator + appName + ".log" : appHomeDir + File.separator + appName + "-" + applicationClasifier + ".log";
        URL config = Launcher.class.getClassLoader().getResource("log4j.properties");
        if (config == null) {
            config = Launcher.class.getClassLoader().getResource("default-log4j/log4j.properties");
        }
        PropertyConfigurator.configure((URL)config);
        PatternLayout l = new PatternLayout("%p %r %t %C - %m%n");
        RollingFileAppender fa = new RollingFileAppender((Layout)l, pathname, false);
        fa.setMaxFileSize("512KB");
        fa.setMaxBackupIndex(3);
        org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
        if (!((Boolean)arguments.get("consolelogger", true)).booleanValue()) {
            rootLogger.removeAppender("stdout");
        }
        rootLogger.addAppender((Appender)fa);
        logger.info("Loadded log4j.properties from " + config.toString());
        if (StringUtils.isBlank((CharSequence)applicationClasifier)) {
            logger.info("Application " + appName);
        } else {
            logger.info("Application " + appName + "-" + applicationClasifier);
        }
    }

    public static String getApplicationName() {
        return appName;
    }

    public static String getApplicationDirectory() {
        return Launcher.getApplicationFolder().getAbsolutePath();
    }

    public static File getApplicationFolder() {
        return new File(System.getProperty("user.dir"));
    }

    private void registerIcons() {
        IconTheme theme = PluginServices.getIconTheme();
        ClassLoader loader = Launcher.class.getClassLoader();
        String[][] icons = new String[][]{{"main", "splash-default"}, {"main", "statusbar-info"}, {"main", "statusbar-warning"}, {"main", "statusbar-error"}};
        for (int i = 0; i < icons.length; ++i) {
            try {
                IconThemeHelper.registerIcon(icons[i][0], icons[i][1], Launcher.class);
                continue;
            }
            catch (Exception e) {
                logger.info("Can't register icon '" + icons[i][0] + "' (" + icons[i][1] + ").");
            }
        }
        theme.setDefaultIcon(loader.getResource("images/main/default-icon.png"));
    }

    private Properties loadProperties(File f) {
        FileInputStream fin = null;
        Properties p = null;
        try {
            fin = new FileInputStream(f);
            p = new Properties();
            p.load(fin);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return p;
    }

    private Theme getTheme(String pluginsDirectory) {
        Object theme;
        File pluginsDir;
        File infoFile = new File(Launcher.getApplicationFolder(), "package.info");
        File themeFile = null;
        ArrayList<Theme> themes = new ArrayList<Theme>();
        String name = PluginServices.getArgumentByName("andamiTheme");
        if (name != null) {
            themeFile = new File(name);
            logger.info("search andami-theme in {}", (Object)themeFile.getAbsolutePath());
            if (themeFile.exists()) {
                Theme theme2 = new Theme(this.loadProperties(infoFile));
                theme2.readTheme(themeFile);
                logger.info("andami-theme found in {}", (Object)themeFile.getAbsolutePath());
                return theme2;
            }
        }
        if (!(pluginsDir = new File(pluginsDirectory)).isAbsolute()) {
            pluginsDir = new File(Launcher.getApplicationFolder(), pluginsDirectory);
        }
        if (pluginsDir.exists()) {
            logger.info("search andami-theme in plugins folder '" + pluginsDir.getAbsolutePath() + "'.");
            File[] pluginDirs = pluginsDir.listFiles();
            if (pluginDirs.length > 0) {
                for (int i = 0; i < pluginDirs.length; ++i) {
                    File pluginThemeFile = new File(pluginDirs[i], "theme" + File.separator + "andami-theme.xml");
                    if (!pluginThemeFile.exists()) continue;
                    Theme theme3 = new Theme(this.loadProperties(infoFile));
                    theme3.readTheme(pluginThemeFile);
                    themes.add(theme3);
                }
            }
        }
        themeFile = new File(Launcher.getAppHomeDir(), "theme" + File.separator + "andami-theme.xml");
        logger.info("search andami-theme in user's home {}", (Object)themeFile.getAbsolutePath());
        if (themeFile.exists()) {
            theme = new Theme(this.loadProperties(infoFile));
            ((Theme)theme).readTheme(themeFile);
            themes.add((Theme)theme);
        }
        themeFile = new File(Launcher.getApplicationDirectory(), "theme" + File.separator + "andami-theme.xml");
        logger.info("search andami-theme in installation folder {}", (Object)themeFile.getAbsolutePath());
        if (themeFile.exists()) {
            theme = new Theme(this.loadProperties(infoFile));
            ((Theme)theme).readTheme(themeFile);
            themes.add((Theme)theme);
        }
        Collections.sort(themes, new Comparator<Theme>(){

            @Override
            public int compare(Theme t1, Theme t2) {
                return t2.getPriority() - t1.getPriority();
            }
        });
        if (logger.isInfoEnabled()) {
            logger.info("Found andami-themes in:");
            for (Theme theme4 : themes) {
                logger.info(" - " + theme4.getPriority() + ", " + theme4.getSource().getAbsolutePath());
            }
        }
        theme = (Theme)themes.get(0);
        logger.info("Using theme '" + ((Theme)theme).getSource() + "'.");
        return theme;
    }

    private void configureProxy() {
        String host = prefs.get("firewall.http.host", "");
        String port = prefs.get("firewall.http.port", "");
        System.getProperties().put("http.proxyHost", host);
        System.getProperties().put("http.proxyPort", port);
        String proxyUser = prefs.get("firewall.http.user", null);
        String proxyPassword = prefs.get("firewall.http.password", null);
        if (proxyUser != null) {
            System.getProperties().put("http.proxyUserName", proxyUser);
            System.getProperties().put("http.proxyPassword", proxyPassword);
            Authenticator.setDefault(new ProxyAuth(proxyUser, proxyPassword));
        } else {
            Authenticator.setDefault(new ProxyAuth("", ""));
        }
    }

    private void restoreMDIStatus(XMLEntity xml) {
        if (xml == null) {
            xml = new XMLEntity();
        }
        Dimension sz = new Dimension(MainFrame.MAIN_FRAME_SIZE_DEFAULT[0], MainFrame.MAIN_FRAME_SIZE_DEFAULT[1]);
        if (xml.contains("MDIFrameSize")) {
            int[] wh = xml.getIntArrayProperty("MDIFrameSize");
            sz = new Dimension(wh[0], wh[1]);
        }
        frame.setSize(sz);
        Point pos = new Point(MainFrame.MAIN_FRAME_POS_DEFAULT[0], MainFrame.MAIN_FRAME_POS_DEFAULT[1]);
        if (xml.contains("MDIFramePos")) {
            int[] xy = xml.getIntArrayProperty("MDIFramePos");
            pos = new Point(xy[0], xy[1]);
        }
        frame.setLocation(pos);
        int state = 6;
        if (xml.contains("MDIFrameState")) {
            state = xml.getIntProperty("MDIFrameState");
        }
        frame.setExtendedState(state);
    }

    private XMLEntity saveMDIStatus() {
        XMLEntity xml = new XMLEntity();
        int[] wh = new int[]{frame.getWidth(), frame.getHeight()};
        xml.putProperty("MDIFrameSize", (Object)wh);
        int[] xy = new int[]{frame.getX(), frame.getY()};
        xml.putProperty("MDIFramePos", (Object)xy);
        xml.putProperty("MDIFrameState", frame.getExtendedState());
        return xml;
    }

    private boolean validJVM() {
        if (!SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_6)) {
            logger.warn("gvSIG requires Java version 1.6 or higher.");
            logger.warn("The Java HOME is '" + SystemUtils.getJavaHome().getAbsolutePath() + "'.");
            return false;
        }
        if (SystemUtils.isJavaAwtHeadless()) {
            logger.warn("The java used by gvSIG does not contain the libraries for access to the graphical interface (AWT-headless)");
            logger.warn("The Java HOME is '" + SystemUtils.getJavaHome().getAbsolutePath() + "'.");
            return false;
        }
        return true;
    }

    private void loadPluginsPersistence() throws ConfigurationException {
        XMLEntity entity = Launcher.persistenceFromXML();
        for (int i = 0; i < entity.getChildrenCount(); ++i) {
            XMLEntity plugin = entity.getChild(i);
            String pName = plugin.getStringProperty("com.iver.andami.pluginName");
            if (pName.compareToIgnoreCase("com.iver.cit.gvsig") == 0) {
                pName = "org.gvsig.app";
            }
            if (pluginsServices.get(pName) != null) {
                ((PluginServices)pluginsServices.get(pName)).setPersistentXML(plugin);
                continue;
            }
            if (!pName.startsWith("Andami.Launcher")) continue;
            this.restoreMDIStatus(plugin);
        }
    }

    private void savePluginPersistence() {
        Iterator i = pluginsConfig.keySet().iterator();
        XMLEntity entity = new XMLEntity();
        while (i.hasNext()) {
            String pName = (String)i.next();
            PluginServices ps = (PluginServices)pluginsServices.get(pName);
            XMLEntity ent = ps.getPersistentXML();
            if (ent == null) continue;
            ent.putProperty("com.iver.andami.pluginName", pName);
            entity.addChild(ent);
        }
        XMLEntity ent = this.saveMDIStatus();
        if (ent != null) {
            ent.putProperty("com.iver.andami.pluginName", "Andami.Launcher");
            entity.addChild(ent);
        }
        try {
            Launcher.persistenceToXML(entity);
        }
        catch (ConfigurationException e1) {
            this.addError(Messages.getString("Launcher.Se_produjo_un_error_guardando_la_configuracion_de_los_plugins"), e1);
        }
    }

    private void installPluginsLabels() {
        for (String name : pluginsConfig.keySet()) {
            PluginConfig pc = (PluginConfig)pluginsConfig.get(name);
            PluginServices ps = (PluginServices)pluginsServices.get(name);
            LabelSet[] ls = pc.getLabelSet();
            for (int j = 0; j < ls.length; ++j) {
                PluginClassLoader loader = ps.getClassLoader();
                try {
                    Class<?> clase = loader.loadClass(ls[j].getClassName());
                    frame.setStatusBarLabels(clase, ls[j].getLabel());
                    continue;
                }
                catch (Throwable e) {
                    this.addError(Messages.getString("Launcher.labelset_class"), e);
                }
            }
        }
    }

    private String configureSkin(XMLEntity xml, String defaultSkin) {
        if (defaultSkin == null) {
            for (int i = 0; i < xml.getChildrenCount(); ++i) {
                if (!xml.getChild(i).contains("Skin-Selected")) continue;
                String className = xml.getChild(i).getStringProperty("Skin-Selected");
                return className;
            }
        }
        return defaultSkin;
    }

    private void fixSkin(SkinExtension skinExtension, PluginClassLoader pluginClassLoader) throws MDIManagerLoadException {
        MDIManagerFactory.setSkinExtension(skinExtension, pluginClassLoader);
        try {
            Class<?> skinClass = pluginClassLoader.loadClass(skinExtension.getClassName());
            IExtension skinInstance = (IExtension)skinClass.newInstance();
            ExtensionDecorator newExtensionDecorator = new ExtensionDecorator(skinInstance, 0);
            classesExtensions.put(skinClass, newExtensionDecorator);
        }
        catch (ClassNotFoundException e) {
            logger.error(Messages.getString("Launcher.No_se_encontro_la_clase_mdi_manager"), (Throwable)e);
            throw new MDIManagerLoadException(e);
        }
        catch (InstantiationException e) {
            logger.error(Messages.getString("Launcher.No_se_pudo_instanciar_la_clase_mdi_manager"), (Throwable)e);
            throw new MDIManagerLoadException(e);
        }
        catch (IllegalAccessException e) {
            logger.error(Messages.getString("Launcher.No_se_pudo_acceder_a_la_clase_mdi_manager"), (Throwable)e);
            throw new MDIManagerLoadException(e);
        }
    }

    private void skinPlugin(String defaultSkin) throws MDIManagerLoadException {
        XMLEntity entity = null;
        try {
            entity = Launcher.persistenceFromXML();
        }
        catch (ConfigurationException e1) {
            e1.printStackTrace();
        }
        Iterator i = pluginsConfig.keySet().iterator();
        SkinExtension skinExtension = null;
        PluginClassLoader pluginClassLoader = null;
        ArrayList<SkinExtension> skinExtensions = new ArrayList<SkinExtension>();
        while (i.hasNext()) {
            String name = (String)i.next();
            PluginConfig pc = (PluginConfig)pluginsConfig.get(name);
            PluginServices ps = (PluginServices)pluginsServices.get(name);
            if (pc.getExtensions().getSkinExtension() == null) continue;
            SkinExtension[] se = pc.getExtensions().getSkinExtension();
            for (int numExten = 0; numExten < se.length; ++numExten) {
                skinExtensions.add(se[numExten]);
            }
            for (int j = 0; j < se.length; ++j) {
                String configuredSkin = this.configureSkin(entity, defaultSkin);
                if (configuredSkin == null || !configuredSkin.equals(se[j].getClassName())) continue;
                skinExtension = se[j];
                pluginClassLoader = ps.getClassLoader();
            }
        }
        if (skinExtension != null && pluginClassLoader != null) {
            this.fixSkin(skinExtension, pluginClassLoader);
        } else if (skinExtensions.contains("com.iver.core.mdiManager.NewSkin")) {
            this.skinPlugin("com.iver.core.mdiManager.NewSkin");
        } else if (skinExtensions.size() > 0) {
            SkinExtension se = (SkinExtension)skinExtensions.get(0);
            this.skinPlugin(se.getClassName());
        } else {
            throw new MDIManagerLoadException("No Skin-Extension installed");
        }
    }

    private static void frameIcon(Theme theme) {
        for (String pName : pluginsConfig.keySet()) {
            PluginConfig pc = (PluginConfig)pluginsConfig.get(pName);
            if (pc.getIcon() == null) continue;
            if (theme.getIcon() != null) {
                frame.setIconImage(theme.getIcon().getImage());
            } else {
                ImageIcon icon = PluginServices.getIconTheme().get(pc.getIcon().getSrc());
                frame.setIconImage(icon.getImage());
            }
            if (theme.getName() != null) {
                frame.setTitlePrefix(theme.getName());
            } else {
                frame.setTitlePrefix(pc.getIcon().getText());
            }
            if (theme.getBackgroundImage() == null) continue;
            PluginServices.getMDIManager().setBackgroundImage(theme.getBackgroundImage(), theme.getTypeDesktop());
        }
    }

    private void initializeExtensions() {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(pluginsOrdered.size());
        classLoaders.add(this.getClass().getClassLoader());
        Iterator<String> iter = pluginsOrdered.iterator();
        logger.info("Initializing plugins: ");
        while (iter.hasNext()) {
            String pName = iter.next();
            logger.info("Initializing plugin " + pName);
            PluginConfig pc = (PluginConfig)pluginsConfig.get(pName);
            PluginServices ps = (PluginServices)pluginsServices.get(pName);
            org.gvsig.andami.plugins.config.generate.Extension[] exts = pc.getExtensions().getExtension();
            TreeSet<org.gvsig.andami.plugins.config.generate.Extension> orderedExtensions = new TreeSet<org.gvsig.andami.plugins.config.generate.Extension>(new ExtensionComparator());
            for (int j = 0; j < exts.length; ++j) {
                if (!exts[j].getActive()) continue;
                if (orderedExtensions.contains(exts[j])) {
                    logger.warn("Two extensions with the same priority (" + exts[j].getClassName() + ")");
                }
                orderedExtensions.add(exts[j]);
            }
            Iterator e = orderedExtensions.iterator();
            logger.info("Initializing extensions of plugin " + pName + ": ");
            while (e.hasNext()) {
                org.gvsig.andami.plugins.config.generate.Extension extension = (org.gvsig.andami.plugins.config.generate.Extension)e.next();
                try {
                    logger.info("Initializing " + extension.getClassName() + "...");
                    this.message(extension.getClassName() + "...");
                    Class<?> extensionClass = ps.getClassLoader().loadClass(extension.getClassName());
                    IExtension extensionInstance = (IExtension)extensionClass.newInstance();
                    if (extensionInstance instanceof Extension) {
                        ((Extension)extensionInstance).setPlugin(ps);
                    } else {
                        logger.warn("The extension " + extensionClass.getName() + " don't extends of Extension.");
                    }
                    ExtensionDecorator newExtensionDecorator = new ExtensionDecorator(extensionInstance, 0);
                    classesExtensions.put(extensionClass, newExtensionDecorator);
                    extensionInstance.initialize();
                    extensions.add(extensionInstance);
                }
                catch (NoClassDefFoundError e1) {
                    this.addError("Can't find class extension (" + extension.getClassName() + ")", e1);
                }
                catch (Throwable e1) {
                    this.addError("Can't initialize extension '" + extension.getClassName() + "'.", e1);
                }
            }
        }
    }

    private void postInitializeExtensions() {
        logger.info("PostInitializing extensions: ");
        for (int i = 0; i < extensions.size(); ++i) {
            IExtension extensionInstance = extensions.get(i);
            String name = extensionInstance.getClass().getName();
            logger.info("PostInitializing " + name + "...");
            this.message(name + "...");
            try {
                extensionInstance.postInitialize();
                continue;
            }
            catch (Throwable ex) {
                this.addError("postInitialize of extension '" + extensionInstance.getClass().getName() + "' failed", ex);
            }
        }
    }

    private void registerActionOfExtensions(ActionInfoManager actionManager, Enumeration<SkinExtensionType> extensiones, ClassLoader loader) {
        while (extensiones.hasMoreElements()) {
            SkinExtensionType extension = extensiones.nextElement();
            try {
                ActionInfo actionInfo;
                Class<?> classExtension = loader.loadClass(extension.getClassName());
                Enumeration actions = extension.enumerateAction();
                while (actions.hasMoreElements()) {
                    Action action = (Action)actions.nextElement();
                    if (action.getName() == null) {
                        logger.info("invalid action name (null) in " + extension.getClassName() + " of " + loader.toString());
                        continue;
                    }
                    actionInfo = actionManager.createAction(classExtension, action.getName(), action.getLabel(), action.getActionCommand(), action.getIcon(), action.getAccelerator(), action.getPosition(), action.getTooltip());
                    actionManager.registerAction(actionInfo);
                    if (action.getPosition() >= 100000000L) continue;
                    logger.info("Invalid position in action (" + actionInfo.toString() + ").");
                    action.setPosition(action.getPosition() + 1000000000L);
                }
                Enumeration menus = extension.enumerateMenu();
                while (menus.hasMoreElements()) {
                    Menu menu = (Menu)menus.nextElement();
                    if (!menu.getIs_separator()) {
                        actionInfo = actionManager.createAction(classExtension, menu.getName(), menu.getText(), menu.getActionCommand(), menu.getIcon(), menu.getKey(), menu.getPosition(), menu.getTooltip());
                        if ((actionInfo = actionManager.registerAction(actionInfo)) != null) {
                            menu.setActionCommand(actionInfo.getCommand());
                            menu.setTooltip(actionInfo.getTooltip());
                            menu.setIcon(actionInfo.getIconName());
                            menu.setPosition(actionInfo.getPosition());
                            menu.setKey(actionInfo.getAccelerator());
                            menu.setName(actionInfo.getName());
                        }
                    }
                    if (menu.getPosition() >= 100000000L) continue;
                    logger.info("Invalid position in menu (" + menu.getText() + ").");
                    menu.setPosition(menu.getPosition() + 1000000000L);
                }
                Enumeration toolBars = extension.enumerateToolBar();
                while (toolBars.hasMoreElements()) {
                    ToolBar toolBar = (ToolBar)toolBars.nextElement();
                    Enumeration actionTools = toolBar.enumerateActionTool();
                    while (actionTools.hasMoreElements()) {
                        ActionTool actionTool = (ActionTool)actionTools.nextElement();
                        actionInfo = actionManager.createAction(classExtension, actionTool.getName(), actionTool.getText(), actionTool.getActionCommand(), actionTool.getIcon(), null, actionTool.getPosition(), actionTool.getTooltip());
                        actionInfo.putValue("DropDownGroup", actionTool.getDropDownGroup());
                        if ((actionInfo = actionManager.registerAction(actionInfo)) == null) continue;
                        actionTool.setActionCommand(actionInfo.getCommand());
                        actionTool.setTooltip(actionInfo.getTooltip());
                        actionTool.setIcon(actionInfo.getIconName());
                        actionTool.setPosition(actionInfo.getPosition());
                        actionTool.setName(actionInfo.getName());
                    }
                    Enumeration selectableTool = toolBar.enumerateSelectableTool();
                    while (selectableTool.hasMoreElements()) {
                        SelectableTool actionTool = (SelectableTool)selectableTool.nextElement();
                        actionInfo = actionManager.createAction(classExtension, actionTool.getName(), actionTool.getText(), actionTool.getActionCommand(), actionTool.getIcon(), null, actionTool.getPosition(), actionTool.getTooltip());
                        if ((actionInfo = actionManager.registerAction(actionInfo)) == null) continue;
                        actionTool.setActionCommand(actionInfo.getCommand());
                        actionTool.setTooltip(actionInfo.getTooltip());
                        actionTool.setIcon(actionInfo.getIconName());
                        actionTool.setPosition(actionInfo.getPosition());
                        actionTool.setName(actionInfo.getName());
                    }
                }
            }
            catch (ClassNotFoundException e) {
                logger.warn("Can't register actions of extension '" + extension.getClassName() + "'", (Throwable)e);
            }
        }
    }

    private void registerActions() {
        logger.info("registerActions");
        ActionInfoManager actionManager = PluginsLocator.getActionInfoManager();
        for (String pluginName : pluginsConfig.keySet()) {
            PluginConfig pluginConfig = (PluginConfig)pluginsConfig.get(pluginName);
            PluginServices pluginService = (PluginServices)pluginsServices.get(pluginName);
            PluginClassLoader loader = pluginService.getClassLoader();
            logger.info("registerActions of plugin '" + pluginName + "'.");
            Extensions extensionConfig = pluginConfig.getExtensions();
            Enumeration extensiones = extensionConfig.enumerateExtension();
            this.registerActionOfExtensions(actionManager, extensiones, loader);
            Enumeration skinSxtensiones = extensionConfig.enumerateSkinExtension();
            this.registerActionOfExtensions(actionManager, skinSxtensiones, loader);
            PopupMenus pluginPopupMenus = pluginConfig.getPopupMenus();
            if (pluginPopupMenus == null) continue;
            PopupMenu[] menus1 = pluginPopupMenus.getPopupMenu();
            for (int j = 0; j < menus1.length; ++j) {
                PopupMenu popupMenu = menus1[j];
                Enumeration menus2 = popupMenu.enumerateMenu();
                while (menus2.hasMoreElements()) {
                    Menu menu = (Menu)menus2.nextElement();
                    if (menu.getIs_separator()) continue;
                    if (menu.getName() == null) {
                        logger.info("Null name for popmenu '" + menu.getText() + "' in plugin " + pluginService.getPluginName());
                        continue;
                    }
                    ActionInfo actionInfo = actionManager.getAction(menu.getName());
                    if (actionInfo == null) continue;
                    menu.setActionCommand(actionInfo.getCommand());
                    menu.setTooltip(actionInfo.getTooltip());
                    menu.setIcon(actionInfo.getIconName());
                    menu.setPosition(actionInfo.getPosition());
                    menu.setText(actionInfo.getLabel());
                    menu.setKey(actionInfo.getAccelerator());
                }
            }
        }
    }

    private TreeSet<SortableMenu> getOrderedMenus() {
        TreeSet<SortableMenu> orderedMenus = new TreeSet<SortableMenu>(new MenuComparator());
        for (String pName : pluginsConfig.keySet()) {
            try {
                PluginServices ps = (PluginServices)pluginsServices.get(pName);
                PluginConfig pc = (PluginConfig)pluginsConfig.get(pName);
                org.gvsig.andami.plugins.config.generate.Extension[] exts = pc.getExtensions().getExtension();
                for (int j = 0; j < exts.length; ++j) {
                    if (!exts[j].getActive()) continue;
                    Menu[] menus = exts[j].getMenu();
                    for (int k = 0; k < menus.length; ++k) {
                        SortableMenu sm = new SortableMenu(ps.getClassLoader(), exts[j], menus[k]);
                        if (orderedMenus.contains(sm)) {
                            this.addError(Messages.getString("Launcher.Two_menus_with_the_same_position") + " - " + menus[k].getText() + " - " + exts[j].getClassName());
                        }
                        orderedMenus.add(sm);
                    }
                }
                SkinExtension[] skinExts = pc.getExtensions().getSkinExtension();
                for (int j = 0; j < skinExts.length; ++j) {
                    if (skinExts[j] == null) continue;
                    Menu[] menu = skinExts[j].getMenu();
                    for (int k = 0; k < menu.length; ++k) {
                        SortableMenu sm = new SortableMenu(ps.getClassLoader(), skinExts[j], menu[k]);
                        if (orderedMenus.contains(sm)) {
                            this.addError(Messages.getString("Launcher.Two_menus_with_the_same_position") + skinExts[j].getClassName());
                        }
                        orderedMenus.add(sm);
                    }
                }
            }
            catch (Throwable e) {
                this.addError("Error initializing menus of plugin '" + pName + "'", e);
            }
        }
        return orderedMenus;
    }

    private void installPluginsMenus() {
        logger.info("installPluginsMenus");
        TreeSet<SortableMenu> orderedMenus = this.getOrderedMenus();
        Iterator<SortableMenu> e = orderedMenus.iterator();
        while (e.hasNext()) {
            try {
                SortableMenu sm = e.next();
                logger.debug(sm.menu.getPosition() + ":" + sm.menu.getText() + ":" + sm.loader.getPluginName() + ":" + sm.extension.getClassName());
                frame.addMenu(sm.loader, sm.extension, sm.menu);
            }
            catch (Throwable ex) {
                this.addError(Messages.getString("Launcher.No_se_encontro_la_clase_de_la_extension"), ex);
            }
        }
    }

    public List<PluginMenuItem> getPluginMenuItems() {
        ArrayList<PluginMenuItem> menuItems = new ArrayList<PluginMenuItem>();
        TreeSet<SortableMenu> orderedMenus = this.getOrderedMenus();
        for (SortableMenu sm : orderedMenus) {
            PluginMenuItem item = new PluginMenuItem(sm.loader, sm.extension, sm.menu);
            menuItems.add(item);
        }
        return menuItems;
    }

    private List<ToolBar> getOrderedToolBars() {
        HashMap<String, ToolBar> toolbars = new HashMap<String, ToolBar>();
        for (Object pluginName : this.getOrdererPluginsNames()) {
            String string = "unknow";
            try {
                org.gvsig.andami.plugins.config.generate.Extension[] extensions;
                PluginConfig pc = (PluginConfig)pluginsConfig.get(pluginName);
                for (org.gvsig.andami.plugins.config.generate.Extension extension : extensions = pc.getExtensions().getExtension()) {
                    ToolBar[] extensionToolbars;
                    String string2 = extension.getClassName();
                    for (ToolBar toolbar : extensionToolbars = extension.getToolBar()) {
                        ToolBar previosToolbar = (ToolBar)toolbars.get(toolbar.getName());
                        if (previosToolbar != null) {
                            if (previosToolbar.hasPosition() || !toolbar.hasPosition()) continue;
                            toolbars.put(toolbar.getName(), toolbar);
                            continue;
                        }
                        toolbars.put(toolbar.getName(), toolbar);
                    }
                }
            }
            catch (Exception ex) {
                this.addError("Can't process tool-bars of extension '" + string + "'.", ex);
            }
        }
        for (Map.Entry entry : toolbars.entrySet()) {
            ToolBar toolBar = (ToolBar)entry.getValue();
            if (!toolBar.hasPosition() || toolBar.getPosition() >= 100) continue;
            toolBar.setPosition(toolBar.getPosition() + 11000);
        }
        ArrayList<ToolBar> toolBarsList = new ArrayList<ToolBar>(toolbars.values());
        Collections.sort(toolBarsList, new Comparator<ToolBar>(){

            @Override
            public int compare(ToolBar o1, ToolBar o2) {
                return Integer.compare(o1.getPosition(), o2.getPosition());
            }
        });
        return toolBarsList;
    }

    private void installPluginsControls() {
        logger.info("installPluginsControls (toolbars)");
        this.installPluginsControlsToToolsbar();
        this.installPluginsControlsToStatusbar();
    }

    private void installPluginsControlsToToolsbar() {
        HashMap toolsByToolbar = new HashMap();
        for (ToolBar toolBar : this.getOrderedToolBars()) {
            frame.addToolBar(toolBar.getName(), toolBar.getDescription(), toolBar.getPosition());
            ArrayList tools = new ArrayList();
            toolsByToolbar.put(toolBar.getName(), tools);
        }
        for (Map.Entry entry : pluginsConfig.entrySet()) {
            org.gvsig.andami.plugins.config.generate.Extension[] pluginExtensions;
            String pluginName = (String)entry.getKey();
            PluginConfig pluginConfig = (PluginConfig)entry.getValue();
            PluginServices plugin = (PluginServices)pluginsServices.get(pluginName);
            PluginClassLoader loader = plugin.getClassLoader();
            for (org.gvsig.andami.plugins.config.generate.Extension pluginExtension : pluginExtensions = pluginConfig.getExtensions().getExtension()) {
                ToolBar[] pluginToolbars;
                for (ToolBar pluginToolbar : pluginToolbars = pluginExtension.getToolBar()) {
                    SelectableTool[] selectableTools;
                    ActionTool[] actionTools;
                    for (ActionTool actionTool : actionTools = pluginToolbar.getActionTool()) {
                        List toolbar = (List)toolsByToolbar.get(pluginToolbar.getName());
                        toolbar.add(new SortableTool(loader, (SkinExtensionType)pluginExtension, pluginToolbar, actionTool));
                    }
                    for (SelectableTool selectableTool : selectableTools = pluginToolbar.getSelectableTool()) {
                        List toolbar = (List)toolsByToolbar.get(pluginToolbar.getName());
                        toolbar.add(new SortableTool(loader, (SkinExtensionType)pluginExtension, pluginToolbar, selectableTool));
                    }
                }
            }
        }
        for (Map.Entry entry : toolsByToolbar.entrySet()) {
            String toolbarName = (String)entry.getKey();
            List tools = (List)entry.getValue();
            Collections.sort(tools, new Comparator<SortableTool>(){

                @Override
                public int compare(SortableTool o1, SortableTool o2) {
                    return Long.compare(o1.getPosition(), o2.getPosition());
                }
            });
            for (SortableTool tool : tools) {
                try {
                    if (tool.actiontool != null) {
                        frame.addTool(tool.loader, tool.extension, tool.toolbar, tool.actiontool);
                        continue;
                    }
                    frame.addTool(tool.loader, tool.extension, tool.toolbar, tool.selectabletool);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void installPluginsControlsToStatusbar() {
        Iterator pluginNames = pluginsConfig.keySet().iterator();
        HashMap<org.gvsig.andami.plugins.config.generate.Extension, PluginServices> extensionPluginServices = new HashMap<org.gvsig.andami.plugins.config.generate.Extension, PluginServices>();
        TreeSet<org.gvsig.andami.plugins.config.generate.Extension> orderedExtensions = new TreeSet<org.gvsig.andami.plugins.config.generate.Extension>(new ExtensionComparator());
        while (pluginNames.hasNext()) {
            String pluginName = (String)pluginNames.next();
            try {
                PluginConfig pc = (PluginConfig)pluginsConfig.get(pluginName);
                PluginServices ps = (PluginServices)pluginsServices.get(pluginName);
                org.gvsig.andami.plugins.config.generate.Extension[] exts = pc.getExtensions().getExtension();
                for (int j = 0; j < exts.length; ++j) {
                    String cname = "unknow";
                    try {
                        cname = exts[j].getClassName();
                        if (!exts[j].getActive() || cname.equals(LibraryExtension.class.getName())) continue;
                        if (orderedExtensions.contains(exts[j])) {
                            this.addError(Messages.getString("Launcher.Two_extensions_with_the_same_priority") + cname);
                        }
                        orderedExtensions.add(exts[j]);
                        extensionPluginServices.put(exts[j], ps);
                        continue;
                    }
                    catch (Throwable e) {
                        this.addError("Error initializing controls of plugin '" + pluginName + "' extension '" + cname + "'", e);
                    }
                }
            }
            catch (Throwable e) {
                this.addError("Error initializing controls of plugin '" + pluginName + "'", e);
            }
        }
        for (org.gvsig.andami.plugins.config.generate.Extension ext : orderedExtensions) {
            String extName = "unknow";
            try {
                extName = ext.getClassName();
                PluginServices ps = (PluginServices)extensionPluginServices.get(ext);
                PluginClassLoader loader = ps.getClassLoader();
                ComboScale[] comboScaleArray = ext.getComboScale();
                for (int k = 0; k < comboScaleArray.length; ++k) {
                    String name;
                    org.gvsig.gui.beans.controls.comboscale.ComboScale combo = new org.gvsig.gui.beans.controls.comboscale.ComboScale();
                    String label = comboScaleArray[k].getLabel();
                    if (label != null) {
                        combo.setLabel(label);
                    }
                    if ((name = comboScaleArray[k].getName()) != null) {
                        combo.setName(name);
                    }
                    String[] elementsString = ((String)comboScaleArray[k].getElements()).split(";");
                    long[] elements = new long[elementsString.length];
                    for (int currentElem = 0; currentElem < elementsString.length; ++currentElem) {
                        try {
                            elements[currentElem] = Long.parseLong(elementsString[currentElem]);
                            continue;
                        }
                        catch (NumberFormatException nfex1) {
                            this.addError(ext.getClassName() + " -- " + Messages.getString("error_parsing_comboscale_elements"));
                            elements[currentElem] = 0L;
                        }
                    }
                    combo.setItems(elements);
                    try {
                        long value = Long.parseLong((String)comboScaleArray[k].getValue());
                        combo.setScale((double)value);
                    }
                    catch (NumberFormatException nfex2) {
                        this.addError(ext.getClassName() + " -- " + Messages.getString("error_parsing_comboscale_value"));
                    }
                    try {
                        frame.addStatusBarControl(loader.loadClass(ext.getClassName()), (IControl)combo);
                        continue;
                    }
                    catch (ClassNotFoundException e1) {
                        this.addError(Messages.getString("Launcher.error_getting_class_loader_for_status_bar_control"), e1);
                    }
                }
                ComboButton[] comboButtonArray = ext.getComboButton();
                for (int k = 0; k < comboButtonArray.length; ++k) {
                    ComboButtonElement[] elementList = comboButtonArray[k].getComboButtonElement();
                    org.gvsig.gui.beans.controls.combobutton.ComboButton combo = new org.gvsig.gui.beans.controls.combobutton.ComboButton();
                    String name = comboButtonArray[k].getName();
                    if (name != null) {
                        combo.setName(name);
                    }
                    for (int currentElement = 0; currentElement < elementList.length; ++currentElement) {
                        ComboButtonElement element = elementList[currentElement];
                        URL iconLocation = loader.getResource(element.getIcon());
                        if (iconLocation == null) {
                            this.addError(Messages.getString("Icon_not_found_") + element.getIcon());
                            continue;
                        }
                        ImageIcon icon = new ImageIcon(iconLocation);
                        JButton button = new JButton(icon);
                        combo.addButton(button);
                        button.setActionCommand(element.getActionCommand());
                    }
                    try {
                        frame.addStatusBarControl(loader.loadClass(ext.getClassName()), (IControl)combo);
                        continue;
                    }
                    catch (ClassNotFoundException e1) {
                        this.addError(Messages.getString("Launcher.error_getting_class_loader_for_status_bar_control"), e1);
                    }
                }
            }
            catch (Throwable e2) {
                this.addError("Error initializing tools and status bars of extension '" + extName + "'", e2);
            }
        }
    }

    private void updateAndamiConfig() {
        HashSet<String> olds = new HashSet<String>();
        Plugin[] plugins = andamiConfig.getPlugin();
        for (int i = 0; i < plugins.length; ++i) {
            olds.add(plugins[i].getName());
        }
        for (PluginServices ps : pluginsServices.values()) {
            if (olds.contains(ps.getPluginName())) continue;
            Plugin p = new Plugin();
            p.setName(ps.getPluginName());
            p.setUpdate(false);
            andamiConfig.addPlugin(p);
        }
    }

    private URL[] getPluginClasspathURLs(PluginConfig pluginConfig) {
        URL[] urls = null;
        String libfolderPath = pluginConfig.getLibraries().getLibraryDir();
        File libFolderFile = new File(pluginConfig.getPluginFolder(), libfolderPath);
        File[] files = libFolderFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toUpperCase().endsWith(".JAR") || pathname.getName().toUpperCase().endsWith(".ZIP");
            }
        });
        if (files == null) {
            urls = new URL[]{};
        } else {
            urls = new URL[files.length];
            for (int j = 0; j < files.length; ++j) {
                try {
                    urls[j] = new URL("file:" + files[j]);
                    continue;
                }
                catch (MalformedURLException e) {
                    logger.warn("Can't add file '" + files[j] + "' to the classpath of plugin '" + pluginConfig.getPluginName() + "'.");
                }
            }
        }
        return urls;
    }

    private OrderedPlugins getOrdererPluginsNames() {
        OrderedPlugins orderedPlugins = new OrderedPlugins(pluginsConfig, this.getDeprecatedPluginNames());
        return orderedPlugins;
    }

    private void loadPluginServices() {
        OrderedPlugins orderedPlugins = this.getOrdererPluginsNames();
        if (!orderedPlugins.getProblems().isEmpty()) {
            for (String problem : orderedPlugins.getProblems()) {
                logger.warn(problem);
            }
        }
        for (String pluginName : orderedPlugins) {
            PluginConfig config = (PluginConfig)pluginsConfig.get(pluginName);
            URL[] urls = this.getPluginClasspathURLs(config);
            ArrayList<PluginClassLoader> loaders = new ArrayList<PluginClassLoader>();
            for (Depends dependency : config.getDepends()) {
                String dependencyName = dependency.getPluginName();
                PluginServices dependencyPluginService = (PluginServices)pluginsServices.get(dependencyName);
                if (dependencyPluginService == null) {
                    if (dependency.getOptional()) {
                        logger.info("Procesing plugin '" + pluginName + ", optional dependency not found (" + dependencyName + ").");
                        continue;
                    }
                    logger.warn("Procesing plugin '" + pluginName + ", dependency not found (" + dependencyName + ").");
                    continue;
                }
                loaders.add(dependencyPluginService.getClassLoader());
            }
            try {
                PluginClassLoader loader = new PluginClassLoader(urls, config.getPluginFolder().getAbsolutePath(), Launcher.class.getClassLoader(), loaders);
                PluginServices ps = new PluginServices(loader, PluginsConfig.getAlternativeNames(config));
                logger.info("Plugin '" + pluginName + "' created");
                pluginsServices.put(ps.getPluginName(), ps);
                pluginsOrdered.add(pluginName);
            }
            catch (IOException ex) {
                logger.warn("Can't create PluginServices for '" + pluginName + "'.", (Throwable)ex);
            }
        }
        ArrayList<String> pluginsToRemove = new ArrayList<String>();
        for (String pluginName : pluginsConfig.keySet()) {
            PluginServices pluginService = (PluginServices)pluginsServices.get(pluginName);
            if (pluginService != null) continue;
            pluginsToRemove.add(pluginName);
        }
        for (String pluginName : pluginsToRemove) {
            logger.warn("Removed plugin " + pluginName + ".");
            pluginsConfig.remove(pluginName);
        }
    }

    private void pluginsMessages() {
        for (String pluginName : pluginsOrdered) {
            PluginConfig config = (PluginConfig)pluginsConfig.get(pluginName);
            PluginServices ps = (PluginServices)pluginsServices.get(pluginName);
            if (config.getResourceBundle() == null || config.getResourceBundle().getName().equals("")) continue;
            org.gvsig.i18n.Messages.addResourceFamily((String)config.getResourceBundle().getName(), (ClassLoader)ps.getClassLoader(), (String)pluginName);
            org.gvsig.i18n.Messages.addResourceFamily((String)("i18n." + config.getResourceBundle().getName()), (ClassLoader)ps.getClassLoader(), (String)pluginName);
        }
    }

    public static PluginServices getPluginServices(String name) {
        return (PluginServices)pluginsServices.get(name);
    }

    static String getPluginsDir() {
        return andamiConfig.getPluginsDirectory();
    }

    static File getPluginFolder(String pluginName) {
        return ((PluginConfig)pluginsConfig.get(pluginName)).getPluginFolder();
    }

    static void setPluginsDir(String s) {
        andamiConfig.setPluginsDirectory(s);
    }

    static MDIFrame getMDIFrame() {
        return frame;
    }

    private PluginsConfig loadPluginConfigs() {
        InstallerManager installerManager = InstallerLocator.getInstallerManager();
        List repositoriesFolders = installerManager.getLocalAddonRepositories("plugin");
        for (File repositoryFolder : repositoriesFolders) {
            logger.info("Loading plugins configuration from repository folder " + repositoryFolder.getAbsolutePath() + ".");
            if (!repositoryFolder.exists()) {
                logger.warn("Plugins repository folder not found '" + repositoryFolder.getAbsolutePath() + "'.");
                continue;
            }
            File[] pluginsFolders = repositoryFolder.listFiles();
            if (pluginsFolders.length == 0) {
                logger.info("Plugins repository folder is empty '" + repositoryFolder.getAbsolutePath() + "'.");
                continue;
            }
            for (int i = 0; i < pluginsFolders.length; ++i) {
                File pluginFolder = pluginsFolders[i];
                if (!pluginFolder.isDirectory()) continue;
                String pluginName = pluginFolder.getName();
                File pluginConfigFile = new File(pluginFolder, "config.xml");
                if (!pluginConfigFile.exists()) {
                    logger.info("Plugin '" + pluginName + "' not has a config.xml file (" + pluginConfigFile.getAbsolutePath() + ".");
                    continue;
                }
                try {
                    FileInputStream is = new FileInputStream(pluginConfigFile);
                    Reader xml = XMLEncodingUtils.getReader((InputStream)is);
                    xml = xml == null ? new FileReader(pluginConfigFile) : new BufferedReader(xml);
                    PluginConfig pluginConfig = (PluginConfig)PluginConfig.unmarshal(xml);
                    pluginConfig.setPluginName(pluginName);
                    pluginConfig.setPluginFolder(pluginFolder);
                    pluginsConfig.put(pluginName, pluginConfig);
                    continue;
                }
                catch (FileNotFoundException e) {
                    logger.info("Can't read plugin config file from plugin '" + pluginName + "' ('" + pluginConfigFile.getAbsolutePath() + ").");
                    continue;
                }
                catch (MarshalException e) {
                    logger.warn("Can't load plugin the config file from plugin '" + pluginName + "' is incorect. " + e.getMessage() + " ('" + pluginConfigFile.getAbsolutePath() + ").", (Throwable)e);
                    continue;
                }
                catch (ValidationException e) {
                    logger.warn("Can't load plugin the config file from plugin '" + pluginName + "' is invalid. " + e.getMessage() + " ('" + pluginConfigFile.getAbsolutePath() + ").", (Throwable)e);
                }
            }
        }
        return pluginsConfig;
    }

    private static Locale getLocale(String language, String country, String variant) {
        if (variant != null) {
            return new Locale(language, country, variant);
        }
        if (country != null) {
            return new Locale(language, country);
        }
        if (language != null) {
            return new Locale(language);
        }
        return new Locale("es");
    }

    private static void andamiConfigToXML(String file) throws IOException, MarshalException, ValidationException {
        File tmpFile = new File(file + "-" + DateTime.getCurrentDate().getTime());
        File xml = new File(file);
        File parent = xml.getParentFile();
        parent.mkdirs();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpFile));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, CASTORENCODING);
        andamiConfig.marshal(writer);
        writer.close();
        xml.delete();
        if (!tmpFile.renameTo(xml)) {
            FileChannel sourceChannel = new FileInputStream(tmpFile).getChannel();
            FileChannel destinationChannel = new FileOutputStream(xml).getChannel();
            sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
            sourceChannel.close();
            destinationChannel.close();
        }
    }

    private static void andamiConfigFromXML(String file) throws ConfigurationException {
        File xml = new File(file);
        InputStreamReader reader = null;
        try {
            reader = XMLEncodingUtils.getReader((File)xml);
            andamiConfig = (AndamiConfig)AndamiConfig.unmarshal(reader);
        }
        catch (FileNotFoundException e) {
            andamiConfig = Launcher.getDefaultAndamiConfig();
        }
        catch (MarshalException e) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            String backupFile = file + "-" + DateTime.getCurrentDate().getTime();
            NotificationManager.addError(Messages.getString("Error_reading_andami_config_New_file_created_A_backup_was_made_on_") + backupFile, new ConfigurationException(e));
            xml.renameTo(new File(backupFile));
            andamiConfig = Launcher.getDefaultAndamiConfig();
        }
        catch (ValidationException e) {
            throw new ConfigurationException(e);
        }
    }

    private static AndamiConfig getDefaultAndamiConfig() {
        AndamiConfig andamiConfig = new AndamiConfig();
        Andami andami = new Andami();
        andami.setUpdate(true);
        andamiConfig.setAndami(andami);
        andamiConfig.setLocaleCountry(Locale.getDefault().getCountry());
        andamiConfig.setLocaleLanguage(Locale.getDefault().getLanguage());
        andamiConfig.setLocaleVariant(Locale.getDefault().getVariant());
        if (System.getProperty("javawebstart.version") != null) {
            andamiConfig.setPluginsDirectory(new File(appHomeDir, "extensiones").getAbsolutePath());
        } else {
            andamiConfig.setPluginsDirectory(new File(appName, "extensiones").getAbsolutePath());
        }
        andamiConfig.setPlugin(new Plugin[0]);
        return andamiConfig;
    }

    private static XMLEntity persistenceFromXML() throws ConfigurationException {
        File xml = Launcher.getPluginsPersistenceFile(true);
        if (xml.exists()) {
            InputStreamReader reader = null;
            try {
                reader = XMLEncodingUtils.getReader((File)xml);
                XmlTag tag = (XmlTag)XmlTag.unmarshal((Reader)reader);
                return new XMLEntity(tag);
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException(e);
            }
            catch (MarshalException e) {
                try {
                    reader = new FileReader(xml);
                    XmlTag tag = (XmlTag)XmlTag.unmarshal((Reader)reader);
                    return new XMLEntity(tag);
                }
                catch (MarshalException ex) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    String backupFile = Launcher.getPluginsPersistenceFile(true).getPath() + "-" + DateTime.getCurrentDate().getTime();
                    NotificationManager.addError(Messages.getString("Error_reading_plugin_persinstence_New_file_created_A_backup_was_made_on_") + backupFile, new ConfigurationException(e));
                    xml.renameTo(new File(backupFile));
                    return new XMLEntity();
                }
                catch (FileNotFoundException ex) {
                    return new XMLEntity();
                }
                catch (ValidationException ex) {
                    throw new ConfigurationException(e);
                }
            }
            catch (ValidationException e) {
                throw new ConfigurationException(e);
            }
        }
        return new XMLEntity();
    }

    private static File getPluginsPersistenceFile(boolean read) {
        if (read) {
            File pluginsPersistenceFile = new File(Launcher.getAppHomeDir(), "plugins-persistence-2_0.xml");
            if (pluginsPersistenceFile.exists()) {
                return pluginsPersistenceFile;
            }
            pluginsPersistenceFile = new File(Launcher.getAppHomeDir(), "plugins-persistence.xml");
            if (pluginsPersistenceFile.exists()) {
                return pluginsPersistenceFile;
            }
        }
        return new File(Launcher.getAppHomeDir(), "plugins-persistence-2_0.xml");
    }

    private static void persistenceToXML(XMLEntity entity) throws ConfigurationException {
        File tmpFile = new File(Launcher.getPluginsPersistenceFile(false).getPath() + "-" + DateTime.getCurrentDate().getTime());
        File xml = Launcher.getPluginsPersistenceFile(false);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), CASTORENCODING);
            entity.getXmlTag().marshal((Writer)writer);
            writer.close();
            xml.delete();
            if (!tmpFile.renameTo(xml)) {
                FileChannel sourceChannel = new FileInputStream(tmpFile).getChannel();
                FileChannel destinationChannel = new FileOutputStream(xml).getChannel();
                sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
                sourceChannel.close();
                destinationChannel.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(e);
        }
        catch (MarshalException e) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (ValidationException e) {
            throw new ConfigurationException(e);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    static MDIFrame getFrame() {
        return frame;
    }

    public static synchronized void closeApplication() {
        TerminationProcess terminationProcess = new Launcher().new TerminationProcess();
        terminationProcess.run();
    }

    public static synchronized void closeApplication(boolean quietly) {
        TerminationProcess terminationProcess = new Launcher().new TerminationProcess();
        if (quietly) {
            terminationProcess.closeAndami();
        } else {
            terminationProcess.run();
        }
    }

    static HashMap getClassesExtensions() {
        return classesExtensions;
    }

    public static IExtension getExtensionByName(String extensionName) {
        if (StringUtils.isEmpty((CharSequence)extensionName)) {
            return null;
        }
        for (Map.Entry<Class<? extends IExtension>, ExtensionDecorator> entry : classesExtensions.entrySet()) {
            Class<? extends IExtension> extensionClass = entry.getKey();
            IExtension extension = entry.getValue();
            if (!extensionName.equals(extensionClass.getName())) continue;
            while (extension instanceof ExtensionDecorator) {
                extension = ((ExtensionDecorator)extension).getExtension();
            }
            return extension;
        }
        return null;
    }

    private static Extensions[] getExtensions() {
        ArrayList<Extensions> array = new ArrayList<Extensions>();
        Iterator iter = pluginsConfig.values().iterator();
        while (iter.hasNext()) {
            array.add(((PluginConfig)iter.next()).getExtensions());
        }
        return array.toArray(new Extensions[array.size()]);
    }

    public static Iterator getExtensionIterator() {
        return extensions.iterator();
    }

    public static HashMap getPluginConfig() {
        return pluginsConfig;
    }

    public static org.gvsig.andami.plugins.config.generate.Extension getExtension(String s) {
        Extensions[] exts = Launcher.getExtensions();
        for (int i = 0; i < exts.length; ++i) {
            for (int j = 0; j < exts[i].getExtensionCount(); ++j) {
                if (!exts[i].getExtension(j).getClassName().equals(s)) continue;
                return exts[i].getExtension(j);
            }
        }
        return null;
    }

    public static AndamiConfig getAndamiConfig() {
        return andamiConfig;
    }

    public static String getDefaultLookAndFeel() {
        String osName = System.getProperty("os.name");
        if (osName.length() > 4 && osName.substring(0, 5).toLowerCase().equals("linux")) {
            return nonWinDefaultLookAndFeel;
        }
        if (osName.toLowerCase().startsWith("mac os x")) {
            return "ch.randelshofer.quaqua.QuaquaLookAndFeel";
        }
        return UIManager.getSystemLookAndFeelClassName();
    }

    private static String normalizeLanguageCode(String langCode) {
        String fileName = "iso_639.tab";
        if (langCode.length() == 2) {
            return langCode;
        }
        if (langCode.length() == 3) {
            if (langCode.equals("va") || langCode.equals("val")) {
                return "ca";
            }
            URL isoCodes = Launcher.class.getClassLoader().getResource("iso_639.tab");
            if (isoCodes != null) {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(isoCodes.openStream(), "ISO-8859-1"));
                    while ((line = reader.readLine()) != null) {
                        String[] language = line.split("\t");
                        if (!language[0].equals(langCode)) continue;
                        return language[2];
                    }
                }
                catch (IOException ex) {
                    logger.error(Messages.getString("Error_reading_isocodes_file"), (Throwable)ex);
                    return "es";
                }
            } else {
                logger.error(Messages.getString("Error_reading_isocodes_file"));
                return "es";
            }
        }
        return "es";
    }

    private static void configureLocales() {
        String localeStr = null;
        localeStr = Launcher.getArguments().contains("language") ? Launcher.getArguments().get("language") : andamiConfig.getLocaleLanguage();
        localeStr = Launcher.normalizeLanguageCode(localeStr);
        locale = Launcher.getLocale(localeStr, andamiConfig.getLocaleCountry(), andamiConfig.getLocaleVariant());
        org.gvsig.i18n.Messages.setCurrentLocale((Locale)locale);
        JComponent.setDefaultLocale(locale);
        File appI18nFolder = new File(Launcher.getApplicationFolder(), "i18n");
        File userI18nFolder = new File(Launcher.getAppHomeDir(), "i18n");
        if (!userI18nFolder.exists()) {
            try {
                FileUtils.forceMkdir((File)userI18nFolder);
            }
            catch (IOException e) {
                logger.info("Can't create i18n folder in gvSIG home (" + userI18nFolder + ").", (Throwable)e);
            }
        }
        URL[] i18nURLs = Launcher.getURLsFromI18nFolders(userI18nFolder, appI18nFolder);
        URLClassLoader i18nClassLoader = URLClassLoader.newInstance(i18nURLs, null);
        logger.info("loading resources from classloader " + i18nClassLoader.toString() + ".");
        org.gvsig.i18n.Messages.addResourceFamily((String)"text", (ClassLoader)i18nClassLoader, (String)"Andami Launcher");
        org.gvsig.i18n.Messages.addResourceFamily((String)"org.gvsig.andami.text", (String)"Andami Launcher");
    }

    private static URL[] getURLsFromI18nFolders(File userFolder, File appFolder) {
        ArrayList<URL> urls = new ArrayList<URL>();
        File[] files = new File[]{userFolder, appFolder};
        for (int n1 = 0; n1 < files.length; ++n1) {
            File folder = files[n1];
            File[] subFiles = folder.listFiles();
            for (int n2 = 0; n2 < subFiles.length; ++n2) {
                File subFolder = subFiles[n2];
                if ("andami".equalsIgnoreCase(subFolder.getName()) || !subFolder.isDirectory()) continue;
                try {
                    urls.add(subFolder.toURI().toURL());
                    continue;
                }
                catch (MalformedURLException ex) {
                    logger.warn("Can't convert file to url (file=" + subFolder.getAbsolutePath() + ").", (Throwable)ex);
                    return null;
                }
            }
        }
        File folder = new File(appFolder, "andami");
        try {
            urls.add(folder.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            logger.warn("Can't convert file to url (file=" + folder.getAbsolutePath() + ").", (Throwable)ex);
            return null;
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static String getAppHomeDir() {
        return appHomeDir;
    }

    public static File getApplicationHomeFolder() {
        return new File(Launcher.getAppHomeDir());
    }

    public static void setAppHomeDir(String appHomeDir) {
        Launcher.appHomeDir = appHomeDir;
    }

    private static void initializeExclusiveUIExtension() {
        String name = PluginServices.getArgumentByName("exclusiveUI");
        if (name == null) {
            return;
        }
        for (Class<? extends IExtension> key : classesExtensions.keySet()) {
            int charIndex = key.getName().indexOf(name);
            if (charIndex != 0) continue;
            IExtension ext = classesExtensions.get(key);
            if (ext instanceof ExtensionDecorator) {
                ext = ((ExtensionDecorator)ext).getExtension();
            }
            if (!(ext instanceof ExclusiveUIExtension)) break;
            PluginServices.setExclusiveUIExtension((ExclusiveUIExtension)ext);
            break;
        }
        logger.error(Messages.getString("No_se_encontro_la_extension_especificada_en_el_parametro_exclusiveUI") + " '" + name + "'");
    }

    public static void initIconThemes() {
        double scaleFactor;
        IconTheme iconTheme;
        PluginsManager pluginsManager = PluginsLocator.getManager();
        IconThemeManager iconManager = ToolsSwingLocator.getIconThemeManager();
        File f = new File(pluginsManager.getApplicationHomeFolder(), "icon-theme");
        if (!f.exists()) {
            try {
                f.mkdir();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        iconManager.getRepository().add(f, "_User");
        f = new File(pluginsManager.getApplicationFolder(), "icon-theme");
        if (!f.exists()) {
            try {
                f.mkdir();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        iconManager.getRepository().add(f, "_Global");
        Preferences prefs = Preferences.userRoot().node("gvsig.icontheme");
        String defaultThemeID = prefs.get("default-theme", DEFAULT_ICON_THEME_NAME);
        if (defaultThemeID != null && (iconTheme = iconManager.get(defaultThemeID)) != null) {
            iconManager.setCurrent(iconTheme);
        }
        try {
            scaleFactor = prefs.getDouble("scaleFactor", 1.0);
        }
        catch (Throwable th) {
            scaleFactor = 1.0;
        }
        iconManager.setScaleFactor(scaleFactor);
    }

    public static void manageUnsavedData(String prompt) throws Exception {
        UnsavedDataPanel panel = new UnsavedDataPanel(prompt);
        List<IUnsavedData> unsavedData = PluginsLocator.getManager().getUnsavedData();
        panel.setUnsavedData(unsavedData);
        panel.addActionListener(new UnsavedDataPanel.UnsavedDataPanelListener(panel){

            @Override
            public void cancel(UnsavedDataPanel panel) {
                panel.setVisible(false);
            }

            @Override
            public void discard(UnsavedDataPanel panel) {
                panel.setVisible(false);
            }

            @Override
            public void accept(UnsavedDataPanel panel) {
                panel.setVisible(false);
                try {
                    PluginsLocator.getManager().saveUnsavedData(panel.getSelectedsUnsavedDataList());
                }
                catch (UnsavedDataException e) {
                    logger.warn("Can't save resources.", (Throwable)((Object)e));
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    StringBuilder msg = new StringBuilder();
                    msg.append(i18n.getTranslation("The_following_resources_could_not_be_saved"));
                    msg.append("\n");
                    for (IUnsavedData unsavedData : e.getUnsavedData()) {
                        msg.append(unsavedData.getResourceName());
                        msg.append(" -- ");
                        msg.append(unsavedData.getDescription());
                        msg.append("\n");
                    }
                    JOptionPane.showMessageDialog(panel, msg, i18n.getTranslation("Resources_was_not_saved"), 0);
                }
            }
        });
        ToolsSwingLocator.getWindowManager().showWindow((JComponent)panel, PluginServices.getText(panel, "Resource_was_not_saved"), WindowManager.MODE.DIALOG);
    }

    public static TerminationProcess getTerminationProcess() {
        return new Launcher().new TerminationProcess();
    }

    private PackageInfo getPackageInfo(String pluginsFolder) {
        try {
            PluginsManager pm = PluginsLocator.getManager();
            return pm.getPackageInfo();
        }
        catch (Exception e) {
            logger.info("Can't locate PackageInfo from plugin org.gvsig.app", (Throwable)e);
            return null;
        }
    }

    private void doInstall(String[] args) throws Exception {
        String installURL = null;
        String installURLFile = null;
        String gvSIGVersion = null;
        String[] myArgs = new String[3];
        PackageInfo packageInfo = null;
        Options options = new Options();
        options.addOption("i", "install", false, "install");
        options.addOption("u", "installURL", true, "installURL");
        options.addOption("f", "installURLFile", true, "installURLFile");
        options.addOption("v", "installVersion", true, "installVersion");
        options.addOption("A", "applicationName", true, "application name, default is gvSIG");
        options.addOption("P", "pluginsFolder", true, "pluginsFolder");
        options.addOption("l", "language", true, "language");
        options.addOption(null, "debug", false, "Activate the JVM remote debug");
        options.addOption(null, "pause", false, "Pause when activate JVM debug");
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            boolean hasAllMandatoryOptions = true;
            if (!line.hasOption("install")) {
                hasAllMandatoryOptions = false;
            }
            if (line.hasOption("installVersion")) {
                gvSIGVersion = line.getOptionValue("installVersion");
            }
            myArgs[0] = line.hasOption("applicationName") ? line.getOptionValue("applicationName") : "gvSIG";
            myArgs[1] = line.hasOption("pluginsFolder") ? line.getOptionValue("pluginsFolder") : "gvSIG/extensiones";
            myArgs[2] = line.hasOption("language") ? "language=" + line.getOptionValue("language") : Locale.getDefault().toString();
            installURL = line.hasOption("installURL") ? line.getOptionValue("installURL") : "http://downloads.gvsig.org/download/gvsig-desktop-testing/";
            installURLFile = line.hasOption("installURLFile") ? line.getOptionValue("installURLFile") : "gvsig-installer-urls.config";
            if (!hasAllMandatoryOptions) {
                System.err.println(Messages.get("usage") + ": Launcher " + "--install " + "[--applicationName=appName] " + "[--pluginsFolder=plugins-directory] " + "[--installURLFile=File] " + "[--installURL=URL] " + "[--language=locale]");
                return;
            }
        }
        catch (ParseException exp) {
            System.err.println("Unexpected exception:" + exp.getMessage());
            System.exit(-1);
        }
        this.initializeApp(myArgs, "installer");
        new DefaultLibrariesInitializer().fullInitialize(true);
        try {
            Launcher.initIconThemes();
        }
        catch (Exception ex) {
            this.addError("Can't initialize icon theme", ex);
        }
        this.initializeInstallerManager();
        InstallerManager installerManager = InstallerLocator.getInstallerManager();
        try {
            logger.info("Loading plugins configurations");
            this.loadPluginConfigs();
        }
        catch (Throwable ex) {
            logger.warn("Can't load plugins configurations", ex);
        }
        try {
            logger.info("Loading plugins");
            this.loadPluginServices();
        }
        catch (Throwable ex) {
            logger.warn("Can't load plugins", ex);
        }
        AndamiConfig config = Launcher.getAndamiConfig();
        this.initializeIdentityManagement(new File(config.getPluginsDirectory()).getAbsoluteFile());
        this.initializeLibraries();
        packageInfo = this.getPackageInfo(myArgs[1]);
        if (packageInfo != null) {
            installerManager.setVersion(packageInfo.getVersion());
        } else {
            installerManager.setVersion(gvSIGVersion);
        }
        if (!installURL.contains(";") && !installURL.endsWith(".gvspkg") && !installURL.endsWith(".gvspki") && packageInfo != null && (packageInfo.getState().startsWith("beta") || packageInfo.getState().startsWith("RC") || packageInfo.getState().equalsIgnoreCase("final"))) {
            installURL = installURL + "dists/<%Version%>/builds/<%Build%>/packages.gvspki ## Current build";
        }
        SwingInstallerLocator.getSwingInstallerManager().setDefaultDownloadURL(installURL);
        SwingInstallerLocator.getSwingInstallerManager().setDefaultDownloadURL(new File(installURLFile));
        PluginsManager manager = PluginsLocator.getManager();
        InstallWizardPanel installPackageWizard = SwingInstallerLocator.getSwingInstallerManager().createInstallPackageWizard(manager.getApplicationFolder(), manager.getInstallFolder());
        installPackageWizard.setWizardActionListener(new InstallerWizardActionListener(){

            public void finish(InstallerWizardPanel installerWizard) {
                logger.info("Finish installation.");
                System.exit(0);
            }

            public void cancel(InstallerWizardPanel installerWizard) {
                logger.info("Cancel installation.");
                System.exit(0);
            }
        });
        installPackageWizard.setSkipTypicalOrAdvancedWizardPage(false);
        installPackageWizard.setSelectDefaultPackages(true);
        JFrame frame = new JFrame(Messages.get("gvsig_package_installer"));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                logger.info("Closing installation.");
                System.exit(0);
            }

            @Override
            public void windowClosed(WindowEvent we) {
                logger.info("Close installation.");
                System.exit(0);
            }
        });
        frame.getContentPane().add((Component)installPackageWizard.asJComponent(), "Center");
        URL iconURL = this.getClass().getResource("/images/main/install-icon.png");
        if (iconURL != null) {
            ImageIcon icon = new ImageIcon(iconURL);
            frame.setIconImage(icon.getImage());
        }
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static String getInformation() {
        return Launcher.getInformation(null);
    }

    public static String getInformation(PackageInfo[] pkgs) {
        StringWriter writer;
        String template = "OS\n    name    : {0}\n    arch    : {1}\n    version : {2} \n{3}JRE\n    vendor  : {4}\n    version : {5}\n    home    : {6}\nHTTP Proxy\n    http.proxyHost     : {7}\n    http.proxyPort     : {8}\n    http.proxyUserName : {9}\n    http.proxyPassword : {10}\nApplication\n    locale language         : {11}\n    application forlder     : {12}\n    application home forlder: {13}\n    install forlder         : {14}\n    plugins forlder         : {15}\n    theme                   : {16}\n    Skin                    : {17}\n    temp forlder            : {19}\nInstalled packages\n{18}";
        String[] values = new String[20];
        PluginsManager pluginmgr = PluginsLocator.getManager();
        LocaleManager localemgr = PluginsLocator.getLocaleManager();
        Properties props = System.getProperties();
        values[0] = props.getProperty("os.name");
        values[1] = props.getProperty("os.arch");
        values[2] = props.getProperty("os.version");
        if (values[0].startsWith("Linux")) {
            try {
                String line;
                writer = new StringWriter();
                String[] command = new String[]{"lsb_release", "-a"};
                Process p = Runtime.getRuntime().exec(command);
                InputStream is = p.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                while ((line = reader.readLine()) != null) {
                    writer.write("    " + line + "\n");
                }
                values[3] = writer.toString();
            }
            catch (Exception ex) {
                logger.warn("Can't get detailled os information (lsb_release -a).", (Throwable)ex);
            }
        }
        values[4] = props.getProperty("java.vendor");
        values[5] = props.getProperty("java.version");
        values[6] = props.getProperty("java.home");
        values[7] = props.getProperty("http.proxyHost");
        values[8] = props.getProperty("http.proxyPort");
        values[9] = props.getProperty("http.proxyUserName");
        values[10] = props.get("http.proxyPassword") == null ? "(null)" : "***********";
        try {
            values[17] = MDIManagerFactory.getSkinExtension().getClassName();
        }
        catch (Throwable e) {
            values[17] = "(unknow)";
        }
        values[19] = ToolsLocator.getFoldersManager().getTemporaryFolder().getAbsolutePath();
        values[11] = localemgr.getCurrentLocale().toString();
        values[12] = pluginmgr.getApplicationFolder().getAbsolutePath();
        values[13] = pluginmgr.getApplicationHomeFolder().getAbsolutePath();
        values[14] = pluginmgr.getInstallFolder().getAbsolutePath();
        values[15] = StringUtils.join((Object[])new List[]{pluginmgr.getPluginsFolders()});
        values[16] = theme.getSource().getAbsolutePath();
        try {
            if (pkgs == null) {
                InstallerManager installmgr = InstallerLocator.getInstallerManager();
                pkgs = installmgr.getInstalledPackages();
            }
            writer = new StringWriter();
            for (PackageInfo pkg : pkgs) {
                writer.write("    ");
                writer.write(pkg.toStringCompact());
                writer.write("\n");
            }
            values[18] = writer.toString();
        }
        catch (Throwable e) {
            logger.warn("Can't get installed package information.", e);
        }
        String s = MessageFormat.format(template, values);
        return s;
    }

    private void logger_info(String msg) {
        String[] info;
        for (String info1 : info = msg.split("\n")) {
            logger.info(info1);
        }
    }

    private void saveEnvironInformation(PackageInfo[] pkgs) {
        PluginsManager manager = PluginsLocator.getManager();
        File fout = new File(manager.getApplicationHomeFolder(), "gvSIG-environ.info");
        try {
            FileUtils.write((File)fout, (CharSequence)Launcher.getInformation(pkgs));
        }
        catch (IOException e) {
            logger.info("Can't create '" + fout.getAbsolutePath() + "'");
        }
    }

    private void fixIncompatiblePlugins(PackageInfo[] installedPackages) {
        HashSet<String> incompatiblePlugins = new HashSet<String>();
        HashMap<String, PackageInfo> packages = new HashMap<String, PackageInfo>();
        for (int i = 0; i < installedPackages.length; ++i) {
            packages.put(installedPackages[i].getCode(), installedPackages[i]);
        }
        Iterator it = pluginsConfig.entrySet().iterator();
        while (it.hasNext()) {
            ArrayList<Object> pluginNames = new ArrayList<Object>();
            Map.Entry entry = it.next();
            PluginConfig pluginConfig = (PluginConfig)entry.getValue();
            pluginNames.add(entry.getKey());
            String[] aliases = pluginsConfig.getAliases(pluginConfig);
            if (aliases != null) {
                for (int i = 0; i < aliases.length; ++i) {
                    pluginNames.add(aliases[i]);
                }
            }
            PackageInfo pkg = null;
            for (int n = 0; n < pluginNames.size() && (pkg = (PackageInfo)packages.get(pluginNames.get(n))) == null; ++n) {
            }
            if (pkg == null) continue;
            Dependencies dependencies = pkg.getDependencies();
            for (int i = 0; i < dependencies.size(); ++i) {
                String code;
                Dependency dependency = (Dependency)dependencies.get(i);
                if (!"conflict".equalsIgnoreCase(dependency.getType()) || pluginsConfig.get(code = dependency.getCode()) == null) continue;
                incompatiblePlugins.add(pkg.getCode());
                incompatiblePlugins.add(code);
            }
        }
        if (incompatiblePlugins.isEmpty()) {
            return;
        }
        splashWindow.toBack();
        DisablePluginsConflictingDialog dlg = new DisablePluginsConflictingDialog(packages, incompatiblePlugins);
        dlg.setVisible(true);
        splashWindow.toFront();
        switch (dlg.getAction()) {
            case 1: {
                System.exit(0);
                break;
            }
        }
        List<String> pluginsToDissable = dlg.getPluginNamesToDisable();
        if (pluginsToDissable == null) {
            return;
        }
        for (String pluginName : pluginsToDissable) {
            logger.info("Dissabling plugin '" + pluginName + "' by user action.");
            pluginsConfig.remove(pluginName);
        }
    }

    private void initializeIdentityManagement(File pluginsFolder) {
        File identityManagementConfigFile = null;
        PluginServices plugin = null;
        for (Map.Entry entry : pluginsConfig.entrySet()) {
            File pluginFolder = ((PluginConfig)entry.getValue()).getPluginFolder();
            File f = new File(pluginFolder, "identity-management.ini");
            if (!f.exists()) continue;
            if (identityManagementConfigFile != null) {
                logger.warn("Too many identity-managemnt plugins. Disable all.");
                continue;
            }
            identityManagementConfigFile = f;
            plugin = PluginServices.getPluginServices((String)entry.getKey());
        }
        if (plugin != null) {
            new DefaultLibrariesInitializer((ClassLoader)plugin.getClassLoader()).fullInitialize(true);
        }
        if (identityManagementConfigFile == null || plugin == null) {
            return;
        }
        if (!identityManagementConfigFile.canRead()) {
            return;
        }
        PropertiesConfiguration identityManagementConfig = null;
        try {
            identityManagementConfig = new PropertiesConfiguration(identityManagementConfigFile);
        }
        catch (Exception ex) {
            logger.warn("Can't open identity management config file '" + identityManagementConfigFile.getAbsolutePath() + "'.", (Throwable)ex);
            return;
        }
        String identityManagerClassName = identityManagementConfig.getString("IdentityManager", null);
        String identityManagementInitializerClassName = identityManagementConfig.getString("IdentityManagementInitializer", null);
        try {
            if (identityManagerClassName != null) {
                Class<?> identityManagerClass = plugin.getClassLoader().loadClass(identityManagerClassName);
                ToolsLocator.registerIdentityManager(identityManagerClass);
            } else {
                logger.info("Entry IdentityManager not found in identity management config file '" + identityManagementConfigFile.getAbsolutePath() + "'.");
            }
            if (identityManagementInitializerClassName != null) {
                Class<?> identityManagerInitializerClass = plugin.getClassLoader().loadClass(identityManagementInitializerClassName);
                Runnable identityManagerInitializer = (Runnable)identityManagerInitializerClass.newInstance();
                identityManagerInitializer.run();
            } else {
                logger.info("Entry IdentityManagementInitializer not found in identity management config file '" + identityManagementConfigFile.getAbsolutePath() + "'.");
            }
        }
        catch (Exception ex) {
            logger.warn("Can't initialize the identity manager from '" + identityManagementConfigFile.getAbsolutePath() + ".", (Throwable)ex);
            return;
        }
        logger.info("Loaded an identity manager from plugin '" + plugin.getPluginName() + ".");
    }

    static {
        logger = LoggerFactory.getLogger((String)Launcher.class.getName());
        prefs = Preferences.userRoot().node("gvsig.connection");
        pluginsConfig = new PluginsConfig();
        pluginsServices = new PluginsServices();
        classesExtensions = new HashMap();
        pluginsOrdered = new ArrayList<String>();
        extensions = new ArrayList<IExtension>();
        appHomeDir = null;
        launcherrors = null;
        theme = null;
    }

    private class DisablePluginsConflictingDialog
    extends JDialog {
        public static final int CONTINUE = 0;
        public static final int CLOSE = 1;
        private DisablePluginsConflictingLayoutPanel contents;
        private int action;
        private List<Item> incompatiblePlugins;
        private Map<String, PackageInfo> packages;

        DisablePluginsConflictingDialog(Map<String, PackageInfo> packages, Set<String> incompatiblePlugins) {
            super((Frame)null, "", true);
            this.action = 0;
            this.incompatiblePlugins = null;
            this.setTitle(this.translate("_Conflicting_plugins"));
            this.packages = packages;
            this.incompatiblePlugins = new ArrayList<Item>();
            Item item = null;
            for (String code : incompatiblePlugins) {
                item = new Item(code, packages.get(code));
                this.incompatiblePlugins.add(item);
                logger.info("Found plugin '" + item.getCode() + "' incopatibles with each other.");
            }
            this.initComponents();
        }

        private void initComponents() {
            this.contents = new DisablePluginsConflictingLayoutPanel();
            this.doTranslations();
            this.contents.buttonClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DisablePluginsConflictingDialog.this.doClose();
                }
            });
            this.contents.buttonContinue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    DisablePluginsConflictingDialog.this.doContinue();
                }
            });
            this.contents.pluginList.setModel(new DefaultListModel(this.incompatiblePlugins));
            ListSelectionModel sm = this.contents.pluginList.getSelectionModel();
            sm.setSelectionMode(2);
            this.setContentPane(this.contents);
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
        }

        private void doTranslations() {
            DisablePluginsConflictingLayoutPanel c = this.contents;
            c.lblConflict.setText(this.translate("_Some_of_plugins_installed_conflict_with_each_other"));
            c.lblSelectPluginToDisable.setText(this.translate("_Select_the_plugins_that_you_want_to_disable_and_click_the_continue_button"));
            c.lblClickContinue.setText(this.translate("_You_can_click_on_continue_button_directly_if_you_dont_want_to_disable_any_plugins"));
            c.lblClickClose.setText(this.translate("_Or_click_the_close_button_to_close_the_application"));
            c.buttonClose.setText(this.translate("_Close"));
            c.buttonContinue.setText(this.translate("_Continue"));
        }

        private String translate(String msg) {
            return PluginServices.getText(this, msg);
        }

        private void doClose() {
            this.action = 1;
            this.setVisible(false);
        }

        private void doContinue() {
            this.action = 0;
            this.setVisible(false);
        }

        public int getAction() {
            return this.action;
        }

        public List<String> getPluginNamesToDisable() {
            if (this.action == 1) {
                return null;
            }
            Object[] selecteds = null;
            selecteds = this.contents.pluginList.getSelectedValues();
            if (selecteds == null || selecteds.length < 1) {
                return null;
            }
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < selecteds.length; ++i) {
                values.add(((Item)selecteds[i]).getCode());
            }
            return values;
        }

        private class Item {
            private String code;
            private PackageInfo pkg;

            public Item(String code, PackageInfo pkg) {
                this.code = code;
                this.pkg = pkg;
            }

            public String toString() {
                if (this.pkg == null) {
                    return this.code;
                }
                return this.pkg.getName() + " (" + this.pkg.getCode() + ")";
            }

            public String getCode() {
                if (this.pkg == null) {
                    return this.code;
                }
                return this.pkg.getCode();
            }
        }
    }

    public class TerminationProcess {
        private boolean proceed = false;
        private UnsavedDataPanel panel = null;

        public void run() {
            try {
                int exit = this.manageUnsavedData();
                if (exit == 1 || exit == -1) {
                    return;
                }
                this.closeAndami();
            }
            catch (Exception e) {
                logger.warn("It is not possible to close the application", (Throwable)e);
            }
        }

        public void closeAndami() {
            PluginsManager pluginsManager = PluginsLocator.getManager();
            pluginsManager.executeShutdownTasks();
            try {
                this.saveAndamiConfig();
            }
            catch (Exception ex) {
                logger.error("There was an error exiting application, can't save andami-config.xml", (Throwable)ex);
            }
            try {
                Launcher.this.savePluginPersistence();
                this.savePluginsProperties();
            }
            catch (Exception ex) {
                logger.error("There was an error exiting application, can't save plugins properties", (Throwable)ex);
            }
            this.finalizeExtensions();
            try {
                Utilities.cleanUpTempFiles();
            }
            catch (Exception ex) {
                logger.error("There was an error exiting application, can't remove temporary files", (Throwable)ex);
            }
            logger.info("Quiting application.");
            System.gc();
            System.exit(0);
        }

        public void saveAndamiConfig() {
            try {
                Launcher.andamiConfigToXML(andamiConfigPath);
            }
            catch (MarshalException e) {
                logger.error(Messages.getString("Launcher.No_se_pudo_guardar_la_configuracion_de_andami"), (Throwable)e);
            }
            catch (ValidationException e) {
                logger.error(Messages.getString("Launcher.No_se_pudo_guardar_la_configuracion_de_andami"), (Throwable)e);
            }
            catch (IOException e) {
                logger.error(Messages.getString("Launcher.No_se_pudo_guardar_la_configuracion_de_andami"), (Throwable)e);
            }
        }

        private void savePluginsProperties() {
            PluginsManager manager = PluginsLocator.getManager();
            List<PluginServices> plugins = manager.getPlugins();
            for (PluginServices plugin : plugins) {
                if (plugin == null) continue;
                plugin.savePluginProperties();
            }
        }

        private void finalizeExtensions() {
            for (int i = extensions.size() - 1; i >= 0; --i) {
                IExtension extensionInstance = extensions.get(i);
                String extensionName = "(unknow)";
                try {
                    extensionName = extensionInstance.getClass().getName();
                    extensionInstance.terminate();
                    continue;
                }
                catch (Exception ex) {
                    logger.error(MessageFormat.format("There was an error extension ending {0}", extensionName), (Throwable)ex);
                }
            }
        }

        private IUnsavedData[] getUnsavedData() throws Exception {
            ArrayList<IUnsavedData> unsavedDataList = new ArrayList<IUnsavedData>();
            ExclusiveUIExtension exclusiveExtension = PluginServices.getExclusiveUIExtension();
            for (int i = extensions.size() - 1; i >= 0; --i) {
                IExtension extensionInstance = extensions.get(i);
                IExtensionStatus status = null;
                status = exclusiveExtension != null ? exclusiveExtension.getStatus(extensionInstance) : extensionInstance.getStatus();
                if (status == null) continue;
                try {
                    if (!status.hasUnsavedData()) continue;
                    IUnsavedData[] array = status.getUnsavedData();
                    for (int element = 0; element < array.length; ++element) {
                        unsavedDataList.add(array[element]);
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.info("Error calling the hasUnsavedData method", (Throwable)new Exception());
                    int option = JOptionPane.showConfirmDialog(frame, Messages.getString("error_getting_unsaved_data"), Messages.getString("MDIFrame.salir"), 0);
                    if (option != 1) continue;
                    throw e;
                }
            }
            return unsavedDataList.toArray(new IUnsavedData[unsavedDataList.size()]);
        }

        public UnsavedDataPanel getUnsavedDataPanel() {
            if (this.panel == null) {
                this.panel = new UnsavedDataPanel(new IUnsavedData[0]);
            }
            return this.panel;
        }

        public int manageUnsavedData() throws Exception {
            IUnsavedData[] unsavedData = this.getUnsavedData();
            if (unsavedData.length == 0) {
                int option = JOptionPane.showConfirmDialog(frame, Messages.getString("MDIFrame.quiere_salir"), Messages.getString("MDIFrame.salir"), 0);
                return option;
            }
            UnsavedDataPanel panel = this.getUnsavedDataPanel();
            panel.setUnsavedDataArray(unsavedData);
            panel.addActionListener(new UnsavedDataPanel.UnsavedDataPanelListener(panel){

                @Override
                public void cancel(UnsavedDataPanel panel) {
                    TerminationProcess.this.proceed(false);
                    PluginServices.getMDIManager().closeWindow(panel);
                }

                @Override
                public void discard(UnsavedDataPanel panel) {
                    TerminationProcess.this.proceed(true);
                    PluginServices.getMDIManager().closeWindow(panel);
                }

                @Override
                public void accept(UnsavedDataPanel panel) {
                    IUnsavedData[] unsavedDataArray = panel.getSelectedsUnsavedData();
                    for (int i = 0; i < unsavedDataArray.length; ++i) {
                        boolean saved;
                        try {
                            saved = unsavedDataArray[i].saveData();
                        }
                        catch (Exception ex) {
                            PluginServices.getLogger().error("Error saving" + unsavedDataArray[i].getResourceName(), (Throwable)ex);
                            saved = false;
                        }
                        if (saved) continue;
                        JOptionPane.showMessageDialog(panel, PluginServices.getText(this, "The_following_resource_could_not_be_saved_") + "\n" + unsavedDataArray[i].getResourceName() + " -- " + unsavedDataArray[i].getDescription(), PluginServices.getText(this, "unsaved_resources"), 0);
                        try {
                            unsavedDataArray = TerminationProcess.this.getUnsavedData();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        panel.setUnsavedDataArray(unsavedDataArray);
                        return;
                    }
                    TerminationProcess.this.proceed(true);
                    PluginServices.getMDIManager().closeWindow(panel);
                }
            });
            PluginServices.getMDIManager().addWindow(panel);
            if (this.proceed) {
                return 0;
            }
            return 1;
        }

        private void proceed(boolean proceed) {
            this.proceed = proceed;
        }
    }

    private static class ToolComparator
    implements Comparator<SortableTool> {
        private static ToolBarComparator toolBarComp = new ToolBarComparator();

        private ToolComparator() {
        }

        @Override
        public int compare(SortableTool e1, SortableTool e2) {
            long result = toolBarComp.compare(e1, e2);
            if (result != 0L) {
                return result > 0L ? 1 : -1;
            }
            long e1Position = -1L;
            long e2Position = -1L;
            if (e1.actiontool != null) {
                if (e1.actiontool.hasPosition()) {
                    e1Position = e1.actiontool.getPosition();
                }
            } else if (e1.selectabletool != null && e1.selectabletool.hasPosition()) {
                e1Position = e1.selectabletool.getPosition();
            }
            if (e2.actiontool != null) {
                if (e2.actiontool.hasPosition()) {
                    e2Position = e2.actiontool.getPosition();
                }
            } else if (e2.selectabletool != null && e2.selectabletool.hasPosition()) {
                e2Position = e2.selectabletool.getPosition();
            }
            if (e1Position == -1L && e2Position != -1L) {
                return 1;
            }
            if (e1Position != -1L && e2Position == -1L) {
                return -1;
            }
            if (e1Position != -1L && e2Position != -1L && (result = e1Position - e2Position) != 0L) {
                return result > 0L ? 1 : -1;
            }
            return e1.toString().compareTo(e2.toString());
        }
    }

    private static class ToolBarComparator
    implements Comparator<SortableTool> {
        private static ExtensionComparator extComp = new ExtensionComparator();

        private ToolBarComparator() {
        }

        @Override
        public int compare(SortableTool e1, SortableTool e2) {
            if (e1.toolbar.getName().equals(e2.toolbar.getName())) {
                return 0;
            }
            if (!e1.toolbar.hasPosition() && !e2.toolbar.hasPosition()) {
                if (e1.extension instanceof SkinExtensionType) {
                    return 1;
                }
                if (e2.extension instanceof SkinExtensionType) {
                    return -1;
                }
                return extComp.compare(e1.extension, e2.extension);
            }
            if (e1.toolbar.hasPosition() && !e2.toolbar.hasPosition()) {
                return Integer.MIN_VALUE;
            }
            if (e2.toolbar.hasPosition() && !e1.toolbar.hasPosition()) {
                return Integer.MAX_VALUE;
            }
            if (e1.toolbar.getPosition() != e2.toolbar.getPosition()) {
                return e1.toolbar.getPosition() - e2.toolbar.getPosition();
            }
            if (e1.toolbar.getActionTool().equals(e2.toolbar.getActionTool()) && e1.toolbar.getSelectableTool().equals(e2.toolbar.getSelectableTool())) {
                return 0;
            }
            return e1.toolbar.toString().compareTo(e2.toolbar.toString());
        }
    }

    private static class SortableTool {
        public PluginClassLoader loader;
        public ToolBar toolbar;
        public ActionTool actiontool;
        public SelectableTool selectabletool;
        public SkinExtensionType extension;

        public SortableTool(PluginClassLoader loader, SkinExtensionType skinExt, ToolBar toolbar2, ActionTool actiontool2) {
            this.extension = skinExt;
            this.toolbar = toolbar2;
            this.actiontool = actiontool2;
            this.loader = loader;
        }

        public SortableTool(PluginClassLoader loader, SkinExtensionType skinExt, ToolBar toolbar2, SelectableTool selectabletool2) {
            this.extension = skinExt;
            this.toolbar = toolbar2;
            this.selectabletool = selectabletool2;
            this.loader = loader;
        }

        public long getPosition() {
            if (this.actiontool != null) {
                return this.actiontool.getPosition();
            }
            if (this.selectabletool != null) {
                return this.selectabletool.getPosition();
            }
            return 0L;
        }
    }

    private static class SortableMenu {
        public PluginClassLoader loader;
        public Menu menu;
        public SkinExtensionType extension;

        public SortableMenu(PluginClassLoader loader, SkinExtensionType skinExt, Menu menu2) {
            this.extension = skinExt;
            this.menu = menu2;
            this.loader = loader;
        }
    }

    private static class MenuComparator
    implements Comparator<SortableMenu> {
        private static ExtensionComparator extComp = new ExtensionComparator();

        private MenuComparator() {
        }

        @Override
        public int compare(SortableMenu e1, SortableMenu e2) {
            if (!e1.menu.hasPosition() && !e2.menu.hasPosition()) {
                if (e1.extension instanceof SkinExtensionType) {
                    return 1;
                }
                if (e2.extension instanceof SkinExtensionType) {
                    return -1;
                }
                return extComp.compare(e1.extension, e2.extension);
            }
            if (e1.menu.hasPosition() && !e2.menu.hasPosition()) {
                return Integer.MIN_VALUE;
            }
            if (e2.menu.hasPosition() && !e1.menu.hasPosition()) {
                return Integer.MAX_VALUE;
            }
            if (e1.menu.getPosition() == e2.menu.getPosition()) {
                return e1.toString().compareTo(e2.toString());
            }
            if (e1.menu.getPosition() > e2.menu.getPosition()) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
    }

    private static class ExtensionComparator
    implements Comparator {
        private ExtensionComparator() {
        }

        public int compare(Object o1, Object o2) {
            org.gvsig.andami.plugins.config.generate.Extension e1 = (org.gvsig.andami.plugins.config.generate.Extension)o1;
            org.gvsig.andami.plugins.config.generate.Extension e2 = (org.gvsig.andami.plugins.config.generate.Extension)o2;
            if (!e1.hasPriority() && !e2.hasPriority()) {
                return -1;
            }
            if (e1.hasPriority() && !e2.hasPriority()) {
                return Integer.MIN_VALUE;
            }
            if (e2.hasPriority() && !e1.hasPriority()) {
                return Integer.MAX_VALUE;
            }
            if (e1.getPriority() != e2.getPriority()) {
                return e2.getPriority() - e1.getPriority();
            }
            return e2.toString().compareTo(e1.toString());
        }
    }

    private static class OrderedPlugins
    extends ArrayList<String> {
        private List<String> problems = new ArrayList<String>();
        private int retries = 0;
        private PluginsConfig pluginsConfig = null;
        private List<String> deprcatedPluginNames = null;

        OrderedPlugins(PluginsConfig pluginsConfig, List<String> deprcatedPluginNames) {
            this.pluginsConfig = pluginsConfig;
            this.deprcatedPluginNames = deprcatedPluginNames;
            ArrayList<String> pluginNames = new ArrayList<String>();
            for (String pluginName : pluginsConfig.keySet()) {
                pluginNames.add(pluginName);
            }
            Collections.sort(pluginNames);
            for (String pluginName : pluginNames) {
                this.add(pluginName);
            }
        }

        public List<String> getProblems() {
            return this.problems;
        }

        private void addProblem(String msg) {
            this.problems.add(msg);
        }

        @Override
        public boolean add(String pluginName) {
            return this.add(pluginName, new ArrayList<String>());
        }

        private boolean add(String pluginName, List<String> processing) {
            if (this.contains(pluginName = this.pluginsConfig.getMainKey(pluginName))) {
                return true;
            }
            if (processing.contains(pluginName)) {
                this.addProblem("Dependencias ciclicas procesando '" + pluginName + "'.");
                return true;
            }
            PluginConfig pluginConfig = (PluginConfig)this.pluginsConfig.get(pluginName);
            Depends[] dependencies = pluginConfig.getDepends();
            if (dependencies.length == 0) {
                super.add(pluginName);
                return true;
            }
            if (this.retries > 100) {
                this.addProblem("Posible dependencias ciclicas procesando '" + pluginName + "'.");
                return false;
            }
            processing.add(pluginName);
            boolean dependenciesAvailables = true;
            for (Depends dependency : dependencies) {
                PluginConfig dependencyConfig;
                String dependencyName = dependency.getPluginName();
                if (this.deprcatedPluginNames.contains(dependencyName)) {
                    this.addProblem("Plugin '" + pluginName + "' use a deprecated plugin name '" + dependencyName + "' as dependency. Must use '" + this.pluginsConfig.getMainKey(dependencyName) + "'.");
                }
                if ((dependencyConfig = (PluginConfig)this.pluginsConfig.get(dependencyName)) == null) {
                    if (dependency.getOptional()) {
                        this.addProblem("Plugin '" + pluginName + "', declare an optional dependency '" + dependencyName + "' that not found.");
                        continue;
                    }
                    dependenciesAvailables = false;
                    this.addProblem("Plugin '" + pluginName + "' declara a dependency '" + dependencyName + "' that not found.");
                    continue;
                }
                ++this.retries;
                if (!this.add(dependencyName, processing)) {
                    dependenciesAvailables = false;
                }
                --this.retries;
            }
            if (!dependenciesAvailables) {
                this.addProblem("Plugin '" + pluginName + "' no disponible, alguna dependencia no resuelta.");
                return false;
            }
            super.add(pluginName);
            return true;
        }
    }

    public class PluginMenuItem {
        private Menu menu;
        private PluginClassLoader loader;
        private SkinExtensionType extension;

        PluginMenuItem(PluginClassLoader loader, SkinExtensionType extension, Menu menu) {
            this.menu = menu;
            this.loader = loader;
            this.extension = extension;
        }

        public PluginServices getPlugin() {
            String pluginName = this.loader.getPluginName();
            return PluginServices.getPluginServices(pluginName);
        }

        public String getExtensionName() {
            return this.extension.getClassName();
        }

        public IExtension getExtension() {
            Class<?> extensionClass;
            try {
                extensionClass = this.loader.loadClass(this.extension.getClassName());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            return PluginServices.getExtension(extensionClass);
        }

        public String getText() {
            return this.menu.getText();
        }

        public long getPosition() {
            return this.menu.getPosition();
        }

        public String getName() {
            return this.menu.getName();
        }

        public boolean isParent() {
            return this.menu.getIs_separator();
        }

        public String getPluginName() {
            return this.loader.getPluginName();
        }

        public ActionInfo getAction() {
            ActionInfoManager manager = PluginsLocator.getActionInfoManager();
            return manager.getAction(this.menu.getName());
        }
    }

    private class NotificationAppender
    extends AppenderSkeleton {
        private NotificationAppender() {
        }

        protected void append(LoggingEvent event) {
            if (event.getLevel() == Level.ERROR || event.getLevel() == Level.FATAL) {
                Throwable th = null;
                ThrowableInformation thi = event.getThrowableInformation();
                if (thi != null) {
                    th = thi.getThrowable();
                }
                NotificationManager.dispatchError(event.getRenderedMessage(), th);
                return;
            }
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }

    public static class LaunchException
    extends ListBaseException {
        private static final long serialVersionUID = 4541192746962684705L;

        public LaunchException() {
            super("Errors in initialization of application.", "_errors_in_initialization_of_application", 4541192746962684705L);
        }
    }

    private static final class ProxyAuth
    extends Authenticator {
        private PasswordAuthentication auth;

        private ProxyAuth(String user, String pass) {
            this.auth = new PasswordAuthentication(user, pass.toCharArray());
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this.auth;
        }
    }

    public static class PluginsServices
    extends MapWithAlias<PluginServices> {
        @Override
        public String[] getAliases(PluginServices item) {
            return item.getAlternativeNames();
        }
    }

    public static class PluginsConfig
    extends MapWithAlias<PluginConfig> {
        @Override
        public String[] getAliases(PluginConfig item) {
            return PluginsConfig.getAlternativeNames(item);
        }

        static String[] getAlternativeNames(PluginConfig item) {
            AlternativeNames[] x = item.getAlternativeNames();
            if (x == null) {
                return null;
            }
            String[] r = new String[x.length];
            for (int i = 0; i < x.length; ++i) {
                r[i] = x[i].getName();
            }
            return r;
        }
    }

    public static abstract class MapWithAlias<Item>
    extends HashMap<String, Item> {
        private HashMap<String, String> aliases = new HashMap();

        public abstract String[] getAliases(Item var1);

        public boolean isAlias(String key) {
            return this.aliases.get(key) != null;
        }

        public String getMainKey(String key) {
            Object item = super.get(key);
            if (item != null) {
                return key;
            }
            String alias = this.aliases.get(key);
            if (alias != null) {
                return alias;
            }
            return null;
        }

        @Override
        public Item get(Object key) {
            Object item = super.get(key);
            if (item != null) {
                return (Item)item;
            }
            String alias = this.aliases.get(key);
            if (alias != null) {
                return (Item)super.get(alias);
            }
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            boolean contains = super.containsKey(key);
            if (contains) {
                return true;
            }
            String alias = this.aliases.get(key);
            return super.containsKey(alias);
        }

        @Override
        public Item put(String key, Item value) {
            super.put(key, value);
            String[] aliases = this.getAliases(value);
            if (aliases == null) {
                return value;
            }
            for (int n = 0; n < aliases.length; ++n) {
                this.aliases.put(aliases[n].trim(), key);
            }
            return value;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Item> m) {
            for (Map.Entry<String, Item> x : m.entrySet()) {
                this.put(x.getKey(), x.getValue());
            }
        }

        @Override
        public Item remove(Object key) {
            Object item = super.get(key);
            if (item == null) {
                String alias = this.aliases.get(key);
                if (alias == null) {
                    return null;
                }
                item = super.get(alias);
                super.remove(alias);
            } else {
                super.remove(key);
            }
            String[] aliases = this.getAliases(item);
            if (aliases == null) {
                return (Item)item;
            }
            this.aliases = new HashMap();
            for (Map.Entry entry : this.entrySet()) {
                aliases = this.getAliases(entry.getValue());
                if (aliases == null) continue;
                for (int n = 0; n < aliases.length; ++n) {
                    this.aliases.put(aliases[n].trim(), (String)entry.getKey());
                }
            }
            return (Item)item;
        }
    }
}

