/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami;

import java.awt.Component;
import java.awt.Container;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import javax.swing.RootPaneContainer;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.splash.MultiSplashWindow;
import org.gvsig.tools.ToolsLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utilities {
    private static Hashtable downloadedFiles;
    private static final Logger logger;
    public static final String TEMPDIRECTORYPATH;

    public static String getTempDirectory() {
        return ToolsLocator.getFoldersManager().getTemporaryFolder().getAbsolutePath();
    }

    public static void cleanUpTempFiles() {
        ToolsLocator.getFoldersManager().cleanTemporaryFiles();
    }

    public static File createTemp(String fileName, String data) throws IOException {
        return ToolsLocator.getFoldersManager().createTemporaryFile(fileName, data);
    }

    public static String createTempDirectory() {
        return ToolsLocator.getFoldersManager().createTemporaryFolder().getAbsolutePath();
    }

    public static ImageIcon createImageIcon(String path) {
        URL imgURL = null;
        try {
            imgURL = new URL("file:" + path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return null;
    }

    public static void cleanComponent(Component baseComponent) {
        try {
            Utilities.cleanComponent(baseComponent, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void cleanComponent(Component baseComponent, int depth) {
        if (baseComponent == null) {
            return;
        }
        if (baseComponent instanceof IWindow) {
            return;
        }
        if (baseComponent instanceof Container) {
            if (baseComponent instanceof RootPaneContainer) {
                Container cont = (Container)baseComponent;
                int numChildren = cont.getComponentCount();
                Component[] childComponents = cont.getComponents();
                for (int i = 0; i < numChildren; ++i) {
                    Utilities.cleanComponent(childComponents[i], depth + 1);
                    ((RootPaneContainer)((Object)cont)).getContentPane().remove(childComponents[i]);
                }
                ((RootPaneContainer)((Object)cont)).getContentPane().setLayout(null);
            } else {
                Container cont = (Container)baseComponent;
                int numChildren = cont.getComponentCount();
                Component[] childComponents = cont.getComponents();
                for (int i = 0; i < numChildren; ++i) {
                    Utilities.cleanComponent(childComponents[i], depth + 1);
                    cont.remove(childComponents[i]);
                }
                cont.setLayout(null);
            }
        }
    }

    public static void extractTo(File file, File dir, MultiSplashWindow splash) throws ZipException, IOException {
        ZipEntry entry;
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            entry = e.nextElement();
            if (!entry.isDirectory()) continue;
            File directorio = new File(dir.getAbsolutePath() + File.separator + entry.getName());
            directorio.mkdirs();
        }
        e = zip.entries();
        while (e.hasMoreElements()) {
            int i;
            entry = e.nextElement();
            splash.process(30, "Procesando " + entry.getName() + "...");
            if (entry.isDirectory()) continue;
            InputStream in = zip.getInputStream(entry);
            FileOutputStream out = new FileOutputStream(dir + File.separator + entry.getName());
            BufferedInputStream bin = new BufferedInputStream(in);
            BufferedOutputStream bout = new BufferedOutputStream(out);
            while ((i = bin.read()) != -1) {
                bout.write(i);
            }
            bout.flush();
            bout.close();
            bin.close();
        }
        zip.close();
        zip = null;
        System.gc();
    }

    private static File getPreviousDownloadedURL(URL url) {
        File f = null;
        if (downloadedFiles != null && downloadedFiles.containsKey(url)) {
            String filePath = (String)downloadedFiles.get(url);
            f = new File(filePath);
        }
        return f;
    }

    private static void addDownloadedURL(URL url, String filePath) {
        if (downloadedFiles == null) {
            downloadedFiles = new Hashtable();
        }
        String fileName = downloadedFiles.put(url, filePath);
    }

    public static File downloadFile(URL url, String name) throws IOException, ConnectException, UnknownHostException {
        File f = null;
        try {
            f = Utilities.getPreviousDownloadedURL(url);
            if (f == null) {
                File tempDirectory = new File(TEMPDIRECTORYPATH);
                if (!tempDirectory.exists()) {
                    tempDirectory.mkdir();
                }
                f = new File(TEMPDIRECTORYPATH + "/" + name + System.currentTimeMillis());
                System.out.println("downloading '" + url.toString() + "' to: " + f.getAbsolutePath());
                f.deleteOnExit();
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
                byte[] buffer = new byte[262144];
                InputStream is = url.openStream();
                long readed = 0L;
                int i = is.read(buffer);
                while (i > 0) {
                    dos.write(buffer, 0, i);
                    readed += (long)i;
                    i = is.read(buffer);
                }
                dos.close();
                Utilities.addDownloadedURL(url, f.getAbsolutePath());
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        return f;
    }

    public static void removeURL(URL url) {
        if (downloadedFiles != null && downloadedFiles.containsKey(url)) {
            downloadedFiles.remove(url);
        }
    }

    static {
        logger = LoggerFactory.getLogger((String)Utilities.class.getName());
        TEMPDIRECTORYPATH = Utilities.getTempDirectory();
    }
}

