/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.help.BadIDException;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpPanel
extends JPanel {
    private static final long serialVersionUID = 4164482247505362337L;
    public static int WIDTH = 645;
    public static int HEIGHT = 495;
    private String title = null;
    private JHelp jh;

    private Logger log() {
        return LoggerFactory.getLogger((String)"org.gvsig");
    }

    public HelpPanel(HelpSet hs) {
        this.log().info("HelpPanel(hs)");
        this.init(hs, null);
    }

    public HelpPanel(HelpSet hs, String id) {
        this.log().info("HelpPanel(hs,id) id=" + id);
        this.init(hs, id);
    }

    private void init(HelpSet hs, String id) {
        String hsTitle;
        this.jh = new JHelp(hs);
        this.log().info("init() ID " + id);
        if (id != null) {
            try {
                this.log().info("init() setCurrentID " + id);
                this.jh.setCurrentID(id);
            }
            catch (BadIDException ex) {
                this.log().error(ex.toString());
            }
            catch (NullPointerException ex) {
                this.log().error(ex.toString());
            }
        }
        if ((hsTitle = hs.getTitle()) == null || hsTitle.equals("")) {
            hsTitle = "gvSIG Help";
        }
        this.title = hsTitle;
        this.setLayout(new BorderLayout());
        this.add((Component)this.jh, "Center");
    }

    public void showWindow() {
        this.log().info("showWindow()");
        Frame frame = new Frame();
        frame.add(this);
        frame.setSize(WIDTH, HEIGHT + 30);
        frame.setTitle(this.getTitle());
        frame.setResizable(true);
        this.setVisible(true);
        frame.show();
    }

    public void showWindow(String id) {
        String hsTitle;
        if (id != null) {
            try {
                this.log().info("showWindow(id) -> setCurrentID " + id);
                this.jh.setCurrentID(id);
            }
            catch (BadIDException ex) {
                this.log().error(ex.toString());
            }
        }
        if ((hsTitle = this.jh.getHelpSetPresentation().getTitle()) == null || hsTitle.equals("")) {
            hsTitle = "gvSIG Help";
        }
        this.title = hsTitle;
        this.showWindow();
    }

    public String getTitle() {
        return this.title;
    }
}

