/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.impl;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.Launcher;
import org.gvsig.andami.LocaleManager;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.config.generate.AndamiConfig;
import org.gvsig.andami.ui.mdiFrame.MDIFrame;
import org.gvsig.i18n.Messages;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.utils.XMLEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLocaleManager
implements LocaleManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLocaleManager.class);
    private static final String LOCALE_CODE_VALENCIANO = "vl";
    private static final String I18N_EXTENSION = "org.gvsig.i18n.extension";
    private static final String INSTALLED_TRANSLATIONS_HOME_FOLDER = "i18n";
    private static final String VARIANT = "variant";
    private static final String COUNTRY = "country";
    private static final String LANGUAGE = "language";
    private static final String REGISTERED_LOCALES_PERSISTENCE = "RegisteredLocales";
    private static final String LOCALE_CONFIG_FILENAME = "locale.config";
    private final Locale[] hardcoredLocales = new Locale[]{SPANISH, ENGLISH, new Locale("en", "US"), new Locale("ca"), new Locale("gl"), new Locale("eu"), new Locale("de"), new Locale("cs"), new Locale("fr"), new Locale("it"), new Locale("pl"), new Locale("pt"), new Locale("pt", "BR"), new Locale("ro"), new Locale("zh"), new Locale("ru"), new Locale("el"), new Locale("ro"), new Locale("pl"), new Locale("tr"), new Locale("sr"), new Locale("sw")};
    private Set installedLocales = null;
    private Set defaultLocales = null;
    private boolean storedInstalledLocales = false;

    public DefaultLocaleManager() {
        Locale currentLocale = Messages.getCurrentLocale();
        if (currentLocale == null) {
            currentLocale = Locale.getDefault();
        }
        this.setCurrentLocale(currentLocale);
    }

    @Override
    public Locale getCurrentLocale() {
        return Messages.getCurrentLocale();
    }

    @Override
    public void setCurrentLocale(Locale locale) {
        Locale nearestLocale = this.getNearestLocale(locale);
        if (nearestLocale == null) {
            nearestLocale = this.getLocaleAlternatives(locale)[0];
        }
        Messages.setCurrentLocale((Locale)nearestLocale, (Locale[])this.getLocaleAlternatives(nearestLocale));
        String localeStr = nearestLocale.getLanguage();
        if (localeStr.equalsIgnoreCase(LOCALE_CODE_VALENCIANO)) {
            Locale.setDefault(new Locale("ca"));
        } else {
            Locale.setDefault(nearestLocale);
        }
        AndamiConfig config = Launcher.getAndamiConfig();
        if (config != null) {
            config.setLocaleLanguage(nearestLocale.getLanguage());
            config.setLocaleCountry(nearestLocale.getCountry());
            config.setLocaleVariant(nearestLocale.getVariant());
        }
        this.setCurrentLocaleUI(nearestLocale);
    }

    @Override
    public Locale getDefaultSystemLocale() {
        String variant;
        String country;
        String language = this.getSystemProperty("user.language", "en");
        String region = this.getSystemProperty("user.region", null);
        if (region != null) {
            int i = region.indexOf(95);
            if (i >= 0) {
                country = region.substring(0, i);
                variant = region.substring(i + 1);
            } else {
                country = region;
                variant = "";
            }
        } else {
            country = this.getSystemProperty("user.country", "");
            variant = this.getSystemProperty("user.variant", "");
        }
        return new Locale(language, country, variant);
    }

    private Set<Locale> loadLocalesFromConfing(File localesFile) {
        PropertiesConfiguration config = null;
        if (!localesFile.canRead()) {
            return null;
        }
        try {
            config = new PropertiesConfiguration(localesFile);
        }
        catch (Exception ex) {
            logger.warn("Can't open locale configuration '" + localesFile + "'.", (Throwable)ex);
            return null;
        }
        HashSet<Locale> locales = new HashSet<Locale>();
        List localeCodes = config.getList("locale");
        for (Object localeCode : localeCodes) {
            try {
                Locale locale = LocaleUtils.toLocale((String)((String)localeCode));
                locales.add(locale);
            }
            catch (IllegalArgumentException ex) {
                logger.warn("Can't load locale '" + localeCode + "' from config '" + localesFile.getAbsolutePath() + "'.", (Throwable)ex);
            }
        }
        return locales;
    }

    @Override
    public Set<Locale> getDefaultLocales() {
        if (this.defaultLocales == null) {
            PluginsManager pluginsManager = PluginsLocator.getManager();
            File localesFile = new File(pluginsManager.getApplicationI18nFolder(), LOCALE_CONFIG_FILENAME);
            Set<Locale> locales = this.loadLocalesFromConfing(localesFile);
            this.defaultLocales = new HashSet();
            if (locales == null) {
                for (int i = 0; i < this.hardcoredLocales.length; ++i) {
                    this.defaultLocales.add(this.hardcoredLocales[i]);
                }
            } else {
                this.defaultLocales.addAll(locales);
            }
        }
        return this.defaultLocales;
    }

    @Override
    public boolean installLocales(URL localesFile) {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        PropertiesConfiguration config = null;
        try {
            config = new PropertiesConfiguration(localesFile);
        }
        catch (Exception ex) {
            logger.warn("Can't open configuration '" + localesFile + "'.", (Throwable)ex);
        }
        if (config == null) {
            return false;
        }
        List localeCodes = config.getList("locale");
        for (Object localeCode : localeCodes) {
            Locale locale = LocaleUtils.toLocale((String)((String)localeCode));
            if (this.getInstalledLocales().contains(locale)) continue;
            this.installedLocales.add(locale);
        }
        this.storeInstalledLocales();
        return true;
    }

    @Override
    public Set<Locale> getInstalledLocales() {
        if (this.installedLocales == null) {
            this.installedLocales = new TreeSet<Locale>(new Comparator<Locale>(){

                @Override
                public int compare(Locale t0, Locale t1) {
                    if (t1 == null || t0 == null) {
                        return 0;
                    }
                    return t0.toString().compareToIgnoreCase(t1.toString());
                }
            });
            XMLEntity child = this.getRegisteredLocalesPersistence();
            if (child == null) {
                this.installedLocales.addAll(this.getDefaultLocales());
            } else {
                XMLEntity localesEntity = child;
                for (int i = 0; i < localesEntity.getChildrenCount(); ++i) {
                    Locale locale = null;
                    XMLEntity localeEntity = localesEntity.getChild(i);
                    String language = localeEntity.getStringProperty(LANGUAGE);
                    String country = localeEntity.getStringProperty(COUNTRY);
                    String variant = localeEntity.getStringProperty(VARIANT);
                    locale = new Locale(language, country, variant);
                    this.installedLocales.add(locale);
                }
            }
            Set<Locale> lfp = this.getAllLocalesFromPackages();
            this.installedLocales.addAll(lfp);
        }
        this.storeInstalledLocales();
        return Collections.unmodifiableSet(this.installedLocales);
    }

    @Override
    public void updateInstalledLocales() {
        this.installedLocales.addAll(this.getAllLocalesFromPackages());
        this.storedInstalledLocales = false;
        this.storeInstalledLocales();
    }

    @Override
    public boolean installLocale(Locale locale) {
        if (!this.getInstalledLocales().contains(locale)) {
            this.getInstalledLocales().add(locale);
            this.storeInstalledLocales();
        }
        return true;
    }

    @Override
    public boolean uninstallLocale(Locale locale) {
        if (!this.getInstalledLocales().remove(locale)) {
            return false;
        }
        this.storeInstalledLocales();
        return true;
    }

    @Override
    public String getLanguageDisplayName(Locale locale) {
        String displayName = "eu".equals(locale.getLanguage()) && "vascuence".equals(locale.getDisplayLanguage()) ? "Euskera" : (LOCALE_CODE_VALENCIANO.equals(locale.getLanguage()) ? "Valenci\u00e0" : locale.getDisplayLanguage(locale));
        return StringUtils.capitalize((String)displayName);
    }

    @Override
    public String getLocaleDisplayName(Locale locale) {
        String displayName = this.getLanguageDisplayName(locale);
        if (!StringUtils.isBlank((CharSequence)locale.getCountry())) {
            displayName = !StringUtils.isBlank((CharSequence)locale.getVariant()) ? displayName + " (" + StringUtils.capitalize((String)locale.getDisplayCountry(locale)) + "/" + locale.getDisplayVariant(locale) + ")" : displayName + " (" + locale.getDisplayCountry(locale) + ")";
        }
        return displayName;
    }

    @Override
    public Locale[] getLocaleAlternatives(Locale locale) {
        Locale[] alternatives = null;
        String localeStr = locale.getLanguage();
        alternatives = localeStr.equals("es") || localeStr.equals("ca") || localeStr.equals("gl") || localeStr.equals("eu") || localeStr.equals(LOCALE_CODE_VALENCIANO) ? new Locale[]{new Locale("es"), new Locale("en")} : new Locale[]{new Locale("en"), new Locale("es")};
        return alternatives;
    }

    private void setCurrentLocaleUI(final Locale locale) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultLocaleManager.this.setCurrentLocaleUI(locale);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            JComponent.setDefaultLocale(locale);
        }
        catch (Exception ex) {
            logger.warn("Problems setting locale to JComponent.", (Throwable)ex);
        }
        if (MDIFrame.isInitialized()) {
            try {
                MDIFrame.getInstance().setLocale(locale);
            }
            catch (Exception ex) {
                logger.warn("Problems settings locale to MDIFrame.", (Throwable)ex);
            }
        }
    }

    @Override
    public File getResourcesFolder() {
        File i18nFolder = new File(PluginsLocator.getManager().getApplicationHomeFolder(), INSTALLED_TRANSLATIONS_HOME_FOLDER);
        if (!i18nFolder.exists()) {
            i18nFolder.mkdirs();
        }
        return i18nFolder;
    }

    private XMLEntity getRegisteredLocalesPersistence() {
        XMLEntity entity = this.getI18nPersistence();
        if (entity == null) {
            return null;
        }
        XMLEntity child = null;
        for (int i = entity.getChildrenCount() - 1; i >= 0; --i) {
            XMLEntity tmpchild = entity.getChild(i);
            if (!tmpchild.getName().equals(REGISTERED_LOCALES_PERSISTENCE)) continue;
            child = tmpchild;
            break;
        }
        return child;
    }

    private void storeInstalledLocales() {
        if (this.storedInstalledLocales) {
            return;
        }
        XMLEntity i18nPersistence = this.getI18nPersistence();
        if (i18nPersistence == null) {
            return;
        }
        XMLEntity localesEntity = this.getRegisteredLocalesPersistence();
        if (localesEntity != null) {
            for (int i = i18nPersistence.getChildrenCount() - 1; i >= 0; --i) {
                XMLEntity child = i18nPersistence.getChild(i);
                if (!child.getName().equals(REGISTERED_LOCALES_PERSISTENCE)) continue;
                i18nPersistence.removeChild(i);
                break;
            }
        }
        localesEntity = new XMLEntity();
        localesEntity.setName(REGISTERED_LOCALES_PERSISTENCE);
        Set locales = this.installedLocales;
        for (Locale locale : locales) {
            XMLEntity localeEntity = new XMLEntity();
            localeEntity.setName(locale.getDisplayName());
            localeEntity.putProperty(LANGUAGE, locale.getLanguage());
            localeEntity.putProperty(COUNTRY, locale.getCountry());
            localeEntity.putProperty(VARIANT, locale.getVariant());
            localesEntity.addChild(localeEntity);
        }
        this.getI18nPersistence().addChild(localesEntity);
        this.storedInstalledLocales = true;
    }

    private XMLEntity getI18nPersistence() {
        try {
            XMLEntity entity = PluginServices.getPluginServices(I18N_EXTENSION).getPersistentXML();
            return entity;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private String getSystemProperty(final String property, String defaultValue) {
        String value = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(property);
            }
        });
        return value == null ? defaultValue : value;
    }

    private Set<Locale> getAllLocalesFromPackages() {
        HashSet<Locale> locales = new HashSet<Locale>();
        InstallerManager installerManager = InstallerLocator.getInstallerManager();
        List folders = installerManager.getAddonFolders("translations");
        for (File folder : folders) {
            File file = new File(folder, LOCALE_CONFIG_FILENAME);
            Set<Locale> l = this.loadLocalesFromConfing(file);
            locales.addAll(l);
        }
        return locales;
    }

    @Override
    public Locale getNearestLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (language != null && !language.isEmpty()) {
            Locale nearestLocale;
            if (country != null && !country.isEmpty()) {
                if (variant != null && !variant.isEmpty()) {
                    nearestLocale = new Locale(language, country, variant);
                    if (this.getInstalledLocales().contains(nearestLocale)) {
                        return nearestLocale;
                    }
                }
                nearestLocale = new Locale(language, country);
                if (this.getInstalledLocales().contains(nearestLocale)) {
                    return nearestLocale;
                }
            }
            nearestLocale = new Locale(language);
            if (this.getInstalledLocales().contains(nearestLocale)) {
                return nearestLocale;
            }
        }
        return null;
    }
}

