/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.installer.icontheme;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.execution.InstallPackageServiceException;
import org.gvsig.installer.lib.spi.InstallerInfoFileException;
import org.gvsig.installer.lib.spi.execution.InstallPackageProvider;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.service.spi.AbstractProvider;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconThemeInstaller
extends AbstractProvider
implements InstallPackageProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(IconThemeInstaller.class);
    private final int BUFFER = 2048;

    public IconThemeInstaller(ProviderServices providerServices) {
        super(providerServices);
    }

    public void install(File applicationFolder, InputStream inputStream, PackageInfo packageInfo) throws InstallPackageServiceException {
        File folder = null;
        try {
            IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
            folder = iconThemeManager.getRepository().asFile();
            LOGGER.info("Installing package '" + (packageInfo == null ? "NULL" : packageInfo.getCode()) + "' in folder '" + (folder == null ? "NULL" : folder.getAbsolutePath()) + "'.");
            if (!folder.exists()) {
                String s = "Can install package '" + packageInfo.getCode() + "', install folder '" + folder + "' does not exists.";
                LOGGER.warn(s);
                throw new RuntimeException(s);
            }
            this.decompress(inputStream, folder);
        }
        catch (Exception e) {
            try {
                LOGGER.warn("Can install package '" + (packageInfo == null ? "NULL" : packageInfo.getCode()) + "' in folder '" + (folder == null ? "NULL" : folder.getAbsolutePath()) + "'.", (Throwable)e);
                this.installLater(applicationFolder, inputStream, packageInfo);
            }
            catch (IOException e1) {
                LOGGER.warn("Can install package '" + (packageInfo == null ? "NULL" : packageInfo.getCode()) + "' in folder '" + (folder == null ? "NULL" : folder.getAbsolutePath()) + "'.", (Throwable)e);
                throw new InstallPackageServiceException((Throwable)e1);
            }
        }
    }

    private void decompress(InputStream inputStream, File folder) throws ZipException, IOException, InstallerInfoFileException {
        byte[] data = new byte[2048];
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        SimpleTaskStatus taskStatus = manager.createDefaultSimpleTaskStatus("Uncompressing...");
        manager.add((TaskStatus)taskStatus);
        String entryName = "(header)";
        try {
            ZipEntry entry;
            long readed = 0L;
            ZipInputStream zis = new ZipInputStream(inputStream);
            while ((entry = zis.getNextEntry()) != null) {
                entryName = FilenameUtils.separatorsToSystem((String)entry.getName());
                taskStatus.message(entryName);
                File file = new File(folder, entryName);
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                if (file.exists()) {
                    FileUtils.forceDelete((File)file);
                }
                if (!file.getParentFile().exists()) {
                    FileUtils.forceMkdir((File)file.getParentFile());
                }
                LOGGER.debug("extracting " + file.getAbsolutePath());
                FileOutputStream fos = new FileOutputStream(file);
                Throwable throwable = null;
                try {
                    int count;
                    while ((count = zis.read(data, 0, 2048)) != -1) {
                        fos.write(data, 0, count);
                        taskStatus.setCurValue(readed += (long)count);
                    }
                    fos.flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
            zis.close();
        }
        catch (Exception ex) {
            LOGGER.warn("Problems uncompresing 'translations' (last entry '" + entryName + "'.", (Throwable)ex);
            throw ex;
        }
        finally {
            taskStatus.remove();
        }
    }

    public void installLater(File applicationDirectory, InputStream inputStream, PackageInfo packageInfo) throws InstallPackageServiceException, IOException {
        LOGGER.warn("installLater is not implementes.");
    }
}

