/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.plugins;

import org.gvsig.andami.plugins.HiddableExtension;
import org.gvsig.andami.plugins.IExtension;
import org.gvsig.andami.plugins.status.IExtensionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionDecorator
implements HiddableExtension {
    private static Logger logger = LoggerFactory.getLogger(ExtensionDecorator.class);
    public static final int INACTIVE = 0;
    public static final int ALWAYS_VISIBLE = 1;
    public static final int ALWAYS_INVISIBLE = 2;
    int alwaysVisible;
    IExtension extension;

    public ExtensionDecorator(IExtension e, int visibilityControl) {
        this.setExtension(e);
        this.setVisibility(visibilityControl);
    }

    public void setExtension(IExtension e) {
        this.extension = e;
    }

    @Override
    public void setVisibility(int state) {
        this.alwaysVisible = state;
    }

    @Override
    public int getVisibility() {
        return this.alwaysVisible;
    }

    public IExtension getExtension() {
        return this.extension;
    }

    @Override
    public void initialize() {
        this.extension.initialize();
    }

    @Override
    public void terminate() {
    }

    @Override
    public void execute(String actionCommand) {
        logger.info("{}.execute('{}')", (Object)this.extension.getClass().getSimpleName(), (Object)actionCommand);
        this.extension.execute(actionCommand);
    }

    @Override
    public boolean isEnabled() {
        return this.extension.isEnabled();
    }

    @Override
    public boolean isVisible() {
        if (this.alwaysVisible == 0) {
            return this.extension.isVisible();
        }
        return this.alwaysVisible == 1;
    }

    @Override
    public void postInitialize() {
    }

    @Override
    public IExtensionStatus getStatus() {
        return this.extension.getStatus();
    }

    @Override
    public IExtensionStatus getStatus(IExtension extension) {
        return this.extension.getStatus(extension);
    }
}

