/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.additionalResults;

import es.unex.sextante.math.regression.Regression;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYDotRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class CorrelationGraphCreator {
    private JFreeChart chart;
    private ChartPanel jPanelChart = null;
    private final Regression regression;

    public CorrelationGraphCreator(Regression reg) {
        this.regression = reg;
        this.createChart();
        Plot plot = this.chart.getPlot();
        plot.setOutlineStroke((Stroke)new BasicStroke(1.0f));
        plot.setOutlinePaint((Paint)Color.blue);
    }

    public ChartPanel getChartPanel() {
        if (this.jPanelChart == null) {
            this.jPanelChart = new ChartPanel(this.chart);
        }
        return this.jPanelChart;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    private void createChart() {
        XYDataset data1 = this.getOriginalDataset();
        this.chart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)data1, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        XYPlot plot = this.chart.getXYPlot();
        plot.setRenderer((XYItemRenderer)new XYDotRenderer());
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        plot.getRenderer().setSeriesPaint(0, (Paint)Color.blue);
        XYDataset data2 = this.getDatasetFromFitting();
        StandardXYItemRenderer renderer = new StandardXYItemRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.red);
        plot.setDataset(1, data2);
        plot.setRenderer(1, (XYItemRenderer)renderer);
    }

    private XYDataset getOriginalDataset() {
        XYSeries series = new XYSeries((Comparable)((Object)""));
        int NUM_POINTS_FOR_GRAPH = 2000;
        double[] cellValue1 = new double[2000];
        double[] cellValue2 = new double[2000];
        this.regression.getRestrictedSample(cellValue1, cellValue2, 2000);
        for (int i = 0; i < cellValue1.length; ++i) {
            series.add(cellValue1[i], cellValue2[i]);
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }

    private XYDataset getDatasetFromFitting() {
        int STEPS = 200;
        XYSeries series = new XYSeries((Comparable)((Object)""));
        double dStep = (this.regression.getXMax() - this.regression.getXMin()) / 200.0;
        for (int i = 0; i < 200; ++i) {
            double x = this.regression.getXMin() + dStep * (double)i;
            double y = this.regression.getY(x);
            series.add(x, y);
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }
}

