/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.core;

import es.unex.sextante.exceptions.WrongOutputIDException;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import java.util.ArrayList;

public class OutputObjectsSet {
    private final ArrayList m_Outputs = new ArrayList();

    public void add(Output output) {
        try {
            Output out = this.getOutput(output.getName());
            out.setObjectData(output);
        }
        catch (WrongOutputIDException e) {
            this.m_Outputs.add(output);
        }
    }

    public Output getOutput(String sName) throws WrongOutputIDException {
        for (int i = 0; i < this.m_Outputs.size(); ++i) {
            if (!((Output)this.m_Outputs.get(i)).getName().equals(sName)) continue;
            return (Output)this.m_Outputs.get(i);
        }
        throw new WrongOutputIDException();
    }

    public Output getOutput(int iIndex) throws ArrayIndexOutOfBoundsException {
        if (iIndex >= 0 && iIndex < this.m_Outputs.size()) {
            return (Output)this.m_Outputs.get(iIndex);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getOutputDataObjectsCount() {
        int iCount = 0;
        for (int i = 0; i < this.getOutputObjectsCount(); ++i) {
            Output out = this.getOutput(i);
            if (!(out instanceof OutputRasterLayer) && !(out instanceof OutputVectorLayer) && !(out instanceof OutputTable) && !(out instanceof Output3DRasterLayer)) continue;
            ++iCount;
        }
        return iCount;
    }

    public boolean hasDataObjects() {
        return this.getOutputDataObjectsCount() != 0;
    }

    public boolean hasLayers() {
        return this.getOutputLayersCount() != 0;
    }

    public int getOutputLayersCount() {
        int iCount = 0;
        for (int i = 0; i < this.getOutputObjectsCount(); ++i) {
            Output out = this.getOutput(i);
            if (!(out instanceof OutputRasterLayer) && !(out instanceof OutputVectorLayer) && !(out instanceof Output3DRasterLayer)) continue;
            ++iCount;
        }
        return iCount;
    }

    public int getRasterLayersCount() {
        int iCount = 0;
        for (int i = 0; i < this.getOutputObjectsCount(); ++i) {
            Output out = this.getOutput(i);
            if (!(out instanceof OutputRasterLayer)) continue;
            ++iCount;
        }
        return iCount;
    }

    public int get3DRasterLayersCount() {
        int iCount = 0;
        for (int i = 0; i < this.getOutputObjectsCount(); ++i) {
            Output out = this.getOutput(i);
            if (!(out instanceof Output3DRasterLayer)) continue;
            ++iCount;
        }
        return iCount;
    }

    public int getVectorLayersCount() {
        int iCount = 0;
        for (int i = 0; i < this.getOutputObjectsCount(); ++i) {
            Output out = this.getOutput(i);
            if (!(out instanceof OutputVectorLayer)) continue;
            ++iCount;
        }
        return iCount;
    }

    public boolean remove(Output out) {
        return this.m_Outputs.remove(out);
    }

    public boolean remove(String sName) {
        try {
            Output out = this.getOutput(sName);
            return this.m_Outputs.remove(out);
        }
        catch (WrongOutputIDException e) {
            return false;
        }
    }

    public OutputObjectsSet getNewInstance() {
        OutputObjectsSet oos = new OutputObjectsSet();
        for (int i = 0; i < this.m_Outputs.size(); ++i) {
            Output out = (Output)this.m_Outputs.get(i);
            oos.add(out.getNewInstance());
        }
        return oos;
    }

    public int getOutputObjectsCount() {
        return this.m_Outputs.size();
    }

    public boolean containsKey(String key) {
        for (int i = 0; i < this.m_Outputs.size(); ++i) {
            if (!((Output)this.m_Outputs.get(i)).getName().equals(key)) continue;
            return true;
        }
        return false;
    }
}

