/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.outputs;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.outputs.Output;

public class OutputVectorLayer
extends Output {
    public static final int SHAPE_TYPE_POLYGON = 2;
    public static final int SHAPE_TYPE_POINT = 0;
    public static final int SHAPE_TYPE_LINE = 1;
    public static final int SHAPE_TYPE_UNDEFINED = -1;
    private int m_iShapeType;
    private int m_subType;
    private String m_sInputLayerToOverwrite;

    @Override
    public void setOutputObject(Object obj) {
        if (obj instanceof IVectorLayer || obj == null) {
            this.m_Object = obj;
        }
    }

    @Override
    public String getCommandLineParameter() {
        if (this.m_OutputChannel == null) {
            return "\"#\"";
        }
        return "\"" + this.m_OutputChannel.getAsCommandLineParameter() + "\"";
    }

    public int getShapeType() {
        return this.m_iShapeType;
    }

    public void setShapeType(int shapeType) {
        this.m_iShapeType = shapeType;
    }

    @Override
    public Output getNewInstance() {
        Output out = super.getNewInstance();
        ((OutputVectorLayer)out).setShapeType(this.m_iShapeType);
        ((OutputVectorLayer)out).setInputLayerToOverwrite(this.m_sInputLayerToOverwrite);
        ((OutputVectorLayer)out).setSubType(this.m_subType);
        return out;
    }

    @Override
    public void setObjectData(Output output) {
        super.setObjectData(output);
        if (output instanceof OutputVectorLayer) {
            this.setShapeType(((OutputVectorLayer)output).getShapeType());
            this.setSubType(((OutputVectorLayer)output).getSubType());
        }
    }

    @Override
    public String getTypeDescription() {
        return Sextante.getText("vector");
    }

    public String getInputLayerToOverwrite() {
        return this.m_sInputLayerToOverwrite;
    }

    public void setInputLayerToOverwrite(String inputLayerToOverwrite) {
        this.m_sInputLayerToOverwrite = inputLayerToOverwrite;
    }

    public boolean canOverwrite() {
        return this.m_sInputLayerToOverwrite != null;
    }

    public int getSubType() {
        return this.m_subType;
    }

    public void setSubType(int m_subType) {
        this.m_subType = m_subType;
    }
}

