/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.parameters;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import es.unex.sextante.parameters.ParameterBand;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterFilepath;
import es.unex.sextante.parameters.ParameterFixedTable;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterPoint;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterSelection;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterTableField;
import es.unex.sextante.parameters.ParameterVectorLayer;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;

public abstract class Parameter {
    private static final String CLASS = "class";
    private static final String DESCRIPTION = "description";
    private static final String TOOLTIP = "tooltip";
    private static final String COORDS = "coords";
    private static final String RED = "red";
    private static final String GREEN = "green";
    private static final String BLUE = "blue";
    private static final String ALPHA = "alpha";
    protected static final String INPUT = "input";
    protected static final String ATTRIBUTE = "attribute";
    protected static final String VALUE = "value";
    protected static final String NAME = "name";
    private String m_sName = "";
    private String m_sDescription = "";
    private String m_sTooltip = "";
    protected Object m_ParameterValue = null;
    protected AdditionalInfo m_ParameterAdditionalInfo = null;
    private int i_R = Sextante.i_R_Input;
    private int i_G = Sextante.i_G_Input;
    private int i_B = Sextante.i_B_Input;
    private int i_Alpha = Sextante.i_Alpha_Input;

    public abstract String getParameterTypeName();

    public abstract boolean setParameterValue(Object var1);

    public abstract boolean setParameterAdditionalInfo(AdditionalInfo var1);

    public abstract int getParameterValueAsInt() throws WrongParameterTypeException, NullParameterValueException;

    public abstract double getParameterValueAsDouble() throws WrongParameterTypeException, NullParameterValueException;

    public abstract boolean getParameterValueAsBoolean() throws WrongParameterTypeException, NullParameterValueException;

    public abstract String getParameterValueAsString() throws WrongParameterTypeException, NullParameterValueException, NullParameterAdditionalInfoException;

    public abstract IVectorLayer getParameterValueAsVectorLayer() throws WrongParameterTypeException, NullParameterValueException;

    public abstract I3DRasterLayer getParameterValueAs3DRasterLayer() throws WrongParameterTypeException, NullParameterValueException;

    public abstract IRasterLayer getParameterValueAsRasterLayer() throws WrongParameterTypeException, NullParameterValueException;

    public abstract ITable getParameterValueAsTable() throws WrongParameterTypeException, NullParameterValueException;

    public abstract Point2D getParameterValueAsPoint() throws WrongParameterTypeException, NullParameterValueException;

    public abstract Class getParameterClass();

    public abstract String getCommandLineParameter();

    protected abstract void serializeAttributes(KXmlSerializer var1) throws NullParameterAdditionalInfoException, IOException;

    public AdditionalInfo getParameterAdditionalInfo() throws NullParameterAdditionalInfoException {
        if (this.m_ParameterAdditionalInfo == null) {
            throw new NullParameterAdditionalInfoException();
        }
        return this.m_ParameterAdditionalInfo;
    }

    public String getParameterName() {
        return this.m_sName;
    }

    public String getParameterDescription() {
        return this.m_sDescription;
    }

    public int getColorR() {
        return this.i_R;
    }

    public int getColorG() {
        return this.i_G;
    }

    public int getColorB() {
        return this.i_B;
    }

    public int getColorAlpha() {
        return this.i_Alpha;
    }

    public void setParameterDescription(String sDescription) {
        this.m_sDescription = sDescription;
    }

    public void setColorR(int red) {
        this.i_R = red;
    }

    public void setColorG(int green) {
        this.i_G = green;
    }

    public void setColorB(int blue) {
        this.i_B = blue;
    }

    public void setColorAlpha(int alpha) {
        this.i_Alpha = alpha;
    }

    public String getParameterTooltip() {
        return this.m_sTooltip;
    }

    public void setParameterTooltip(String sTooltip) {
        this.m_sTooltip = sTooltip;
    }

    public void setParameterName(String sName) {
        this.m_sName = sName;
    }

    public Object getParameterValueAsObject() {
        return this.m_ParameterValue;
    }

    public ArrayList getParameterValueAsArrayList() throws NullParameterValueException {
        if (this.m_ParameterValue != null) {
            ArrayList<Object> array = new ArrayList<Object>();
            array.add(this.m_ParameterValue);
            return array;
        }
        throw new NullParameterValueException();
    }

    public String toString() {
        return this.getParameterTypeName();
    }

    public static Parameter deserialize(KXmlParser parser) throws XmlPullParserException, IOException {
        Parameter param = null;
        String sName = parser.getAttributeValue("", NAME);
        String sDescription = parser.getAttributeValue("", DESCRIPTION);
        String sClass = parser.getAttributeValue("", CLASS);
        if (sClass.equals(ParameterRasterLayer.class.toString())) {
            param = ParameterRasterLayer.deserialize(parser);
        } else if (sClass.equals(ParameterVectorLayer.class.toString())) {
            param = ParameterVectorLayer.deserialize(parser);
        } else if (sClass.equals(ParameterTable.class.toString())) {
            param = ParameterTable.deserialize(parser);
        } else if (sClass.equals(ParameterBand.class.toString())) {
            param = ParameterBand.deserialize(parser);
        } else if (sClass.equals(ParameterBoolean.class.toString())) {
            param = ParameterBoolean.deserialize(parser);
        } else if (sClass.equals(ParameterFilepath.class.toString())) {
            param = ParameterFilepath.deserialize(parser);
        } else if (sClass.equals(ParameterNumericalValue.class.toString())) {
            param = ParameterNumericalValue.deserialize(parser);
        } else if (sClass.equals(ParameterPoint.class.toString())) {
            param = ParameterPoint.deserialize(parser);
        } else if (sClass.equals(ParameterSelection.class.toString())) {
            param = ParameterSelection.deserialize(parser);
        } else if (sClass.equals(ParameterString.class.toString())) {
            param = ParameterString.deserialize(parser);
        } else if (sClass.equals(ParameterTableField.class.toString())) {
            param = ParameterTableField.deserialize(parser);
        } else if (sClass.equals(ParameterMultipleInput.class.toString())) {
            param = ParameterMultipleInput.deserialize(parser);
        } else if (sClass.equals(ParameterFixedTable.class.toString())) {
            param = ParameterFixedTable.deserialize(parser);
        } else {
            return null;
        }
        param.setParameterDescription(sDescription);
        param.setParameterName(sName);
        return param;
    }

    public void serialize(KXmlSerializer serializer, String sCoords) throws IOException, NullParameterAdditionalInfoException {
        serializer.text("\n");
        serializer.text("\t\t");
        serializer.startTag(null, INPUT);
        serializer.attribute(null, NAME, this.m_sName);
        serializer.attribute(null, DESCRIPTION, this.m_sDescription);
        serializer.attribute(null, TOOLTIP, this.m_sTooltip);
        serializer.attribute(null, CLASS, this.getClass().toString());
        serializer.attribute(null, RED, Integer.toString(this.getColorR()));
        serializer.attribute(null, GREEN, Integer.toString(this.getColorG()));
        serializer.attribute(null, BLUE, Integer.toString(this.getColorB()));
        serializer.attribute(null, ALPHA, Integer.toString(this.getColorAlpha()));
        serializer.attribute(null, COORDS, sCoords);
        this.serializeAttributes(serializer);
        serializer.text("\n");
        serializer.text("\t\t");
        serializer.endTag(null, INPUT);
    }

    public Parameter getNewInstance() {
        try {
            Parameter param = (Parameter)this.getClass().newInstance();
            param.setParameterDescription(this.m_sDescription);
            param.setParameterTooltip(this.m_sTooltip);
            param.setParameterName(this.m_sName);
            param.setParameterAdditionalInfo(this.m_ParameterAdditionalInfo);
            param.setParameterValue(this.m_ParameterValue);
            return param;
        }
        catch (Exception e) {
            Sextante.addErrorToLog(e);
            return null;
        }
    }

    public abstract boolean isParameterValueCorrect();
}

