/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.line;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class LineEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter firstPoint;
    private final EditingServiceParameter secondPoint;
    private Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;

    public LineEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.firstPoint = new DefaultEditingServiceParameter("first_point", "first_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.secondPoint = new DefaultEditingServiceParameter("second_point", "second_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.firstPoint) == null) {
            return this.firstPoint;
        }
        if (this.values.get(this.secondPoint) == null) {
            return this.secondPoint;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus geometries = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        if (this.values != null && this.values.get(this.firstPoint) != null) {
            Point point = (Point)this.values.get(this.firstPoint);
            try {
                EditingProviderServices editingProviderServices = this.getProviderServices();
                int subtype = editingProviderServices.getSubType(this.featureStore);
                Line line = editingProviderServices.createLine(point, mousePosition, subtype);
                geometries.addStatus((Geometry)line, lineSymbolEditing, "");
                geometries.addStatus((Geometry)line, previewSymbol, "", 0);
                geometries.addStatus((Geometry)point, auxiliaryPointSymbolEditing, "");
                geometries.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
            }
            catch (Exception e) {
                throw new DrawServiceException((Throwable)e);
            }
            return geometries;
        }
        return null;
    }

    public void stop() throws StopServiceException {
        this.values.clear();
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.firstPoint);
        parameters.add(this.secondPoint);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        if (param == this.firstPoint) {
            if (value instanceof Point) {
                this.values.put(param, value);
                return;
            }
        } else if (param == this.secondPoint && value instanceof Point) {
            this.values.put(param, value);
            return;
        }
        throw new InvalidEntryException(null);
    }

    public Geometry finish() throws FinishServiceException {
        Point secondPointValue = (Point)this.values.get(this.secondPoint);
        EditingProviderServices editingProviderServices = this.getProviderServices();
        try {
            DrawingStatus drawingStatus = this.getDrawingStatus(secondPointValue);
            Line line = (Line)drawingStatus.getGeometries().get(0);
            return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)line);
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    public void finishAndStore() throws FinishServiceException {
        Geometry geometry = this.finish();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    public String getName() {
        return "insert-line";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

