/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.daltransform.swing.impl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.daltransform.swing.DataTransformGui;
import org.gvsig.daltransform.swing.impl.AbstractDataTransformWizardPanel;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.LayersIterator;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;

public class SelectDataStoreWizardPanel
extends AbstractDataTransformWizardPanel {
    private static final long serialVersionUID = -1841990357325903449L;
    private JList dataStoreList;
    private JScrollPane dataStoreScrollPane;

    public SelectDataStoreWizardPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.dataStoreScrollPane = new JScrollPane();
        this.dataStoreList = new JList();
        this.setLayout(new GridBagLayout());
        this.dataStoreScrollPane.setViewportView(this.dataStoreList);
        this.dataStoreList.setModel(new DefaultListModel());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.dataStoreScrollPane, gridBagConstraints);
    }

    public void removeFeatureStore(FeatureStore featureStore) {
        DefaultListModel model = (DefaultListModel)this.dataStoreList.getModel();
        for (int i = model.getSize() - 1; i >= 0; --i) {
            if (!((FeatureStoreCombo)model.get(i)).getFeatureStore().equals(featureStore)) continue;
            model.remove(i);
            break;
        }
    }

    private void addDataStores() {
        ((DefaultListModel)this.dataStoreList.getModel()).removeAllElements();
        DataTransformGui dataTransformGui = this.getDataTransformWizard().getDataTransformGui();
        List tables = ProjectManager.getInstance().getCurrentProject().getDocuments(TableManager.TYPENAME);
        for (Document table : tables) {
            if (!dataTransformGui.accept(((TableDocument)table).getStore())) continue;
            ((DefaultListModel)this.dataStoreList.getModel()).addElement(new FeatureStoreCombo(table.getName(), ((TableDocument)table).getStore(), false));
        }
        IWindow window = PluginServices.getMDIManager().getActiveWindow();
        if (window instanceof IView) {
            IView view = (IView)window;
            LayersIterator it = new LayersIterator((FLayer)view.getMapControl().getMapContext().getLayers());
            while (it.hasNext()) {
                FLayer layer = it.nextLayer();
                if (!(layer instanceof FLyrVect)) continue;
                FLyrVect layerVect = (FLyrVect)layer;
                FeatureStore featureStore = layerVect.getFeatureStore();
                boolean found = false;
                for (int i = 0; i < tables.size(); ++i) {
                    TableDocument table = (TableDocument)tables.get(i);
                    if (!table.getStore().equals(featureStore)) continue;
                    found = true;
                }
                if (found || !dataTransformGui.accept(featureStore)) continue;
                ((DefaultListModel)this.dataStoreList.getModel()).addElement(new FeatureStoreCombo(layerVect.getName(), featureStore, true));
            }
        }
    }

    public FeatureStore getSelectedFeatureStore() {
        Object obj = this.dataStoreList.getSelectedValue();
        if (obj != null) {
            return ((FeatureStoreCombo)obj).getFeatureStore();
        }
        return null;
    }

    @Override
    public FeatureStore getFeatureStore() {
        return this.getSelectedFeatureStore();
    }

    public boolean isSelectedFeatureStoreLoaded() {
        Object obj = this.dataStoreList.getSelectedValue();
        if (obj != null) {
            return ((FeatureStoreCombo)obj).isLoaded();
        }
        return false;
    }

    @Override
    public String getPanelTitle() {
        return PluginServices.getText((Object)this, (String)"transform_datastore_selection");
    }

    @Override
    public void updatePanel() {
        this.addDataStores();
        if (this.dataStoreList.getSelectedIndex() == -1) {
            if (this.dataStoreList.getModel().getSize() > 0) {
                this.dataStoreList.setSelectedIndex(0);
                this.getDataTransformWizard().setApplicable(true);
            } else {
                this.getDataTransformWizard().setApplicable(false);
            }
        }
    }

    public boolean isFeatureStoreLayer() {
        Object obj = this.dataStoreList.getSelectedValue();
        if (obj != null) {
            return ((FeatureStoreCombo)obj).isLoaded;
        }
        return false;
    }

    @Override
    public void nextPanel() {
        this.getDataTransformWizard().updateGui();
    }

    private class FeatureStoreCombo {
        private FeatureStore featureStore = null;
        private String name = null;
        private boolean isLoaded = false;

        public FeatureStoreCombo(String name, FeatureStore featureStore, boolean isLoaded) {
            this.name = name;
            this.featureStore = featureStore;
            this.isLoaded = isLoaded;
        }

        public boolean isLoaded() {
            return this.isLoaded;
        }

        public FeatureStore getFeatureStore() {
            return this.featureStore;
        }

        public String toString() {
            return this.name;
        }
    }
}

