/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.daltransform.swing.impl.components;

import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.gvsig.daltransform.swing.impl.components.FeatureTypeAttributeWrapper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureTypeAttributesCombo
extends JComboBox {
    private static final long serialVersionUID = -8843843810490892699L;
    protected static final Logger logger = LoggerFactory.getLogger(FeatureTypeAttributesCombo.class);

    public FeatureTypeAttributesCombo() {
        this.setModel(new DefaultComboBoxModel());
    }

    public int addFeatureAttrubutes(FeatureStore featureStore) throws DataException {
        return this.addFeatureAttributes(featureStore.getDefaultFeatureType());
    }

    public int addFeatureAttributes(FeatureType featureType) {
        this.removeAllItems();
        FeatureAttributeDescriptor[] descriptors = featureType.getAttributeDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            this.addFeatureAttributeDescriptor(descriptors[i]);
        }
        return descriptors.length;
    }

    public int addFeatureAttributes(FeatureType featureType, ArrayList<Integer> types) {
        this.removeAllItems();
        int count = 0;
        FeatureAttributeDescriptor[] descriptors = featureType.getAttributeDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (!this.isIn(descriptors[i].getType(), types)) continue;
            this.addFeatureAttributeDescriptor(descriptors[i]);
            ++count;
        }
        return count;
    }

    private boolean isIn(int t, ArrayList<Integer> list) {
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            if (list.get(i) != t) continue;
            return true;
        }
        return false;
    }

    public void addFeatureAttributeDescriptor(FeatureAttributeDescriptor featureAttributeDescriptor) {
        ((DefaultComboBoxModel)this.getModel()).addElement(new FeatureTypeAttributeWrapper(featureAttributeDescriptor));
    }

    public FeatureAttributeDescriptor getSelectedFeatureAttributeDescriptor() {
        return ((FeatureTypeAttributeWrapper)this.getSelectedItem()).getFeatureAttributeDescriptor();
    }
}

