/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.observer.Notification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.util.CachedValue;
import org.gvsig.tools.util.PropertiesSupport;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.gvsig.tools.util.UnmodifiableBasicSet;
import org.gvsig.tools.util.UnmodifiableBasicSetChained;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStoresRepository
implements StoresRepository {
    protected final Logger LOGGER = LoggerFactory.getLogger(AbstractStoresRepository.class);
    private final String name;
    private final String label;
    protected List<StoresRepository> subrepositories;
    protected Map<String, String> labels;
    private final ObservableHelper observableHelper;
    private final PropertiesSupportHelper propertiesHelper;
    protected Map<String, FeatureTypeCache> featureTypes;
    protected long featureTypeExpireTimeInMillis;
    private DataServerExplorerParameters serverParameters;

    public AbstractStoresRepository(String name) {
        this(name, null);
    }

    public AbstractStoresRepository(String name, String label) {
        this.name = name;
        this.label = label;
        this.subrepositories = null;
        this.observableHelper = new ObservableHelper();
        this.propertiesHelper = new PropertiesSupportHelper();
        this.featureTypeExpireTimeInMillis = 300000L;
    }

    protected abstract DataStoreParameters getMyParameters(String var1);

    protected abstract boolean isEmptyMyRepository();

    protected abstract int getMySize();

    protected abstract UnmodifiableBasicSet<String> getMyKeySet();

    protected FeatureType getMyFeatureType(String name) {
        FeatureTypeCache featureTypeCache;
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        if (this.featureTypes == null) {
            this.featureTypes = new HashMap<String, FeatureTypeCache>();
        }
        if ((featureTypeCache = this.featureTypes.get(name.toLowerCase())) == null) {
            DataStoreParameters parameters = this.getMyParameters(name);
            if (parameters == null) {
                return null;
            }
            featureTypeCache = new FeatureTypeCache(parameters);
            this.featureTypes.put(name.toLowerCase(), featureTypeCache);
        }
        return (FeatureType)featureTypeCache.get();
    }

    protected void setFeatureType(String name, DataStoreParameters parameters, FeatureType ftype) {
        if (this.featureTypes == null) {
            this.featureTypes = new HashMap<String, FeatureTypeCache>();
        }
        FeatureTypeCache featureTypeCache = new FeatureTypeCache(parameters);
        featureTypeCache.set(ftype);
        this.featureTypes.put(name.toLowerCase(), featureTypeCache);
    }

    public void addObserver(Observer o) {
        this.observableHelper.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observableHelper.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observableHelper.deleteObservers();
    }

    protected Notification notifyObservers(String notificationType, Object value) {
        return this.observableHelper.notifyObservers((Observable)this, notificationType, value);
    }

    protected Notification notifyObservers(String notificationType, Object value1, Object value2) {
        return this.observableHelper.notifyObservers((Observable)this, notificationType, value1, value2);
    }

    @Override
    public void add(String name, DataStoreParameters parameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(String name, DataStoreParameters parameters, String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(String name, FeatureStore store) {
        this.add(name, store, null);
    }

    @Override
    public void add(String name, FeatureStore store, String label) {
        FeatureType ft = store.getDefaultFeatureTypeQuietly();
        DataStoreParameters params = store.getParameters();
        this.add(name, params);
        this.setFeatureType(name, params, ft);
        this.setLabel(name, label);
    }

    @Override
    public void remove(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(DataStoreParameters parameters) {
        Iterator<DataStoreParameters> iterator = this.iterator();
        while (iterator.hasNext()) {
            DataStoreParameters currentParameters = iterator.next();
            if (!parameters.isTheSameStore(currentParameters)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(String name) {
        DataStoreParameters parameters = this.getMyParameters(name);
        if (parameters != null) {
            return true;
        }
        for (StoresRepository theRepository : this.getSubrepositories()) {
            if (!theRepository.contains(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getID() {
        return this.name;
    }

    @Override
    public String getLabel() {
        if (StringUtils.isBlank((CharSequence)this.label)) {
            return this.getID();
        }
        return this.label;
    }

    @Override
    public String getLabel(String storeid) {
        String theLabel;
        if (StringUtils.isBlank((CharSequence)storeid)) {
            return null;
        }
        if (this.labels != null && this.labels.containsKey(storeid)) {
            return this.labels.get(storeid);
        }
        if (this.featureTypes != null && this.featureTypes.containsKey(storeid)) {
            FeatureType ft = this.getFeatureType(storeid);
            String theLabel2 = ft.getLabel();
            if (StringUtils.isBlank((CharSequence)theLabel2)) {
                return null;
            }
            this.labels.put(storeid, theLabel2);
            return theLabel2;
        }
        Object[] name_ss = StringUtils.split((String)storeid, (char)'/');
        StoresRepository subrepo = this.getSubrepository(name_ss[0]);
        if (subrepo != null && (theLabel = subrepo.getLabel(StringUtils.join((Object[])name_ss, (String)"/", (int)1, (int)name_ss.length))) != null) {
            return theLabel;
        }
        storeid = name_ss[name_ss.length - 1];
        for (StoresRepository theRepository : this.getSubrepositories()) {
            String theLabel3 = theRepository.getLabel(storeid);
            if (theLabel3 == null) continue;
            return theLabel3;
        }
        return null;
    }

    @Override
    public String getLabelOrName(String name) {
        String theLabel = this.getLabel(name);
        if (StringUtils.isBlank((CharSequence)theLabel)) {
            return name;
        }
        return theLabel;
    }

    protected void setLabel(String name, String label) {
        if (StringUtils.isNotBlank((CharSequence)label)) {
            if (this.labels == null) {
                this.labels = new HashMap<String, String>();
            }
            this.labels.put(name, label);
        }
    }

    @Override
    public Collection<StoresRepository> getSubrepositories() {
        if (this.subrepositories == null) {
            this.subrepositories = new ArrayList<StoresRepository>();
        }
        return this.subrepositories;
    }

    @Override
    public StoresRepository getSubrepository(String Id) {
        for (StoresRepository repo : this.getSubrepositories()) {
            if (repo == null || !StringUtils.equalsIgnoreCase((CharSequence)Id, (CharSequence)repo.getID())) continue;
            return repo;
        }
        return null;
    }

    @Override
    public boolean addRepository(StoresRepository repository) {
        if (this.notifyObservers("addRepository", repository).isCanceled()) {
            return false;
        }
        this.removeRepository(repository.getID());
        this.getSubrepositories().add(repository);
        return true;
    }

    @Override
    public boolean removeRepository(String name) {
        if (this.notifyObservers("removeRepository", name).isCanceled()) {
            return false;
        }
        Iterator<StoresRepository> it = this.getSubrepositories().iterator();
        while (it.hasNext()) {
            StoresRepository repo = it.next();
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)repo.getID())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public DataStoreParameters get(String storeid) {
        if (StringUtils.isBlank((CharSequence)storeid)) {
            return null;
        }
        DataStoreParameters parameters = this.getMyParameters(storeid);
        if (parameters != null) {
            return parameters;
        }
        Object[] name_ss = StringUtils.split((String)storeid, (char)'/');
        StoresRepository subrepo = this.getSubrepository(name_ss[0]);
        if (subrepo != null && (parameters = (DataStoreParameters)subrepo.get(StringUtils.join((Object[])name_ss, (String)"/", (int)1, (int)name_ss.length))) != null) {
            return parameters;
        }
        storeid = name_ss[name_ss.length - 1];
        for (StoresRepository theRepository : this.getSubrepositories()) {
            parameters = (DataStoreParameters)theRepository.get(storeid);
            if (parameters == null) continue;
            return parameters;
        }
        return null;
    }

    public PropertiesSupport getProperties(String name) {
        return new PropertiesSupport(){

            public Object getProperty(String name) {
                return null;
            }

            public void setProperty(String name, Object value) {
            }

            public Map<String, Object> getProperties() {
                return Collections.EMPTY_MAP;
            }
        };
    }

    @Override
    public DataStore getStore(String storeid) {
        PropertiesSupport properties = this.getProperties(storeid);
        if (properties != null && StringUtils.equalsIgnoreCase((CharSequence)Objects.toString(properties.getProperty("ignoreDALResource")), (CharSequence)"true")) {
            return this.getStore(storeid, true);
        }
        return this.getStore(storeid, false);
    }

    @Override
    public String getStoreId(String label) {
        DataStoreParameters parameters = this.getMyParameters(label);
        if (parameters != null) {
            String string;
            DataStore store = null;
            try {
                store = DALLocator.getDataManager().openStore(parameters.getProviderName(), parameters, true);
                string = store.getName();
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException("Can't open store '" + label + "'.", ex);
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(store);
                    throw throwable;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)store);
            return string;
        }
        for (StoresRepository theRepository : this.getSubrepositories()) {
            String s = theRepository.getStoreId(label);
            if (s == null) continue;
            s = this.getID() + "/" + s;
            return s;
        }
        return null;
    }

    public DataStore getStore(String storeid, boolean ignoreDALResource) {
        DataStore store;
        if (StringUtils.isBlank((CharSequence)storeid)) {
            return null;
        }
        DataStoreParameters parameters = this.getMyParameters(storeid);
        if (parameters != null) {
            try {
                DataStore store2 = DALLocator.getDataManager().openStore(parameters.getProviderName(), parameters, ignoreDALResource);
                return store2;
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't open store '" + storeid + "'.", ex);
            }
        }
        Object[] name_ss = StringUtils.split((String)storeid, (char)'/');
        StoresRepository subrepo = this.getSubrepository(name_ss[0]);
        if (subrepo != null && (store = subrepo.getStore(StringUtils.join((Object[])name_ss, (String)"/", (int)1, (int)name_ss.length))) != null) {
            return store;
        }
        storeid = name_ss[name_ss.length - 1];
        for (StoresRepository theRepository : this.getSubrepositories()) {
            DataStore store3 = theRepository.getStore(storeid);
            if (store3 == null) continue;
            return store3;
        }
        return null;
    }

    @Override
    public String getRepositoryIDOfStore(String storeid) {
        String id;
        if (StringUtils.isBlank((CharSequence)storeid)) {
            return null;
        }
        DataStoreParameters parameters = this.getMyParameters(storeid);
        if (parameters != null) {
            return this.getID();
        }
        Object[] name_ss = StringUtils.split((String)storeid, (char)'/');
        StoresRepository subrepo = this.getSubrepository(name_ss[0]);
        if (subrepo != null && (id = subrepo.getRepositoryIDOfStore(StringUtils.join((Object[])name_ss, (String)"/", (int)1, (int)name_ss.length))) != null) {
            return id;
        }
        storeid = name_ss[name_ss.length - 1];
        for (StoresRepository theRepository : this.getSubrepositories()) {
            String id2 = theRepository.getRepositoryIDOfStore(storeid);
            if (id2 == null) continue;
            return id2;
        }
        return null;
    }

    @Override
    public StoresRepository getRepositoryOfStore(String storeid) {
        StoresRepository repo;
        if (StringUtils.isBlank((CharSequence)storeid)) {
            return null;
        }
        DataStoreParameters parameters = this.getMyParameters(storeid);
        if (parameters != null) {
            return this;
        }
        Object[] name_ss = StringUtils.split((String)storeid, (char)'/');
        StoresRepository subrepo = this.getSubrepository(name_ss[0]);
        if (subrepo != null && (repo = subrepo.getRepositoryOfStore(StringUtils.join((Object[])name_ss, (String)"/", (int)1, (int)name_ss.length))) != null) {
            return repo;
        }
        storeid = name_ss[name_ss.length - 1];
        for (StoresRepository theRepository : this.getSubrepositories()) {
            StoresRepository repo2 = theRepository.getRepositoryOfStore(storeid);
            if (repo2 == null) continue;
            return repo2;
        }
        return null;
    }

    @Override
    public FeatureType getFeatureType(String storeid) {
        if (StringUtils.isBlank((CharSequence)storeid)) {
            return null;
        }
        FeatureType featureType = this.getMyFeatureType(storeid);
        if (featureType != null) {
            return featureType;
        }
        Object[] name_ss = StringUtils.split((String)storeid, (char)'/');
        StoresRepository subrepo = this.getSubrepository(name_ss[0]);
        if (subrepo != null && (featureType = subrepo.getFeatureType(StringUtils.join((Object[])name_ss, (String)"/", (int)1, (int)name_ss.length))) != null) {
            return featureType;
        }
        storeid = name_ss[name_ss.length - 1];
        for (StoresRepository theRepository : this.getSubrepositories()) {
            featureType = theRepository.getFeatureType(storeid);
            if (featureType == null) continue;
            return featureType;
        }
        return null;
    }

    public boolean containsKey(String key) {
        DataStoreParameters parameters = this.getMyParameters(key);
        if (parameters != null) {
            return true;
        }
        for (StoresRepository theRepository : this.getSubrepositories()) {
            if (!theRepository.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public UnmodifiableBasicSet<String> keySet() {
        ArrayList<UnmodifiableBasicSet> sets = new ArrayList<UnmodifiableBasicSet>();
        UnmodifiableBasicSet keyset = this.getMyKeySet();
        if (keyset != null && !keyset.isEmpty()) {
            sets.add(keyset);
        }
        for (StoresRepository theRepository : this.getSubrepositories()) {
            if (theRepository == null || (keyset = theRepository.keySet()) == null || keyset.isEmpty()) continue;
            sets.add(keyset);
        }
        if (sets.isEmpty()) {
            return UnmodifiableBasicSet.EMPTY_UNMODIFIABLEBASICSET;
        }
        if (sets.size() == 1) {
            return (UnmodifiableBasicSet)sets.get(0);
        }
        return new UnmodifiableBasicSetChained(sets.toArray(new UnmodifiableBasicSet[sets.size()]));
    }

    public Map<String, DataStoreParameters> toMap() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        if (!this.isEmptyMyRepository()) {
            return false;
        }
        for (StoresRepository theRepository : this.getSubrepositories()) {
            if (theRepository.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int size() {
        int sz = 0;
        if (!this.isEmptyMyRepository()) {
            sz = this.getMySize();
        }
        for (StoresRepository theRepository : this.getSubrepositories()) {
            sz += theRepository.size();
        }
        return sz;
    }

    public Iterator<DataStoreParameters> iterator() {
        final Iterator it = this.keySet().iterator();
        return new Iterator<DataStoreParameters>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public DataStoreParameters next() {
                String name = (String)it.next();
                return AbstractStoresRepository.this.get(name);
            }
        };
    }

    public Map<String, Object> getProperties() {
        return this.propertiesHelper.getProperties();
    }

    public Object getProperty(String name) {
        return this.propertiesHelper.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.propertiesHelper.setProperty(name, value);
    }

    @Override
    public Set<String> keySetDeep() {
        TreeSet<String> keys = new TreeSet<String>();
        UnmodifiableBasicSet<String> localkeys = this.getMyKeySet();
        if (localkeys != null && !localkeys.isEmpty()) {
            for (String key : localkeys) {
                keys.add(key);
            }
        }
        for (StoresRepository theRepository : this.getSubrepositories()) {
            if (theRepository == null) continue;
            UnmodifiableBasicSet subrepokeys = theRepository.keySet();
            if (subrepokeys != null && !subrepokeys.isEmpty()) {
                for (String key : subrepokeys) {
                    keys.add(key);
                }
            }
            keys.add(theRepository.getID());
        }
        return keys;
    }

    @Override
    public Set<String> keySetShallow() {
        TreeSet<String> keys = new TreeSet<String>();
        UnmodifiableBasicSet<String> localkeys = this.getMyKeySet();
        if (localkeys != null && !localkeys.isEmpty()) {
            for (String key : localkeys) {
                keys.add(key);
            }
        }
        for (StoresRepository theRepository : this.getSubrepositories()) {
            if (theRepository == null) continue;
            keys.add(theRepository.getID());
        }
        return keys;
    }

    @Override
    public DataServerExplorerParameters getServerParameters() {
        return this.serverParameters;
    }

    protected void setServerParameters(DataServerExplorerParameters serverParameters) {
        this.serverParameters = serverParameters;
    }

    protected boolean isMyServer(DataServerExplorerParameters serverParameters) {
        if (this.serverParameters == null || serverParameters == null) {
            return false;
        }
        return this.serverParameters.isTheSameServerExplorer(serverParameters);
    }

    @Override
    public StoresRepository getSubrepository(DataServerExplorer server) {
        if (server == null) {
            return null;
        }
        return this.getSubrepository(server.getParameters());
    }

    @Override
    public StoresRepository getSubrepository(DataServerExplorerParameters serverParameters) {
        if (this.isMyServer(serverParameters)) {
            return this;
        }
        for (StoresRepository repo : this.getSubrepositories()) {
            StoresRepository r;
            if (repo == null || (r = repo.getSubrepository(serverParameters)) == null) continue;
            return repo;
        }
        return null;
    }

    public String toString() {
        return this.getLabel();
    }

    private class FeatureTypeCache
    extends CachedValue<FeatureType> {
        private final DataStoreParameters parameters;

        public FeatureTypeCache(DataStoreParameters parameters) {
            super(AbstractStoresRepository.this.featureTypeExpireTimeInMillis);
            this.parameters = parameters;
        }

        protected void reload() {
            DataStore store;
            block5: {
                store = null;
                store = DALLocator.getDataManager().openStore(this.parameters.getProviderName(), this.parameters, false);
                if (store instanceof FeatureStore) break block5;
                DisposeUtils.disposeQuietly((Disposable)store);
                return;
            }
            try {
                FeatureType ft = ((FeatureStore)store).getDefaultFeatureType();
                this.setValue(ft);
                AbstractStoresRepository.this.setLabel(AbstractStoresRepository.this.name, ft.getLabel());
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException("Can't get feature type of '" + AbstractStoresRepository.this.name + "'.", ex);
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(store);
                    throw throwable;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }
}

